/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.imcms.mapping.Mapper;
import imcode.server.document.Profile;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileMapper
extends Mapper<Profile> {
    public ProfileMapper(Database database) {
        super(database);
    }

    @Override
    protected String getTableName() {
        return "profiles";
    }

    @Override
    protected String getIdColumnName() {
        return "profile_id";
    }

    @Override
    protected String getDefaultOrderBy() {
        return "name";
    }

    @Override
    protected List<String> getDataColumnNames() {
        return Arrays.asList("name", "document_name");
    }

    @Override
    protected Profile convertRow(ResultSet rs) throws SQLException {
        return new SimpleProfile(rs.getString("profile_id"), rs.getString("name"), rs.getString("document_name"));
    }

    @Override
    protected Object[][] getDataValues(Profile profile) {
        return new Object[][]{{"name", profile.getName()}, {"document_name", profile.getDocumentName()}};
    }

    public static class SimpleProfile
    implements Profile {
        private final String id;
        private final String name;
        private final String documentName;

        public SimpleProfile(String id, String name, String documentName) {
            this.id = id;
            this.name = name;
            this.documentName = documentName;
        }

        public String getName() {
            return this.name;
        }

        public String getDocumentName() {
            return this.documentName;
        }

        public Object getId() {
            return this.id;
        }
    }
}

