/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.imcms.api.DocumentProperty;
import com.imcode.imcms.api.DocumentVersion;
import com.imcode.imcms.api.Meta;
import com.imcode.imcms.dao.MetaDao;
import com.imcode.imcms.mapping.AliasAlreadyExistsInternalException;
import com.imcode.imcms.mapping.DocumentCreatingVisitor;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.DocumentSaveException;
import com.imcode.imcms.mapping.DocumentSavingVisitor;
import com.imcode.imcms.mapping.NoPermissionInternalException;
import imcode.server.Imcms;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.RoleIdToDocumentPermissionSetTypeMappings;
import imcode.server.document.textdocument.NoPermissionToAddDocumentToMenuException;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.util.Date;
import java.util.Map;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Transactional;

public class DocumentSaver {
    private DocumentMapper documentMapper;
    private MetaDao metaDao;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void saveDocumentFragment(DocumentDomainObject document, UserDomainObject user, HibernateCallback hibernateCallback) throws NoPermissionInternalException, DocumentSaveException {
        this.checkDocumentForSave(document);
        try {
            HibernateTemplate template = (HibernateTemplate)Imcms.getServices().getSpringBean("hibernateTemplate");
            template.execute(hibernateCallback);
            Date lastModifiedDatetime = Utility.truncateDateToMinutePrecision(document.getActualModifiedDatetime());
            Date modifiedDatetime = Utility.truncateDateToMinutePrecision(document.getModifiedDatetime());
            boolean modifiedDatetimeUnchanged = lastModifiedDatetime.equals(modifiedDatetime);
            if (modifiedDatetimeUnchanged) {
                modifiedDatetime = this.documentMapper.getClock().getCurrentDate();
            }
        }
        finally {
            this.documentMapper.invalidateDocument(document);
        }
    }

    @Transactional
    public void publishWorkingDocument(DocumentDomainObject document, UserDomainObject user) throws DocumentSaveException {
        try {
            this.metaDao.publishWorkingDocument(document.getMeta().getId());
        }
        catch (RuntimeException e) {
            throw new DocumentSaveException(e);
        }
        finally {
            this.documentMapper.invalidateDocument(document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public void updateDocument(DocumentDomainObject document, DocumentDomainObject oldDocument, UserDomainObject user) throws NoPermissionInternalException, DocumentSaveException {
        this.checkDocumentForSave(document);
        try {
            Date lastModifiedDatetime = Utility.truncateDateToMinutePrecision(document.getActualModifiedDatetime());
            Date modifiedDatetime = Utility.truncateDateToMinutePrecision(document.getModifiedDatetime());
            boolean modifiedDatetimeUnchanged = lastModifiedDatetime.equals(modifiedDatetime);
            if (modifiedDatetimeUnchanged) {
                document.setModifiedDatetime(this.documentMapper.getClock().getCurrentDate());
            }
            if (user.canEditPermissionsFor(oldDocument)) {
                this.newUpdateDocumentRolePermissions(document, user, oldDocument);
                this.documentMapper.getDocumentPermissionSetMapper().saveRestrictedDocumentPermissionSets(document, user, oldDocument);
            }
            DocumentSavingVisitor savingVisitor = new DocumentSavingVisitor(oldDocument, this.documentMapper.getImcmsServices(), user);
            this.saveMeta(document);
            document.accept(savingVisitor);
        }
        finally {
            this.documentMapper.invalidateDocument(document);
        }
    }

    @Transactional
    public void createWorkingDocumentFromExisting(DocumentDomainObject document, UserDomainObject user) throws NoPermissionInternalException, DocumentSaveException {
        Meta meta = document.getMeta();
        Integer documentId = meta.getId();
        document = document.clone();
        document.setAlias(null);
        document.setDependenciesMetaIdToNull();
        document.setId(documentId);
        DocumentCreatingVisitor visitor = new DocumentCreatingVisitor(this.documentMapper.getImcmsServices(), user);
        TextDocumentDomainObject textDocument = (TextDocumentDomainObject)document;
        DocumentVersion documentVersion = this.metaDao.createWorkingVersion(documentId, user.getId());
        textDocument.getMeta().setVersion(documentVersion);
        visitor.updateTextDocumentTexts(textDocument, null, user);
        visitor.updateTextDocumentImages(textDocument, null, user);
    }

    @Transactional
    public void saveNewDocument(UserDomainObject user, DocumentDomainObject document, boolean copying) throws NoPermissionToAddDocumentToMenuException, DocumentSaveException {
        boolean inheritRestrictedPermissions;
        this.checkDocumentForSave(document);
        this.documentMapper.setCreatedAndModifiedDatetimes(document, new Date());
        boolean bl = inheritRestrictedPermissions = !user.isSuperAdminOrHasFullPermissionOn(document) && !copying;
        if (inheritRestrictedPermissions) {
            document.getPermissionSets().setRestricted1(document.getPermissionSetsForNewDocuments().getRestricted1());
            document.getPermissionSets().setRestricted2(document.getPermissionSetsForNewDocuments().getRestricted2());
        }
        this.newUpdateDocumentRolePermissions(document, user, null);
        this.documentMapper.getDocumentPermissionSetMapper().saveRestrictedDocumentPermissionSets(document, user, null);
        document.setDependenciesMetaIdToNull();
        Meta meta = this.saveMeta(document);
        DocumentVersion version = this.metaDao.createWorkingVersion(meta.getId(), user.getId());
        document.getMeta().setVersion(version);
        document.accept(new DocumentCreatingVisitor(this.documentMapper.getImcmsServices(), user));
        this.documentMapper.invalidateDocument(document);
    }

    private Meta saveMeta(DocumentDomainObject document) {
        Meta meta = document.getMeta();
        meta.setPublicationStatusInt(document.getPublicationStatus().asInt());
        if (meta.getId() == null) {
            meta.setDocumentType(document.getDocumentTypeId());
            meta.setActivate(1);
        }
        this.metaDao.saveMeta(meta);
        return meta;
    }

    private void checkDocumentForSave(DocumentDomainObject document) throws NoPermissionInternalException, DocumentSaveException {
        this.documentMapper.getCategoryMapper().checkMaxDocumentCategoriesOfType(document);
        this.checkIfAliasAlreadyExist(document);
    }

    void newUpdateDocumentRolePermissions(DocumentDomainObject document, UserDomainObject user, DocumentDomainObject oldDocument) {
        RoleIdToDocumentPermissionSetTypeMappings.Mapping mapping;
        int i;
        RoleIdToDocumentPermissionSetTypeMappings mappings = new RoleIdToDocumentPermissionSetTypeMappings();
        if (null != oldDocument) {
            RoleIdToDocumentPermissionSetTypeMappings.Mapping[] oldDocumentMappings = oldDocument.getRoleIdsMappedToDocumentPermissionSetTypes().getMappings();
            for (i = 0; i < oldDocumentMappings.length; ++i) {
                mapping = oldDocumentMappings[i];
                mappings.setPermissionSetTypeForRole(mapping.getRoleId(), DocumentPermissionSetTypeDomainObject.NONE);
            }
        }
        RoleIdToDocumentPermissionSetTypeMappings.Mapping[] documentMappings = document.getRoleIdsMappedToDocumentPermissionSetTypes().getMappings();
        for (i = 0; i < documentMappings.length; ++i) {
            mapping = documentMappings[i];
            mappings.setPermissionSetTypeForRole(mapping.getRoleId(), mapping.getDocumentPermissionSetType());
        }
        RoleIdToDocumentPermissionSetTypeMappings.Mapping[] mappingsArray = mappings.getMappings();
        Map<Integer, Integer> roleIdToPermissionSetIdMap = document.getMeta().getRoleIdToPermissionSetIdMap();
        for (int i2 = 0; i2 < mappingsArray.length; ++i2) {
            RoleIdToDocumentPermissionSetTypeMappings.Mapping mapping2 = mappingsArray[i2];
            RoleId roleId = mapping2.getRoleId();
            DocumentPermissionSetTypeDomainObject documentPermissionSetType = mapping2.getDocumentPermissionSetType();
            if (null != oldDocument && !user.canSetDocumentPermissionSetTypeForRoleIdOnDocument(documentPermissionSetType, roleId, oldDocument)) continue;
            if (documentPermissionSetType.equals(DocumentPermissionSetTypeDomainObject.NONE)) {
                roleIdToPermissionSetIdMap.remove(roleId.intValue());
                continue;
            }
            roleIdToPermissionSetIdMap.put(roleId.intValue(), documentPermissionSetType.getId());
        }
    }

    public void checkIfAliasAlreadyExist(DocumentDomainObject document) throws AliasAlreadyExistsInternalException {
        DocumentProperty property;
        String alias = document.getAlias();
        if (alias != null && (property = this.metaDao.getAliasProperty(alias)) != null) {
            Integer documentId = document.getId();
            if (!property.getDocumentId().equals(documentId)) {
                throw new AliasAlreadyExistsInternalException(String.format("Alias %s is allready given to document %d.", alias, documentId));
            }
        }
    }

    public DocumentMapper getDocumentMapper() {
        return this.documentMapper;
    }

    public void setDocumentMapper(DocumentMapper documentMapper) {
        this.documentMapper = documentMapper;
    }

    public MetaDao getMetaDao() {
        return this.metaDao;
    }

    public void setMetaDao(MetaDao metaDao) {
        this.metaDao = metaDao;
    }
}

