/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.imcms.dao.MetaDao;
import com.imcode.imcms.mapping.DocumentStoringVisitor;
import com.imcode.imcms.mapping.orm.HtmlReference;
import com.imcode.imcms.mapping.orm.UrlReference;
import imcode.server.ImcmsServices;
import imcode.server.document.HtmlDocumentDomainObject;
import imcode.server.document.UrlDocumentDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;

public class DocumentCreatingVisitor
extends DocumentStoringVisitor {
    private UserDomainObject currentUser;

    public DocumentCreatingVisitor(ImcmsServices services, UserDomainObject currentUser) {
        super(services);
        this.currentUser = currentUser;
    }

    public void visitHtmlDocument(HtmlDocumentDomainObject document) {
        HtmlReference reference = new HtmlReference();
        reference.setMetaId(document.getMeta().getId());
        reference.setHtml(document.getHtml());
        MetaDao dao = (MetaDao)((Object)this.services.getSpringBean("metaDao"));
        dao.saveHtmlReference(reference);
    }

    public void visitUrlDocument(UrlDocumentDomainObject document) {
        UrlReference reference = new UrlReference();
        reference.setMetaId(document.getMeta().getId());
        reference.setUrlTarget("");
        reference.setUrlText("");
        reference.setUrlLanguagePrefix("");
        reference.setUrlFrameName("");
        reference.setUrl(document.getUrl());
        MetaDao dao = (MetaDao)((Object)this.services.getSpringBean("metaDao"));
        dao.saveUrlReference(reference);
    }

    public void visitTextDocument(TextDocumentDomainObject textDocument) {
        this.updateTextDocumentTemplateNames(textDocument, null, null);
        this.updateTextDocumentTexts(textDocument, null, this.currentUser);
        this.updateTextDocumentImages(textDocument, null, null);
        this.updateTextDocumentIncludes(textDocument);
        this.updateTextDocumentMenus(textDocument, null, null);
        this.updateTextDocumentContentLoops(textDocument, null, null);
    }
}

