/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.flow;

import com.imcode.imcms.flow.DispatchCommand;
import imcode.util.HttpSessionAttribute;
import imcode.util.HttpSessionUtils;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class PageFlow
implements Serializable,
HttpSessionAttribute {
    public static final String REQUEST_PARAMETER__PAGE = "flowpage";
    public static final String REQUEST_PARAMETER__CANCEL_BUTTON = "cancel";
    public static final String REQUEST_PARAMETER__OK_BUTTON = "ok";
    public static final String REQUEST_ATTRIBUTE_OR_PARAMETER__FLOW = "flow";
    protected DispatchCommand returnCommand;
    private String sessionAttributeName;

    protected PageFlow(DispatchCommand returnCommand) {
        this.returnCommand = returnCommand;
    }

    public String getSessionAttributeName() {
        return this.sessionAttributeName;
    }

    public void setSessionAttributeName(String sessionAttributeName) {
        this.sessionAttributeName = sessionAttributeName;
    }

    public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSessionUtils.setSessionAttributeAndSetNameInRequestAttribute(this, request, REQUEST_ATTRIBUTE_OR_PARAMETER__FLOW);
        String page = request.getParameter(REQUEST_PARAMETER__PAGE);
        if (null != request.getParameter(REQUEST_PARAMETER__CANCEL_BUTTON)) {
            this.dispatchReturn(request, response);
        } else if (null == page) {
            this.dispatchToFirstPage(request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__OK_BUTTON)) {
            this.dispatchOk(request, response, page);
        } else {
            this.dispatchFromPage(request, response, page);
        }
    }

    protected void dispatchReturn(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpSessionUtils.removeSessionAttribute(request, this.getSessionAttributeName());
        this.returnCommand.dispatch(request, response);
    }

    protected abstract void dispatchToFirstPage(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;

    protected abstract void dispatchOk(HttpServletRequest var1, HttpServletResponse var2, String var3) throws IOException, ServletException;

    protected abstract void dispatchFromPage(HttpServletRequest var1, HttpServletResponse var2, String var3) throws IOException, ServletException;
}

