/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.Language;
import com.imcode.imcms.api.Role;
import imcode.server.Imcms;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;

public class User {
    private UserDomainObject internalUser;

    UserDomainObject getInternal() {
        return this.internalUser;
    }

    User(UserDomainObject internalUser) {
        this.internalUser = internalUser;
    }

    public int getId() {
        return this.internalUser.getId();
    }

    public String getLoginName() {
        return this.internalUser.getLoginName();
    }

    public String getCompany() {
        return this.internalUser.getCompany();
    }

    public String getFirstName() {
        return this.internalUser.getFirstName();
    }

    public String getLastName() {
        return this.internalUser.getLastName();
    }

    public String getTitle() {
        return this.internalUser.getTitle();
    }

    public String getAddress() {
        return this.internalUser.getAddress();
    }

    public String getCity() {
        return this.internalUser.getCity();
    }

    public String getZip() {
        return this.internalUser.getZip();
    }

    public String getCountry() {
        return this.internalUser.getCountry();
    }

    public String getCountyCouncil() {
        return this.internalUser.getProvince();
    }

    public String getProvince() {
        return this.internalUser.getProvince();
    }

    public void setProvince(String province) {
        this.internalUser.setProvince(province);
    }

    public String getEmailAddress() {
        return this.internalUser.getEmailAddress();
    }

    public String getOtherPhone() {
        return this.internalUser.getOtherPhone();
    }

    public String getWorkPhone() {
        return this.internalUser.getWorkPhone();
    }

    public String getMobilePhone() {
        return this.internalUser.getMobilePhone();
    }

    public String getHomePhone() {
        return this.internalUser.getHomePhone();
    }

    public boolean isActive() {
        return this.internalUser.isActive();
    }

    public String toString() {
        return this.getLoginName();
    }

    public boolean hasRole(Role role) {
        return this.internalUser.hasRoleId(role.getInternal().getId());
    }

    public boolean isDefaultUser() {
        return this.internalUser.isDefaultUser();
    }

    public boolean isSuperAdmin() {
        return this.internalUser.isSuperAdmin();
    }

    public boolean isUserAdmin() {
        return this.internalUser.isUserAdmin();
    }

    public boolean canEdit(Document document) {
        return this.internalUser.canEdit(document.getInternal());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User user = (User)o;
        return !(this.internalUser != null ? !this.internalUser.equals(user.internalUser) : user.internalUser != null);
    }

    public int hashCode() {
        return this.internalUser != null ? this.internalUser.hashCode() : 0;
    }

    public Role[] getRoles() {
        RoleId[] roleDOs = this.internalUser.getRoleIds();
        Role[] roles = new Role[roleDOs.length];
        for (int i = 0; i < roleDOs.length; ++i) {
            roles[i] = new Role(Imcms.getServices().getImcmsAuthenticatorAndUserAndRoleMapper().getRole(roleDOs[i]));
        }
        return roles;
    }

    public void setRoles(Role[] roles) {
        RoleId[] roleIds = new RoleId[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            roleIds[i] = roles[i].getInternal().getId();
        }
        this.internalUser.setRoleIds(roleIds);
    }

    public void addRole(Role role) {
        this.internalUser.addRoleId(role.getInternal().getId());
    }

    public void removeRole(Role role) {
        this.internalUser.removeRoleId(role.getInternal().getId());
    }

    public void setActive(boolean active) {
        this.internalUser.setActive(active);
    }

    public void setAddress(String address) {
        this.internalUser.setAddress(address);
    }

    public void setCity(String city) {
        this.internalUser.setCity(city);
    }

    public void setCompany(String company) {
        this.internalUser.setCompany(company);
    }

    public void setCountry(String country) {
        this.internalUser.setCountry(country);
    }

    public void setCountyCouncil(String countyCouncil) {
        this.internalUser.setProvince(countyCouncil);
    }

    public void setEmailAddress(String emailAddress) {
        this.internalUser.setEmailAddress(emailAddress);
    }

    public void setFaxPhone(String faxphone) {
        this.internalUser.setFaxPhone(faxphone);
    }

    public String getFaxPhone() {
        return this.internalUser.getFaxPhone();
    }

    public void setFirstName(String firstName) {
        this.internalUser.setFirstName(firstName);
    }

    public void setHomePhone(String homephone) {
        this.internalUser.setHomePhone(homephone);
    }

    public void setLastName(String lastName) {
        this.internalUser.setLastName(lastName);
    }

    public void setLoginName(String loginName) {
        this.internalUser.setLoginName(loginName);
    }

    public void setMobilePhone(String mobilephone) {
        this.internalUser.setMobilePhone(mobilephone);
    }

    public void setOtherPhone(String otherphone) {
        this.internalUser.setOtherPhone(otherphone);
    }

    public void setPassword(String password) {
        this.internalUser.setPassword(password);
    }

    public void setTitle(String title) {
        this.internalUser.setTitle(title);
    }

    public void setWorkPhone(String workphone) {
        this.internalUser.setWorkPhone(workphone);
    }

    public void setZip(String zip) {
        this.internalUser.setZip(zip);
    }

    public void setLanguage(Language language) {
        this.internalUser.setLanguageIso639_2(language.getIsoCode639_2());
    }

    public Language getLanguage() {
        return Language.getLanguageByISO639_2(this.internalUser.getLanguageIso639_2());
    }

    public String getSessionId() {
        return this.internalUser.getSessionId();
    }

    public void setSessionId(String sessionId) {
        this.internalUser.setSessionId(sessionId);
    }
}

