/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazilyLoadedObject<E extends Copyable<E>>
implements Serializable,
Cloneable {
    private Loader<E> loader;
    private E object;

    public LazilyLoadedObject(Loader<E> loader) {
        this.loader = loader;
    }

    public Object get() {
        this.load();
        return this.object;
    }

    public void load() {
        if (!this.isLoaded()) {
            E loaded = this.loader.load();
            this.object = loaded.copy();
            this.setLoaded();
        }
    }

    private boolean isLoaded() {
        return null == this.loader;
    }

    public Object clone() throws CloneNotSupportedException {
        LazilyLoadedObject clone = (LazilyLoadedObject)super.clone();
        if (null != this.object) {
            clone.object = this.object.copy();
        }
        return clone;
    }

    public void set(E o) {
        this.setLoaded();
        this.object = o;
    }

    private void setLoaded() {
        this.loader = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.load();
        out.defaultWriteObject();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Copyable<C extends Copyable>
    extends Serializable {
        public C copy();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Loader<L extends Copyable>
    extends Serializable {
        public L load();
    }
}

