/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.parser;

import imcode.server.parser.Element;
import imcode.server.parser.SimpleElement;
import imcode.server.parser.SimpleText;
import imcode.server.parser.TagParser;
import java.util.LinkedList;
import javax.servlet.http.HttpServletRequest;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class NodeList
extends LinkedList {
    private static Pattern elementPattern;

    public NodeList(String data, HttpServletRequest request, TagParser tagParser) {
        Perl5Matcher patternMatcher = new Perl5Matcher();
        PatternMatcherInput input = new PatternMatcherInput(data);
        int lastEndOffset = 0;
        while (patternMatcher.contains(input, elementPattern)) {
            MatchResult matchResult = patternMatcher.getMatch();
            if (matchResult.beginOffset(0) > lastEndOffset) {
                this.add(new SimpleText(data.substring(lastEndOffset, matchResult.beginOffset(0))));
            }
            lastEndOffset = matchResult.endOffset(0);
            this.add(this.createElementNode((PatternMatcher)patternMatcher, request, tagParser));
        }
        if (data.length() > lastEndOffset) {
            this.add(new SimpleText(data.substring(lastEndOffset)));
        }
    }

    private Element createElementNode(PatternMatcher patternMatcher, HttpServletRequest request, TagParser tagParser) {
        MatchResult matchResult = patternMatcher.getMatch();
        String name = matchResult.group(1);
        String attributes_string = matchResult.group(2);
        String content = matchResult.group(3);
        return new SimpleElement(name, tagParser.parseAttributes(attributes_string, patternMatcher, request), new NodeList(content, request, tagParser));
    }

    static {
        try {
            Perl5Compiler patternCompiler = new Perl5Compiler();
            elementPattern = patternCompiler.compile("<\\?imcms:(\\w+)\\b(.*?)\\s*\\?>(.*?)<\\?\\/imcms:\\1\\s*\\?>", 32784);
        }
        catch (MalformedPatternException malformedPatternException) {
            // empty catch block
        }
    }
}

