/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.InsertIntoTableDatabaseCommand;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.db.handlers.CollectionHandler;
import com.imcode.db.handlers.RowTransformer;
import com.imcode.imcms.db.StringArrayArrayResultSetHandler;
import com.imcode.imcms.mapping.DocumentMapper;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.TemplateGroupDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.commons.collections.functors.NullPredicate;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateMapper {
    private static final String SPROC_GET_TEMPLATES_IN_GROUP = "GetTemplatesInGroup";
    private static final String SPROC_GET_TEMPLATE_GROUPS_FOR_USER = "GetTemplategroupsForUser";
    private static final String SPROC_GET_TEMPLATE_GROUPS = "GetTemplateGroups";
    private Database database;
    private ImcmsServices services;

    public TemplateMapper(ImcmsServices service) {
        this.database = service.getDatabase();
        this.services = service;
    }

    public void addTemplateToGroup(TemplateDomainObject template, TemplateGroupDomainObject templateGroup) {
        this.database.execute((DatabaseCommand)new SqlUpdateCommand("INSERT INTO templates_cref (group_id,template_name) VALUES(?,?)", new Object[]{templateGroup.getId(), template.getName()}));
    }

    public List<TemplateDomainObject> getAllTemplatesExceptOne(TemplateDomainObject template) {
        List<TemplateDomainObject> allTemplates = this.getAllTemplates();
        allTemplates.remove(template);
        return allTemplates;
    }

    public String createHtmlOptionListOfTemplateGroups(TemplateGroupDomainObject selectedTemplateGroup) {
        TemplateGroupDomainObject[] templateGroups = this.services.getTemplateMapper().getAllTemplateGroups();
        return this.createHtmlOptionListOfTemplateGroups(Arrays.asList(templateGroups), selectedTemplateGroup);
    }

    public String createHtmlOptionListOfTemplateGroups(Collection<TemplateGroupDomainObject> templateGroups, TemplateGroupDomainObject selectedTemplateGroup) {
        String temps = "";
        for (TemplateGroupDomainObject templateGroup : templateGroups) {
            boolean selected = null != selectedTemplateGroup && selectedTemplateGroup.equals(templateGroup);
            temps = temps + "<option value=\"" + templateGroup.getId() + "\"" + (selected ? " selected" : "") + ">" + templateGroup.getName() + "</option>";
        }
        return temps;
    }

    public String createHtmlOptionListOfTemplates(Iterable<TemplateDomainObject> templates, TemplateDomainObject selectedTemplate) throws IOException {
        String temps = "";
        for (TemplateDomainObject template : templates) {
            boolean selected = selectedTemplate != null && selectedTemplate.equals(template);
            temps = temps + "<option value=\"" + StringEscapeUtils.escapeHtml((String)template.getName()) + "\"" + (selected ? " selected" : "") + ">" + StringEscapeUtils.escapeHtml((String)template.getName()) + "</option>";
        }
        return temps;
    }

    public String createHtmlOptionListOfTemplatesWithDocumentCount(UserDomainObject user) {
        String htmlStr = "";
        TemplateMapper templateMapper = this.services.getTemplateMapper();
        List<TemplateDomainObject> templates = templateMapper.getAllTemplates();
        for (TemplateDomainObject template : templates) {
            ArrayList<String> tags = new ArrayList<String>();
            tags.add("#template_name#");
            tags.add(StringEscapeUtils.escapeHtml((String)template.getName()));
            tags.add("#docs#");
            tags.add("" + templateMapper.getCountOfDocumentsUsingTemplate(template));
            tags.add("#template_id#");
            tags.add(StringEscapeUtils.escapeHtml((String)template.getName()));
            htmlStr = htmlStr + this.services.getAdminTemplate("template_list_row.html", user, tags);
        }
        return htmlStr;
    }

    public void deleteTemplate(TemplateDomainObject template) {
        this.database.execute((DatabaseCommand)new SqlUpdateCommand("delete from templates_cref where template_name = ?", (Object[])new String[]{template.getName()}));
        File f = this.getTemplateFile(template);
        if (f.exists()) {
            f.delete();
        }
    }

    private File getTemplateFile(TemplateDomainObject template) {
        return new File(this.getTemplateDirectory(), template.getFileName());
    }

    public void deleteTemplateGroup(int grp_id) {
        Object[] parameters1 = new String[]{"" + grp_id};
        this.database.execute((DatabaseCommand)new SqlUpdateCommand("delete from templates_cref where group_id = ?", parameters1));
        Object[] parameters = new String[]{"" + grp_id};
        this.database.execute((DatabaseCommand)new SqlUpdateCommand("delete from templategroups where group_id = ?", parameters));
    }

    public TemplateGroupDomainObject[] getAllTemplateGroups() {
        Object[] parameters = new String[]{};
        String[][] sprocResult = (String[][])this.services.getProcedureExecutor().executeProcedure(SPROC_GET_TEMPLATE_GROUPS, parameters, new StringArrayArrayResultSetHandler());
        return this.createTemplateGroupsFromSqlResult(sprocResult);
    }

    public TemplateGroupDomainObject[] getAllTemplateGroupsAvailableForUserOnDocument(UserDomainObject user, int metaId) {
        String[][] sprocResult = this.sprocGetTemplateGroupsForUser(user, metaId);
        return this.createTemplateGroupsFromSqlResult(sprocResult);
    }

    public Set getAllTemplateGroupIds() {
        return (Set)this.database.execute((DatabaseCommand)new SqlQueryCommand("SELECT group_id FROM templategroups", null, (ResultSetHandler)new CollectionHandler(new HashSet(), new RowTransformer(){

            public Object createObjectFromResultSetRow(ResultSet resultSet) throws SQLException {
                return new Integer(resultSet.getInt(1));
            }

            public Class getClassOfCreatedObjects() {
                return Integer.class;
            }
        })));
    }

    public List<TemplateDomainObject> getAllTemplates() {
        File[] templateFiles = this.getTemplateDirectory().listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                String fileName = pathname.getName().toLowerCase();
                return pathname.isFile() && (fileName.endsWith(".jsp") || fileName.endsWith(".jspx") || fileName.endsWith(".html"));
            }
        });
        TreeSet<TemplateDomainObject> templates = new TreeSet<TemplateDomainObject>();
        for (File templateFile : templateFiles) {
            String nameWithoutExtension = StringUtils.substringBeforeLast((String)templateFile.getName(), (String)".");
            templates.add(new TemplateDomainObject(nameWithoutExtension, templateFile.getName()));
        }
        return new ArrayList<TemplateDomainObject>(templates);
    }

    private int getCountOfDocumentsUsingTemplate(TemplateDomainObject template) {
        String queryResult = (String)this.database.execute((DatabaseCommand)new SqlQueryCommand("SELECT COUNT(meta_id) FROM text_docs WHERE template_name = ?", (Object[])new String[]{"" + template.getName()}, Utility.SINGLE_STRING_HANDLER));
        return Integer.parseInt(queryResult);
    }

    public DocumentDomainObject[] getDocumentsUsingTemplate(TemplateDomainObject template) {
        String[][] temp = (String[][])this.database.execute((DatabaseCommand)new SqlQueryCommand("select td.meta_id, meta_headline from text_docs td join meta m on td.meta_id = m.meta_id where template_name = ? order by td.meta_id", (Object[])new String[]{template.getName()}, Utility.STRING_ARRAY_ARRAY_HANDLER));
        DocumentMapper documentMapper = this.services.getDocumentMapper();
        DocumentDomainObject[] documents = new DocumentDomainObject[temp.length];
        for (int i = 0; i < documents.length; ++i) {
            int documentId = Integer.parseInt(temp[i][0]);
            documents[i] = documentMapper.getPublishedDocument(documentId);
        }
        return documents;
    }

    public TemplateDomainObject getTemplateByName(String templateName) {
        String[] extensions;
        for (String extension : extensions = new String[]{"jsp", "jspx", "html"}) {
            String templateFileName = templateName + "." + extension;
            File templateFile = new File(this.getTemplateDirectory(), templateFileName);
            if (!templateFile.exists()) continue;
            return new TemplateDomainObject(templateName, templateFileName);
        }
        return null;
    }

    public TemplateGroupDomainObject getTemplateGroupById(int templateGroupId) {
        String sqlStr = "SELECT group_id,group_name FROM templategroups WHERE group_id = ?";
        Object[] parameters = new String[]{"" + templateGroupId};
        String[] queryResult = (String[])this.database.execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.STRING_ARRAY_HANDLER));
        return this.createTemplateGroupFromSqlResultRow(queryResult);
    }

    public TemplateGroupDomainObject getTemplateGroupByName(String name) {
        Object[] parameters = new String[]{name};
        String[] sqlResultRow = (String[])this.database.execute((DatabaseCommand)new SqlQueryCommand("select group_id, group_name from templategroups where group_name = ?", parameters, Utility.STRING_ARRAY_HANDLER));
        return this.createTemplateGroupFromSqlResultRow(sqlResultRow);
    }

    public List<TemplateDomainObject> getTemplatesInGroup(TemplateGroupDomainObject templateGroup) {
        return (List)CollectionUtils.select((Collection)((Collection)this.services.getProcedureExecutor().executeProcedure(SPROC_GET_TEMPLATES_IN_GROUP, new String[]{"" + templateGroup.getId()}, (ResultSetHandler)new CollectionHandler(new ArrayList(), new RowTransformer(){

            public Object createObjectFromResultSetRow(ResultSet resultSet) throws SQLException {
                return TemplateMapper.this.getTemplateByName(resultSet.getString(1));
            }

            public Class getClassOfCreatedObjects() {
                return TemplateDomainObject.class;
            }
        }))), (Predicate)NotPredicate.getInstance((Predicate)NullPredicate.INSTANCE));
    }

    public List<TemplateDomainObject> getTemplatesNotInGroup(TemplateGroupDomainObject templateGroup) {
        List<TemplateDomainObject> templatesInGroup = this.getTemplatesInGroup(templateGroup);
        HashSet<TemplateDomainObject> allTemplates = new HashSet<TemplateDomainObject>(this.getAllTemplates());
        allTemplates.removeAll(templatesInGroup);
        ArrayList<TemplateDomainObject> templatesNotInGroup = new ArrayList<TemplateDomainObject>(allTemplates);
        Collections.sort(templatesNotInGroup);
        return templatesNotInGroup;
    }

    public void removeTemplateFromGroup(TemplateDomainObject template, TemplateGroupDomainObject templateGroup) {
        this.database.execute((DatabaseCommand)new SqlUpdateCommand("DELETE FROM templates_cref WHERE group_id = ? AND template_name = ?", (Object[])new String[]{"" + templateGroup.getId(), template.getName()}));
    }

    public boolean renameTemplate(String templateName, String newNameForTemplate) {
        if (null != this.getTemplateByName(newNameForTemplate)) {
            return false;
        }
        TemplateDomainObject template = this.getTemplateByName(templateName);
        while (null != template) {
            File templateFile = this.getTemplateFile(template);
            String extension = StringUtils.substringAfterLast((String)template.getFileName(), (String)".");
            String newFilename = newNameForTemplate + "." + extension;
            if (templateFile.renameTo(new File(this.getTemplateDirectory(), newFilename))) {
                this.replaceAllUsagesOfTemplate(template, new TemplateDomainObject(newNameForTemplate, newFilename));
            }
            template = this.getTemplateByName(templateName);
        }
        return true;
    }

    private File getTemplateDirectory() {
        return new File(Imcms.getPath(), "WEB-INF/templates/text");
    }

    public void renameTemplateGroup(TemplateGroupDomainObject templateGroup, String newName) {
        String sqlStr = "update templategroups\nset group_name = ?\nwhere group_id = ?\n";
        Object[] parameters = new String[]{newName, "" + templateGroup.getId()};
        this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlStr, parameters));
    }

    public void replaceAllUsagesOfTemplate(TemplateDomainObject template, TemplateDomainObject newTemplate) {
        if (null != template && null != newTemplate) {
            DocumentDomainObject[] documentsUsingTemplate = this.getDocumentsUsingTemplate(template);
            String sqlStr = "update text_docs set template_name = ? where template_name = ?";
            Object[] parameters = new String[]{"" + newTemplate.getName(), "" + template.getName()};
            this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlStr, parameters));
            for (DocumentDomainObject document : documentsUsingTemplate) {
                this.services.getDocumentMapper().invalidateDocument(document);
            }
        }
    }

    private String[][] sprocGetTemplateGroupsForUser(UserDomainObject user, int meta_id) {
        Object[] parameters = new String[]{String.valueOf(meta_id), String.valueOf(user.getId())};
        return (String[][])this.services.getProcedureExecutor().executeProcedure(SPROC_GET_TEMPLATE_GROUPS_FOR_USER, parameters, new StringArrayArrayResultSetHandler());
    }

    private TemplateGroupDomainObject createTemplateGroupFromSqlResultRow(String[] sqlResultRow) {
        if (0 == sqlResultRow.length) {
            return null;
        }
        int templateGroupId = Integer.parseInt(sqlResultRow[0]);
        String templateGroupName = sqlResultRow[1];
        return new TemplateGroupDomainObject(templateGroupId, templateGroupName);
    }

    private TemplateGroupDomainObject[] createTemplateGroupsFromSqlResult(String[][] sprocResult) {
        TemplateGroupDomainObject[] templateGroups = new TemplateGroupDomainObject[sprocResult.length];
        for (int i = 0; i < sprocResult.length; ++i) {
            templateGroups[i] = this.createTemplateGroupFromSqlResultRow(sprocResult[i]);
        }
        return templateGroups;
    }

    public void createTemplateGroup(String name) {
        this.database.execute((DatabaseCommand)new InsertIntoTableDatabaseCommand("templategroups", (Object[][])new Object[][]{{"group_name", name}}));
    }

    public int saveTemplate(String name, String file_name, InputStream templateData, boolean overwrite) {
        File f = new File(this.getTemplateDirectory(), name + "." + StringUtils.substringAfterLast((String)file_name, (String)"."));
        if (f.exists() && !overwrite) {
            return -1;
        }
        try {
            FileOutputStream fw = new FileOutputStream(f);
            IOUtils.copy((InputStream)templateData, (OutputStream)fw);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            return -2;
        }
        return 0;
    }

    public String getTemplateData(String templateName) throws IOException {
        return this.services.getFileCache().getCachedFileString(this.getTemplateFile(this.getTemplateByName(templateName)));
    }

    public List getTemplateGroups(Set<Integer> templateGroupIds) {
        ArrayList<TemplateGroupDomainObject> allowedTemplateGroups = new ArrayList<TemplateGroupDomainObject>(templateGroupIds.size());
        for (Integer allowedTemplateGroupId : templateGroupIds) {
            TemplateGroupDomainObject templateGroup = this.getTemplateGroupById(allowedTemplateGroupId);
            if (null == templateGroup) continue;
            allowedTemplateGroups.add(templateGroup);
        }
        Collections.sort(allowedTemplateGroups);
        return allowedTemplateGroups;
    }

    public boolean templateGroupContains(TemplateGroupDomainObject templateGroup, TemplateDomainObject template) {
        List<TemplateDomainObject> templates = this.getTemplatesInGroup(templateGroup);
        for (TemplateDomainObject t : templates) {
            if (!t.getName().equals(template.getName())) continue;
            return true;
        }
        return false;
    }
}

