/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.user.RoleId;
import imcode.util.ShouldNotBeThrownException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;

public class RoleIdToDocumentPermissionSetTypeMappings
implements Serializable,
Cloneable {
    HashMap map = new HashMap();

    protected RoleIdToDocumentPermissionSetTypeMappings clone() {
        try {
            RoleIdToDocumentPermissionSetTypeMappings clone = (RoleIdToDocumentPermissionSetTypeMappings)super.clone();
            clone.map = (HashMap)this.map.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new ShouldNotBeThrownException(e);
        }
    }

    public void setPermissionSetTypeForRole(RoleId roleId, DocumentPermissionSetTypeDomainObject documentPermissionSetType) {
        if (null == documentPermissionSetType) {
            this.map.remove(roleId);
        } else {
            this.map.put(roleId, documentPermissionSetType);
        }
    }

    public DocumentPermissionSetTypeDomainObject getPermissionSetTypeForRole(RoleId roleId) {
        DocumentPermissionSetTypeDomainObject documentPermissionSetType = (DocumentPermissionSetTypeDomainObject)this.map.get(roleId);
        if (null == documentPermissionSetType) {
            documentPermissionSetType = DocumentPermissionSetTypeDomainObject.NONE;
        }
        return documentPermissionSetType;
    }

    public Mapping[] getMappings() {
        Collection pairs = CollectionUtils.collect(this.map.entrySet(), (Transformer)new Transformer(){

            public Object transform(Object object) {
                Map.Entry entry = (Map.Entry)object;
                return new Mapping((RoleId)entry.getKey(), (DocumentPermissionSetTypeDomainObject)entry.getValue());
            }
        });
        return pairs.toArray(new Mapping[pairs.size()]);
    }

    public static class Mapping {
        private final RoleId roleId;
        private final DocumentPermissionSetTypeDomainObject documentPermissionSetType;

        public Mapping(RoleId roleId, DocumentPermissionSetTypeDomainObject documentPermissionSetType) {
            this.roleId = roleId;
            this.documentPermissionSetType = documentPermissionSetType;
        }

        public DocumentPermissionSetTypeDomainObject getDocumentPermissionSetType() {
            return this.documentPermissionSetType;
        }

        public RoleId getRoleId() {
            return this.roleId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Mapping mapping = (Mapping)o;
            return this.roleId.equals(mapping.roleId);
        }

        public int hashCode() {
            return this.roleId.hashCode();
        }
    }
}

