/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import com.imcode.imcms.api.Document;
import java.util.Date;
import org.apache.lucene.document.DateField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;

public abstract class LifeCyclePhase {
    public static final LifeCyclePhase NEW = new LifeCyclePhase("new"){

        public Query asQuery(Date time) {
            return LifeCyclePhase.getStatusQuery(Document.PublicationStatus.NEW);
        }
    };
    public static final LifeCyclePhase DISAPPROVED = new LifeCyclePhase("disapproved"){

        public Query asQuery(Date time) {
            return LifeCyclePhase.getStatusQuery(Document.PublicationStatus.DISAPPROVED);
        }
    };
    public static final LifeCyclePhase UNPUBLISHED = new LifeCyclePhase("unpublished"){

        public Query asQuery(Date time) {
            return LifeCyclePhase.add(LifeCyclePhase.getApprovedBooleanQuery(), (Query)LifeCyclePhase.getPublicationEndRangeQuery(time));
        }
    };
    public static final LifeCyclePhase APPROVED = new LifeCyclePhase("approved"){

        public Query asQuery(Date time) {
            return LifeCyclePhase.subtract(LifeCyclePhase.getApprovedNonUnpublishedQuery(time), (Query)LifeCyclePhase.getPublicationStartRangeQuery(time));
        }
    };
    public static final LifeCyclePhase ARCHIVED = new LifeCyclePhase("archived"){

        public Query asQuery(Date time) {
            return LifeCyclePhase.add(LifeCyclePhase.getPublishedQuery(time), (Query)LifeCyclePhase.getArchivedRangeQuery(time));
        }
    };
    public static final LifeCyclePhase PUBLISHED = new LifeCyclePhase("published"){

        public Query asQuery(Date time) {
            return LifeCyclePhase.subtract(LifeCyclePhase.getPublishedQuery(time), (Query)LifeCyclePhase.getArchivedRangeQuery(time));
        }
    };
    public static final LifeCyclePhase[] ALL = new LifeCyclePhase[]{NEW, APPROVED, DISAPPROVED, PUBLISHED, ARCHIVED, UNPUBLISHED};
    private final String name;

    private static BooleanQuery add(BooleanQuery query, Query otherQuery) {
        query.add(otherQuery, true, false);
        return query;
    }

    private static BooleanQuery subtract(BooleanQuery minuend, Query subtrahend) {
        minuend.add(subtrahend, false, true);
        return minuend;
    }

    private static RangeQuery getPublicationStartRangeQuery(Date now) {
        return LifeCyclePhase.getDateRangeQuery("publication_start_datetime", now);
    }

    private static RangeQuery getPublicationEndRangeQuery(Date now) {
        return LifeCyclePhase.getDateRangeQuery("publication_end_datetime", now);
    }

    private static RangeQuery getArchivedRangeQuery(Date now) {
        return LifeCyclePhase.getDateRangeQuery("archived_datetime", now);
    }

    private static RangeQuery getDateRangeQuery(String field, Date now) {
        return new RangeQuery(new Term(field, DateField.MIN_DATE_STRING()), new Term(field, DateField.dateToString((Date)now)), true);
    }

    private static BooleanQuery getPublishedQuery(Date now) {
        return LifeCyclePhase.add(LifeCyclePhase.getApprovedNonUnpublishedQuery(now), (Query)LifeCyclePhase.getPublicationStartRangeQuery(now));
    }

    private static BooleanQuery getApprovedNonUnpublishedQuery(Date now) {
        return LifeCyclePhase.subtract(LifeCyclePhase.getApprovedBooleanQuery(), (Query)LifeCyclePhase.getPublicationEndRangeQuery(now));
    }

    private static BooleanQuery getApprovedBooleanQuery() {
        return LifeCyclePhase.add(new BooleanQuery(), (Query)LifeCyclePhase.getStatusQuery(Document.PublicationStatus.APPROVED));
    }

    private static TermQuery getStatusQuery(Document.PublicationStatus publicationStatus) {
        return new TermQuery(new Term("status", publicationStatus.toString()));
    }

    private LifeCyclePhase(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public abstract Query asQuery(Date var1);
}

