/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.Imcms;
import imcode.server.document.DocumentPermission;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.DocumentTypeDomainObject;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.util.LazilyLoadedObject;
import imcode.util.ShouldNotBeThrownException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class DocumentPermissionSetDomainObject
implements Serializable,
LazilyLoadedObject.Copyable,
Cloneable {
    public static final DocumentPermissionSetDomainObject NONE = new TextDocumentPermissionSetDomainObject(DocumentPermissionSetTypeDomainObject.NONE){

        public boolean hasPermission(DocumentPermission permission) {
            return false;
        }
    };
    public static final DocumentPermissionSetDomainObject READ = new TextDocumentPermissionSetDomainObject(DocumentPermissionSetTypeDomainObject.READ){

        public boolean hasPermission(DocumentPermission permission) {
            return false;
        }
    };
    public static final DocumentPermissionSetDomainObject FULL = new TextDocumentPermissionSetDomainObject(DocumentPermissionSetTypeDomainObject.FULL){

        public Set getAllowedTemplateGroupIds() {
            return Imcms.getServices().getTemplateMapper().getAllTemplateGroupIds();
        }

        public Set getAllowedDocumentTypeIds() {
            return DocumentTypeDomainObject.getAllDocumentTypeIdsSet();
        }

        public boolean hasPermission(DocumentPermission permission) {
            return true;
        }
    };
    static final DocumentPermission EDIT = new DocumentPermission("edit");
    private static final String PERMISSION_SET_NAME__FULL = "Full";
    private static final String PERMISSION_SET_NAME__RESTRICTED_1 = "Restricted One";
    private static final String PERMISSION_SET_NAME__RESTRICTED_2 = "Restricted Two";
    private static final String PERMISSION_SET_NAME__READ = "Read";
    private static final String PERMISSION_SET_NAME__NONE = "None";
    private DocumentPermissionSetTypeDomainObject type;
    private HashSet permissions = new HashSet();
    static final DocumentPermission EDIT_DOCUMENT_INFORMATION = new DocumentPermission("editDocumentInformation");
    static final DocumentPermission EDIT_PERMISSIONS = new DocumentPermission("editPermissions");
    public static final int EDIT_DOCINFO_PERMISSION_ID = 1;
    public static final int EDIT_PERMISSIONS_PERMISSION_ID = 4;
    public static final int EDIT_DOCUMENT_PERMISSION_ID = 65536;

    public DocumentPermissionSetDomainObject(DocumentPermissionSetTypeDomainObject typeId) {
        this.type = typeId;
    }

    void setPermission(DocumentPermission permission, boolean b) {
        if (b) {
            this.permissions.add(permission);
        } else {
            this.permissions.remove(permission);
        }
    }

    public boolean hasPermission(DocumentPermission permission) {
        return this.permissions.contains(permission);
    }

    public DocumentPermissionSetTypeDomainObject getType() {
        return this.type;
    }

    public String getTypeName() {
        return DocumentPermissionSetDomainObject.getName(this.type);
    }

    private static String getName(DocumentPermissionSetTypeDomainObject userPermissionSetId) {
        String result = DocumentPermissionSetTypeDomainObject.FULL.equals(userPermissionSetId) ? PERMISSION_SET_NAME__FULL : (DocumentPermissionSetTypeDomainObject.RESTRICTED_1.equals(userPermissionSetId) ? PERMISSION_SET_NAME__RESTRICTED_1 : (DocumentPermissionSetTypeDomainObject.RESTRICTED_2.equals(userPermissionSetId) ? PERMISSION_SET_NAME__RESTRICTED_2 : (DocumentPermissionSetTypeDomainObject.READ.equals(userPermissionSetId) ? PERMISSION_SET_NAME__READ : PERMISSION_SET_NAME__NONE)));
        return result;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getTypeName());
        if (DocumentPermissionSetTypeDomainObject.RESTRICTED_1.equals(this.type) || DocumentPermissionSetTypeDomainObject.RESTRICTED_2.equals(this.type)) {
            buff.append(" (").append("editDocumentInformation=" + this.getEditDocumentInformation() + ", ").append("editPermissions=" + this.getEditPermissions() + ", ").append(")");
        }
        return buff.toString();
    }

    public boolean getEditDocumentInformation() {
        return this.hasPermission(EDIT_DOCUMENT_INFORMATION);
    }

    public void setEditDocumentInformation(boolean editDocumentInformation) {
        this.setPermission(EDIT_DOCUMENT_INFORMATION, editDocumentInformation);
    }

    public boolean getEditPermissions() {
        return this.hasPermission(EDIT_PERMISSIONS);
    }

    public void setEditPermissions(boolean editPermissions) {
        this.setPermission(EDIT_PERMISSIONS, editPermissions);
    }

    public void setFromBits(int permissionBits) {
        this.setEditDocumentInformation(0 != (permissionBits & 1));
        this.setEditPermissions(0 != (permissionBits & 4));
        this.setEdit(0 != (permissionBits & 0x10000));
    }

    public boolean getEdit() {
        return this.hasPermission(EDIT);
    }

    public void setEdit(boolean edit) {
        this.setPermission(EDIT, edit);
    }

    public LazilyLoadedObject.Copyable copy() {
        try {
            return (LazilyLoadedObject.Copyable)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ShouldNotBeThrownException(e);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        DocumentPermissionSetDomainObject clone = (DocumentPermissionSetDomainObject)super.clone();
        clone.permissions = (HashSet)this.permissions.clone();
        return clone;
    }

    public boolean isEmpty() {
        return this.permissions.isEmpty();
    }
}

