/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.tags;

import com.imcode.imcms.api.Content;
import com.imcode.imcms.api.ContentLoop;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.parser.ParserParameters;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

public class ContentLoopTag
extends BodyTagSupport {
    public static final int STEP = 100000;
    private int no;
    private int baseIndex;
    private String indexVar;
    Iterator<Content> contentsIterator;
    private Properties attributes = new Properties();
    private String label;

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        ParserParameters parserParameters = ParserParameters.fromRequest(request);
        TextDocumentDomainObject document = (TextDocumentDomainObject)parserParameters.getDocumentRequest().getDocument();
        ContentLoop loop = document.getContentLoop(this.no);
        if (loop == null) {
            return 0;
        }
        this.contentsIterator = loop.getContents().iterator();
        return this.handleNextContent() ? 1 : 0;
    }

    private boolean handleNextContent() {
        if (!this.contentsIterator.hasNext()) {
            this.pageContext.removeAttribute(this.indexVar);
            return false;
        }
        Content content = this.contentsIterator.next();
        int sequenceIndex = content.getSequenceIndex();
        int index = this.baseIndex + sequenceIndex * 100000;
        this.pageContext.setAttribute(this.indexVar, (Object)index);
        return true;
    }

    public int doAfterBody() throws JspException {
        return this.handleNextContent() ? 2 : 0;
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    public void setNo(int no) {
        this.no = no;
    }

    public int getNo() {
        return this.no;
    }

    public void setMode(String mode) {
        this.attributes.setProperty("mode", mode);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setPre(String pre) {
        this.attributes.setProperty("pre", pre);
    }

    public void setPost(String post) {
        this.attributes.setProperty("post", post);
    }

    public int getBaseIndex() {
        return this.baseIndex;
    }

    public void setBaseIndex(int baseIndex) {
        this.baseIndex = baseIndex;
    }

    public String getIndexVar() {
        return this.indexVar;
    }

    public void setIndexVar(String indexVar) {
        this.indexVar = indexVar;
    }
}

