/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.util.HumanReadable;
import com.imcode.util.MultipartHttpServletRequest;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import imcode.util.io.FileUtility;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FileAdmin
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger((String)"FileAdmin");
    private static final int BUFFER_SIZE = 65536;
    private static final String ADMIN_TEMPLATE_FILE_ADMIN_COPY_OVERWRIGHT_WARNING = "FileAdminCopyOverwriteWarning.html";
    private static final String ADMIN_TEMPLATE_FILE_ADMIN_MOVE_OVERWRITE_WARNING = "FileAdminMoveOverwriteWarning.html";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            Utility.redirectToStartDocument(req, res);
            return;
        }
        Utility.setNoCache(res);
        File dir1 = null;
        File dir2 = null;
        File[] roots = this.getRoots();
        if (roots.length > 0) {
            dir1 = roots[0];
            if (roots.length > 1) {
                dir2 = roots[1];
            }
        }
        this.outputFileAdmin(res, user, dir1, dir2);
    }

    private boolean isUnderRoot(File path, File[] roots) throws IOException {
        for (int i = 0; i < roots.length; ++i) {
            if (!FileUtility.directoryIsAncestorOfOrEqualTo(roots[i], path)) continue;
            return true;
        }
        return false;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            Utility.redirectToStartDocument(req, res);
            return;
        }
        Utility.setNoCache(res);
        MultipartHttpServletRequest mp = new MultipartHttpServletRequest(req);
        if (mp.getParameter("cancel") != null) {
            res.sendRedirect("AdminManager");
            return;
        }
        File[] roots = this.getRoots();
        File dir1 = this.getContextRelativeDirectoryFromRequest((HttpServletRequest)mp, "dir1");
        File dir2 = this.getContextRelativeDirectoryFromRequest((HttpServletRequest)mp, "dir2");
        if (!this.isUnderRoot(dir1, roots) || !this.isUnderRoot(dir2, roots)) {
            this.doGet(req, res);
            return;
        }
        String[] files1 = mp.getParameterValues("files1");
        String[] files2 = mp.getParameterValues("files2");
        String name = mp.getParameter("name");
        boolean outputHasBeenHandled = false;
        if (mp.getParameter("change1") != null) {
            dir1 = this.changeDir(files1, dir1, roots);
        } else if (mp.getParameter("change2") != null) {
            dir2 = this.changeDir(files2, dir2, roots);
        } else if (mp.getParameter("mkdir1") != null) {
            outputHasBeenHandled = this.makeDirectory(name, dir1, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("mkdir2") != null) {
            outputHasBeenHandled = this.makeDirectory(name, dir2, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("delete1") != null) {
            outputHasBeenHandled = this.delete(dir1, files1, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("delete2") != null) {
            outputHasBeenHandled = this.delete(dir2, files2, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("deleteok") != null) {
            this.deleteOk((HttpServletRequest)mp, roots);
        } else if (mp.getParameter("upload1") != null) {
            outputHasBeenHandled = this.upload(mp, dir1, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("upload2") != null) {
            outputHasBeenHandled = this.upload(mp, dir2, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("download1") != null) {
            outputHasBeenHandled = this.download(files1, dir1, res);
        } else if (mp.getParameter("download2") != null) {
            outputHasBeenHandled = this.download(files2, dir2, res);
        } else if (mp.getParameter("rename1") != null) {
            outputHasBeenHandled = this.rename(files1, name, dir1, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("rename2") != null) {
            outputHasBeenHandled = this.rename(files2, name, dir2, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("copy1") != null) {
            outputHasBeenHandled = this.copy(files1, dir1, dir2, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("copy2") != null) {
            outputHasBeenHandled = this.copy(files2, dir2, dir1, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("copyok") != null) {
            this.copyOk((HttpServletRequest)mp, roots);
        } else if (mp.getParameter("move1") != null) {
            outputHasBeenHandled = this.move(files1, dir1, dir2, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("move2") != null) {
            outputHasBeenHandled = this.move(files2, dir2, dir1, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("moveok") != null) {
            this.moveOk((HttpServletRequest)mp, roots);
        }
        if (!outputHasBeenHandled) {
            this.outputFileAdmin(res, user, dir1, dir2);
        }
    }

    private File getContextRelativeDirectoryFromRequest(HttpServletRequest request, String parameter) throws IOException {
        File webappPath = Imcms.getPath();
        String dirParameter = request.getParameter(parameter);
        return new File(webappPath, dirParameter).getCanonicalFile();
    }

    private File[] getRoots() {
        String rootpaths = Imcms.getServices().getConfig().getFileAdminRootPaths();
        ArrayList<File> rootList = new ArrayList<File>();
        if (rootpaths != null) {
            StringTokenizer st = new StringTokenizer(rootpaths, ":;");
            int tokenCount = st.countTokens();
            for (int i = 0; i < tokenCount; ++i) {
                String oneRoot = st.nextToken().trim();
                File oneRootFile = FileUtility.getFileFromWebappRelativePath(oneRoot);
                if (!oneRootFile.isDirectory()) continue;
                rootList.add(oneRootFile);
            }
        }
        return rootList.toArray(new File[rootList.size()]);
    }

    private boolean move(String[] files, File sourceDir, File destDir, File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        boolean handledOutput = false;
        if (files != null && !sourceDir.equals(destDir)) {
            File[] sourceFileTree = this.makeFileTreeList(this.makeAbsoluteFileList(sourceDir, files), false);
            File[] relativeSourceFileTree = this.makeRelativeFileList(sourceDir, sourceFileTree);
            StringBuffer optionList = new StringBuffer();
            StringBuffer fileList = this.buildWarningOptions(relativeSourceFileTree, destDir, optionList);
            if (optionList.length() > 0) {
                this.outputMoveOverwriteWarning(optionList.toString(), sourceDir, destDir, fileList.toString(), dir1, dir2, res, user, imcref);
                handledOutput = true;
            } else {
                File[] destFiles = this.makeAbsoluteFileList(destDir, relativeSourceFileTree);
                for (int i = 0; i < sourceFileTree.length; ++i) {
                    File destFile = destFiles[i];
                    destFile.getParentFile().mkdirs();
                    File sourceFile = sourceFileTree[i];
                    if (sourceFile.isFile()) {
                        FileUtils.copyFile((File)sourceFile, (File)destFile);
                    }
                    if (sourceFile.length() != destFile.length()) continue;
                    FileUtils.forceDelete((File)sourceFile);
                }
            }
        }
        return handledOutput;
    }

    private String createWarningFileOptionString(File destFile) throws IOException {
        File webAppPath = Imcms.getPath();
        return FileUtility.relativizeFile(webAppPath, destFile).getPath() + (destFile.isDirectory() ? File.separator : " [" + destFile.length() + "]");
    }

    private boolean copy(String[] files, File sourceDir, File destDir, File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        boolean handledOutput = false;
        if (files != null && !sourceDir.equals(destDir)) {
            File[] sourceFileTree = this.makeFileTreeList(this.makeAbsoluteFileList(sourceDir, files), true);
            File[] relativeSourceFileTree = this.makeRelativeFileList(sourceDir, sourceFileTree);
            StringBuffer optionList = new StringBuffer();
            StringBuffer fileList = this.buildWarningOptions(relativeSourceFileTree, destDir, optionList);
            if (optionList.length() > 0) {
                this.ouputCopyOverwriteWarning(optionList.toString(), sourceDir, destDir, fileList.toString(), dir1, dir2, res, user, imcref);
                handledOutput = true;
            } else {
                File[] destFileTree = this.makeAbsoluteFileList(destDir, relativeSourceFileTree);
                for (int i = 0; i < sourceFileTree.length; ++i) {
                    File sourceFile = sourceFileTree[i];
                    File destFile = destFileTree[i];
                    if (sourceFile.isDirectory()) {
                        destFile.mkdir();
                        continue;
                    }
                    FileUtils.copyFile((File)sourceFile, (File)destFile);
                }
            }
        }
        return handledOutput;
    }

    private StringBuffer buildWarningOptions(File[] relativeSourceFileTree, File destDir, StringBuffer optionList) throws IOException {
        StringBuffer fileList = new StringBuffer();
        for (int i = 0; i < relativeSourceFileTree.length; ++i) {
            File destFile = new File(destDir, relativeSourceFileTree[i].getPath());
            fileList.append(relativeSourceFileTree[i]).append(File.pathSeparator);
            if (!destFile.exists()) continue;
            String optionString = this.createWarningFileOptionString(destFile);
            optionList.append("<option>").append(optionString).append("</option>");
        }
        return fileList;
    }

    private boolean rename(String[] files, String name, File dir, File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        boolean handledOutput = false;
        if (files != null && files.length == 1) {
            if (name != null && name.length() > 0) {
                File oldFilename = new File(dir, files[0]);
                File newFilename = new File(dir, name);
                if (oldFilename.exists()) {
                    oldFilename.renameTo(newFilename);
                }
            } else {
                this.outputBlankFilenameError(dir1, dir2, res, user, imcref);
                handledOutput = true;
            }
        }
        return handledOutput;
    }

    private boolean download(String[] files, File dir, HttpServletResponse res) throws IOException {
        boolean handledOutput = false;
        if (files != null && files.length == 1) {
            File file = new File(dir, files[0]);
            try {
                int bytes_read;
                res.setContentType("application/octet-stream");
                res.setHeader("ContentLoop-Disposition", "attachment; filename=\"" + file.getName() + '\"');
                BufferedInputStream fin = new BufferedInputStream(new FileInputStream(file));
                res.setContentLength(fin.available());
                byte[] buffer = new byte[65536];
                ServletOutputStream out = res.getOutputStream();
                while ((bytes_read = fin.read(buffer)) != -1) {
                    out.write(buffer, 0, bytes_read);
                }
                handledOutput = true;
            }
            catch (FileNotFoundException ex) {
                LOG.debug((Object)"Download failed", (Throwable)ex);
            }
        }
        return handledOutput;
    }

    private boolean delete(File dir, String[] files, File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        boolean handledOutput = false;
        File[] farray = this.makeFileTreeList(this.makeAbsoluteFileList(dir, files), false);
        File[] filelist = this.makeRelativeFileList(dir, farray);
        if (filelist != null && filelist.length > 0) {
            this.outputDeleteWarning(filelist, dir1, dir2, dir, res, user, imcref);
            handledOutput = true;
        }
        return handledOutput;
    }

    private boolean makeDirectory(String name, File dir, File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        boolean handledOutput = false;
        if (name != null && name.length() > 0) {
            File newname = new File(dir, name);
            if (!newname.exists()) {
                newname.mkdir();
            }
        } else {
            this.outputBlankFilenameError(dir1, dir2, res, user, imcref);
            handledOutput = true;
        }
        return handledOutput;
    }

    private boolean upload(MultipartHttpServletRequest mp, File destDir, File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        File uniqueFile;
        boolean handledOutput = false;
        MultipartHttpServletRequest.DataSourceFileItem parameterFileItem = mp.getParameterFileItem("file");
        if (parameterFileItem == null || parameterFileItem.getSize() < 1L) {
            this.outputBlankFileError(dir1, dir2, res, user, imcref);
            handledOutput = true;
            return handledOutput;
        }
        String filename = parameterFileItem.getName();
        File file = new File(destDir, filename);
        if (file.equals(uniqueFile = FileAdmin.findUniqueFilename(file)) || file.renameTo(uniqueFile)) {
            try {
                parameterFileItem.write(file);
            }
            catch (Exception e) {
                IOException ioException = new IOException("Failed to write file.");
                ioException.initCause(e);
                throw ioException;
            }
            if (!file.equals(uniqueFile)) {
                this.outputFileExistedAndTheOriginalWasRenamedNotice(dir1, dir2, uniqueFile.getName(), res, user, imcref);
                handledOutput = true;
            }
        } else {
            handledOutput = false;
        }
        return handledOutput;
    }

    private void outputFileAdmin(HttpServletResponse res, UserDomainObject user, File dir1, File dir2) throws IOException {
        Utility.setDefaultHtmlContentType(res);
        res.getOutputStream().print(this.parseFileAdmin(user, dir1, dir2));
    }

    static File findUniqueFilename(File file) {
        File uniqueFile = file;
        int counter = 1;
        String previousSuffix = "";
        while (uniqueFile.exists()) {
            String filenameWithoutSuffix = StringUtils.substringBeforeLast((String)uniqueFile.getName(), (String)previousSuffix);
            String suffix = "." + counter;
            ++counter;
            uniqueFile = new File(uniqueFile.getParentFile(), filenameWithoutSuffix + suffix);
            previousSuffix = suffix;
        }
        return uniqueFile;
    }

    private void outputMoveOverwriteWarning(String option_list, File sourceDir, File destDir, String file_list, File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        this.outputWarning(option_list, sourceDir, destDir, file_list, dir1, dir2, res, imcref, ADMIN_TEMPLATE_FILE_ADMIN_MOVE_OVERWRITE_WARNING, user);
    }

    private void ouputCopyOverwriteWarning(String option_list, File sourceDir, File destDir, String file_list, File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        this.outputWarning(option_list, sourceDir, destDir, file_list, dir1, dir2, res, imcref, ADMIN_TEMPLATE_FILE_ADMIN_COPY_OVERWRIGHT_WARNING, user);
    }

    private void outputWarning(String option_list, File sourceDir, File destDir, String file_list, File dir1, File dir2, HttpServletResponse res, ImcmsServices imcref, String template, UserDomainObject user) throws IOException {
        ArrayList<String> vec = new ArrayList<String>();
        vec.add("#filelist#");
        vec.add(option_list);
        vec.add("#source#");
        vec.add(this.getContextRelativeAbsolutePathToDirectory(sourceDir));
        vec.add("#dest#");
        vec.add(this.getContextRelativeAbsolutePathToDirectory(destDir));
        vec.add("#files#");
        vec.add(file_list);
        vec.add("#dir1#");
        vec.add(this.getContextRelativeAbsolutePathToDirectory(dir1));
        vec.add("#dir2#");
        vec.add(this.getContextRelativeAbsolutePathToDirectory(dir2));
        Utility.setDefaultHtmlContentType(res);
        ServletOutputStream out = res.getOutputStream();
        out.print(imcref.getAdminTemplate(template, user, vec));
    }

    private void outputFileExistedAndTheOriginalWasRenamedNotice(File dir1, File dir2, String newFilename, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        ArrayList<String> vec = new ArrayList<String>();
        vec.add("#dir1#");
        vec.add(this.getContextRelativeAbsolutePathToDirectory(dir1));
        vec.add("#dir2#");
        vec.add(this.getContextRelativeAbsolutePathToDirectory(dir2));
        vec.add("#filename#");
        vec.add(newFilename);
        Utility.setDefaultHtmlContentType(res);
        ServletOutputStream out = res.getOutputStream();
        out.print(imcref.getAdminTemplate("FileAdminFileExisted.html", user, vec));
    }

    private void outputBlankFileError(File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        ArrayList<String> vec = new ArrayList<String>();
        vec.add("#dir1#");
        vec.add(this.getContextRelativeAbsolutePathToDirectory(dir1));
        vec.add("#dir2#");
        vec.add(this.getContextRelativeAbsolutePathToDirectory(dir2));
        Utility.setDefaultHtmlContentType(res);
        ServletOutputStream out = res.getOutputStream();
        out.print(imcref.getAdminTemplate("FileAdminFileBlank.html", user, vec));
    }

    private void outputDeleteWarning(File[] filelist, File dir1, File dir2, File sourceDir, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        StringBuffer files = new StringBuffer();
        StringBuffer optionlist = new StringBuffer();
        for (int i = 0; i < filelist.length; ++i) {
            File foo = new File(sourceDir, filelist[i].getPath());
            String bar = this.createWarningFileOptionString(foo);
            optionlist.append("<option>").append(bar).append("</option>");
            files.append(filelist[i]).append(File.pathSeparator);
        }
        ArrayList<String> vec = new ArrayList<String>();
        vec.add("#filelist#");
        vec.add(optionlist.toString());
        vec.add("#files#");
        vec.add(StringEscapeUtils.escapeHtml((String)files.toString()));
        vec.add("#source#");
        vec.add(this.getContextRelativeAbsolutePathToDirectory(sourceDir));
        vec.add("#dir1#");
        vec.add(this.getContextRelativeAbsolutePathToDirectory(dir1));
        vec.add("#dir2#");
        vec.add(this.getContextRelativeAbsolutePathToDirectory(dir2));
        Utility.setDefaultHtmlContentType(res);
        ServletOutputStream out = res.getOutputStream();
        out.print(imcref.getAdminTemplate("FileAdminDeleteWarning.html", user, vec));
    }

    private void outputBlankFilenameError(File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        ArrayList<String> vec = new ArrayList<String>();
        vec.add("#dir1#");
        vec.add(this.getContextRelativeAbsolutePathToDirectory(dir1));
        vec.add("#dir2#");
        vec.add(this.getContextRelativeAbsolutePathToDirectory(dir2));
        Utility.setDefaultHtmlContentType(res);
        ServletOutputStream out = res.getOutputStream();
        out.print(imcref.getAdminTemplate("FileAdminNameBlank.html", user, vec));
    }

    private void moveOk(HttpServletRequest mp, File[] roots) throws IOException {
        this.fromSourceToDestination(mp, roots, new FromSourceFileToDestinationFileCommand(){

            public void execute(File source, File dest) throws IOException {
                dest.getParentFile().mkdirs();
                if (source.isFile()) {
                    FileUtils.copyFile((File)source, (File)dest);
                }
                if (source.length() == dest.length()) {
                    FileUtils.forceDelete((File)source);
                }
            }
        });
    }

    private void fromSourceToDestination(HttpServletRequest mp, File[] roots, FromSourceFileToDestinationFileCommand command) throws IOException {
        File srcdir = this.getContextRelativeDirectoryFromRequest(mp, "source");
        File dstdir = this.getContextRelativeDirectoryFromRequest(mp, "dest");
        String files = mp.getParameter("files");
        if (this.isUnderRoot(srcdir, roots) && this.isUnderRoot(dstdir, roots)) {
            StringTokenizer st = new StringTokenizer(files, ":;");
            while (st.hasMoreTokens()) {
                String foo = st.nextToken();
                File source = new File(srcdir, foo);
                File dest = new File(dstdir, foo);
                command.execute(source, dest);
            }
        }
    }

    private void copyOk(HttpServletRequest mp, File[] roots) throws IOException {
        this.fromSourceToDestination(mp, roots, new FromSourceFileToDestinationFileCommand(){

            public void execute(File source, File destination) throws IOException {
                if (source.isDirectory()) {
                    destination.mkdir();
                } else {
                    FileUtils.copyFile((File)source, (File)destination);
                }
            }
        });
    }

    private void deleteOk(HttpServletRequest mp, File[] roots) throws IOException {
        String files = mp.getParameter("files");
        File path = this.getContextRelativeDirectoryFromRequest(mp, "source");
        if (null != files && null != path) {
            StringTokenizer st = new StringTokenizer(files, ":;");
            while (st.hasMoreTokens()) {
                File foo = new File(path, st.nextToken());
                if (!foo.exists() || !this.isUnderRoot(foo.getParentFile(), roots)) continue;
                FileUtils.forceDelete((File)foo);
            }
        }
    }

    private File changeDir(String[] files, File dir, File[] roots) throws IOException {
        File resultDir = dir;
        if (files != null && files.length == 1) {
            String filename = files[0];
            if (filename.startsWith(File.separator)) {
                resultDir = new File(Imcms.getPath(), filename);
            } else {
                File newDir = new File(dir, filename);
                if (newDir.isDirectory()) {
                    resultDir = newDir;
                }
            }
        }
        if (!this.isUnderRoot(resultDir, roots)) {
            return dir;
        }
        return resultDir.getCanonicalFile();
    }

    private File[] makeAbsoluteFileList(File parent, String[] filePaths) {
        File[] files = new File[filePaths.length];
        for (int i = 0; i < filePaths.length; ++i) {
            String filePath = filePaths[i];
            files[i] = new File(filePath);
        }
        return this.makeAbsoluteFileList(parent, files);
    }

    private File[] makeAbsoluteFileList(File parent, File[] files) {
        if (files == null || parent == null) {
            return null;
        }
        LinkedList<File> list = new LinkedList<File>();
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i].getPath();
            if ("..".equals(filename) || new File(filename).isAbsolute()) continue;
            list.add(new File(parent, filename));
        }
        return list.toArray(new File[list.size()]);
    }

    private File[] makeRelativeFileList(File relativeParentDir, File[] files) throws IOException {
        if (files == null || relativeParentDir == null) {
            return null;
        }
        File[] relativeFileList = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            relativeFileList[i] = FileUtility.relativizeFile(relativeParentDir, files[i]);
        }
        return relativeFileList;
    }

    private File[] makeFileTreeList(File[] files, boolean dirfirst) {
        if (files == null) {
            return new File[0];
        }
        LinkedList<File> list = new LinkedList<File>();
        for (int i = 0; i < files.length; ++i) {
            if (dirfirst) {
                list.add(files[i]);
            }
            if (files[i].isDirectory()) {
                File[] sub_list = this.makeFileTreeList(files[i].listFiles(), dirfirst);
                for (int j = 0; j < sub_list.length; ++j) {
                    list.add(sub_list[j]);
                }
            }
            if (dirfirst) continue;
            list.add(files[i]);
        }
        File[] result = new File[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (File)list.removeFirst();
        }
        return result;
    }

    private String parseFileAdmin(UserDomainObject user, File fd1, File fd2) throws IOException {
        String optionlist;
        ImcmsServices imcref = Imcms.getServices();
        File[] rootlist = this.getRoots();
        ArrayList<String> vec = new ArrayList<String>();
        if (fd1 != null) {
            vec.add("#dir1#");
            vec.add(this.getContextRelativeAbsolutePathToDirectory(fd1));
            optionlist = this.createDirectoryOptionList(rootlist, fd1);
            vec.add("#files1#");
            vec.add(optionlist);
        } else {
            vec.add("#dir1#");
            vec.add("");
            vec.add("#files1#");
            vec.add("");
        }
        if (fd2 != null) {
            vec.add("#dir2#");
            vec.add(this.getContextRelativeAbsolutePathToDirectory(fd2));
            optionlist = this.createDirectoryOptionList(rootlist, fd2);
            vec.add("#files2#");
            vec.add(optionlist);
        } else {
            vec.add("#dir2#");
            vec.add("");
            vec.add("#files2#");
            vec.add("");
        }
        return imcref.getAdminTemplate("FileAdmin.html", user, vec);
    }

    private String getContextRelativeAbsolutePathToDirectory(File dir) throws IOException {
        return File.separator + this.getPathRelativeTo(Imcms.getPath(), dir) + File.separator;
    }

    private String getPathRelativeTo(File root, File file) throws IOException {
        if (!FileUtility.directoryIsAncestorOfOrEqualTo(root = root.getCanonicalFile(), file = file.getCanonicalFile())) {
            return file.getAbsolutePath();
        }
        if (file.equals(root)) {
            return "";
        }
        return FileUtility.relativizeFile(root, file).getPath();
    }

    private String createDirectoryOptionList(File[] rootlist, File directory) throws IOException {
        StringBuffer optionlist = new StringBuffer();
        File webappPath = Imcms.getPath();
        for (int i = 0; i < rootlist.length; ++i) {
            String dirname = this.getPathRelativeTo(webappPath, rootlist[i]);
            optionlist.append(this.getDirectoryOption(File.separator + dirname + File.separator, File.separator + dirname + File.separator));
        }
        File parent = directory.getCanonicalFile().getParentFile();
        if (this.isUnderRoot(parent, rootlist)) {
            optionlist.append(this.getDirectoryOption(".." + File.separator, ".." + File.separator));
        }
        File[] dirlist = directory.listFiles((FileFilter)DirectoryFileFilter.INSTANCE);
        Arrays.sort(dirlist, this.getFileComparator());
        for (int i = 0; null != dirlist && i < dirlist.length; ++i) {
            optionlist.append(this.getDirectoryOption(dirlist[i].getName() + File.separator, dirlist[i].getName() + File.separator));
        }
        File[] filelist = directory.listFiles((FileFilter)new NotFileFilter(DirectoryFileFilter.INSTANCE));
        Arrays.sort(filelist, this.getFileComparator());
        for (int i = 0; null != filelist && i < filelist.length; ++i) {
            String formatedFileSize = HumanReadable.getHumanReadableByteSize((long)filelist[i].length());
            String filename = filelist[i].getName();
            String fileNameAndSize = filename + " [" + formatedFileSize + "]";
            optionlist.append("<option value=\"");
            optionlist.append(StringEscapeUtils.escapeHtml((String)filename));
            optionlist.append("\">");
            optionlist.append(StringEscapeUtils.escapeHtml((String)fileNameAndSize));
            optionlist.append("</option>");
        }
        return optionlist.toString();
    }

    private String getDirectoryOption(String value, String text) {
        return "<option style=\"background-color:#f0f0f0\" value=\"" + StringEscapeUtils.escapeHtml((String)value) + "\">" + StringEscapeUtils.escapeHtml((String)text) + "</option>";
    }

    private Comparator getFileComparator() {
        return new Comparator(){

            public int compare(Object a, Object b) {
                File filea = (File)a;
                File fileb = (File)b;
                if (filea.isDirectory() && !fileb.isDirectory()) {
                    return -1;
                }
                if (!filea.isDirectory() && fileb.isDirectory()) {
                    return 1;
                }
                return filea.getName().compareToIgnoreCase(fileb.getName());
            }
        };
    }

    private static interface FromSourceFileToDestinationFileCommand {
        public void execute(File var1, File var2) throws IOException;
    }
}

