/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.flow.DocumentPageFlow;
import com.imcode.imcms.flow.OkCancelPage;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.DocumentSaveException;
import com.imcode.imcms.servlet.admin.DocumentCreator;
import com.imcode.imcms.servlet.admin.GetExistingDoc;
import com.imcode.imcms.util.l10n.LocalizedMessage;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.ConcurrentDocumentModificationException;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.NoPermissionToCreateDocumentException;
import imcode.server.document.NoPermissionToEditDocumentException;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.NoPermissionToAddDocumentToMenuException;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TreeSortKeyDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Html;
import imcode.util.ShouldHaveCheckedPermissionsEarlierException;
import imcode.util.ShouldNotBeThrownException;
import imcode.util.ToStringPairTransformer;
import imcode.util.Utility;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.UnhandledException;

public class MenuEditPage
extends OkCancelPage {
    public static final String SORT_KEY = "sortKey";
    public static final String SELECTED = "selected";
    public static final String DOCUMENT_TYPE_ID = "documentTypeId";
    public static final String CREATE = "create";
    private TextDocumentDomainObject textDocument;
    private final MenuDomainObject menu;
    private ServletContext servletContext;
    public static final String COPY = "copy";
    public static final String ARCHIVE = "archive";
    public static final String REMOVE = "remove";
    private int menuIndex;
    public static final String SORT_ORDER = "sortOrder";
    public static final String SORT = "sort";

    public MenuEditPage(DispatchCommand okDispatchCommand, DispatchCommand cancelDispatchCommand, TextDocumentDomainObject textDocument, int menuIndex, ServletContext servletContext) {
        super(okDispatchCommand, cancelDispatchCommand);
        this.textDocument = textDocument;
        this.menuIndex = menuIndex;
        this.menu = textDocument.getMenu(menuIndex);
        this.servletContext = servletContext;
    }

    protected void dispatchOther(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (null != request.getParameter(CREATE)) {
            int documentTypeId = Integer.parseInt(request.getParameter(DOCUMENT_TYPE_ID));
            if (0 == documentTypeId) {
                this.addExistingDocPage(this.textDocument.getId(), this.menuIndex, request, response);
            } else {
                DocumentCreator documentCreator = new DocumentCreator(new SaveNewDocumentAndAddToMenuCommand(this.textDocument, this.menuIndex), new DispatchCommand(){

                    public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                        MenuEditPage.this.forward(request, response);
                    }
                }, this.servletContext);
                try {
                    documentCreator.createDocumentAndDispatchToCreatePageFlow(documentTypeId, this.textDocument, request, response);
                    return;
                }
                catch (NoPermissionToCreateDocumentException e) {
                    throw new UnhandledException((Throwable)e);
                }
            }
        }
        this.forward(request, response);
    }

    protected void updateFromRequest(HttpServletRequest request) {
        MenuItemDomainObject[] menuItems;
        for (MenuItemDomainObject menuItem : menuItems = this.menu.getMenuItems()) {
            String newSortKey = request.getParameter(SORT_KEY + menuItem.getDocument().getId());
            if (null == newSortKey) continue;
            if (2 == this.menu.getSortOrder()) {
                try {
                    menuItem.setSortKey(new Integer(newSortKey));
                }
                catch (NumberFormatException ignored) {}
                continue;
            }
            if (4 != this.menu.getSortOrder()) continue;
            menuItem.setTreeSortKey(new TreeSortKeyDomainObject(newSortKey));
        }
        try {
            String[] selectedChildrenIds = request.getParameterValues(SELECTED);
            DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
            UserDomainObject user = Utility.getLoggedOnUser(request);
            if (request.getParameter(SORT) != null) {
                int sortOrder = Integer.parseInt(request.getParameter(SORT_ORDER));
                if (this.menu.getSortOrder() != sortOrder) {
                    this.menu.setSortOrder(sortOrder);
                }
            } else if (request.getParameter(REMOVE) != null) {
                if (selectedChildrenIds != null) {
                    for (String selectedChildrenId : selectedChildrenIds) {
                        int childId = Integer.parseInt(selectedChildrenId);
                        this.menu.removeMenuItemByDocumentId(childId);
                    }
                }
            } else if (request.getParameter(ARCHIVE) != null) {
                if (selectedChildrenIds != null) {
                    Date now = new Date();
                    for (String selectedChildrenId : selectedChildrenIds) {
                        int childId = Integer.parseInt(selectedChildrenId);
                        DocumentDomainObject child = documentMapper.getPublishedDocument(childId);
                        child.setArchivedDatetime(now);
                        documentMapper.saveDocument(child, user);
                    }
                }
            } else if (request.getParameter(COPY) != null && selectedChildrenIds != null) {
                for (String selectedChildIdStr : selectedChildrenIds) {
                    int selectedChildId = Integer.parseInt(selectedChildIdStr);
                    DocumentDomainObject selectedChild = documentMapper.getPublishedDocument(selectedChildId);
                    DocumentDomainObject selectedChildCopy = documentMapper.copyDocument(selectedChild, user);
                    this.menu.addMenuItem(new MenuItemDomainObject(documentMapper.getDocumentReference(selectedChildCopy)));
                }
            }
            if (null == request.getParameter(CREATE)) {
                documentMapper.saveDocument(this.textDocument, user);
            }
        }
        catch (NoPermissionToEditDocumentException e) {
            throw new ShouldHaveCheckedPermissionsEarlierException(e);
        }
        catch (NoPermissionToAddDocumentToMenuException e) {
            throw new ConcurrentDocumentModificationException(e);
        }
        catch (DocumentSaveException e) {
            throw new ShouldNotBeThrownException(e);
        }
    }

    public MenuDomainObject getMenu() {
        return this.menu;
    }

    public TextDocumentDomainObject getTextDocument() {
        return this.textDocument;
    }

    public String getPath(HttpServletRequest request) {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        return "/imcms/" + user.getLanguageIso639_2() + "/jsp/change_menu.jsp";
    }

    private void addExistingDocPage(int meta_id, int doc_menu_no, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Utility.setDefaultHtmlContentType(response);
        ArrayList<String> vec = new ArrayList<String>();
        vec.add("#meta_id#");
        vec.add("" + meta_id);
        vec.add("#doc_menu_no#");
        vec.add("" + doc_menu_no);
        vec.add("#page#");
        vec.add(this.getSessionAttributeName());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date toDay = new Date();
        vec.add("#start_date#");
        vec.add("");
        vec.add("#end_date#");
        vec.add(formatter.format(toDay));
        vec.add("#searchstring#");
        vec.add("");
        vec.add("#searchResults#");
        vec.add("");
        ImcmsServices imcref = Imcms.getServices();
        final UserDomainObject user = Utility.getLoggedOnUser(request);
        String sortOrderStr = Html.createOptionList(GetExistingDoc.SORT_ORDERS_MAP.entrySet(), new ToStringPairTransformer(){

            public String[] transformToStringPair(Object input) {
                Map.Entry entry = (Map.Entry)input;
                return new String[]{(String)entry.getKey(), ((LocalizedMessage)entry.getValue()).toLocalizedString(user)};
            }
        });
        vec.add("#sortBy#");
        vec.add(sortOrderStr);
        String[][] allDocTypesArray = imcref.getAllDocumentTypes(user.getLanguageIso639_2());
        for (int i = 0; i < allDocTypesArray.length; ++i) {
            vec.add("#checked_" + allDocTypesArray[i][0] + "#");
            vec.add("checked");
        }
        String[] allPossibleIncludeDocsValues = new String[]{"created", "changed"};
        for (int i = 0; i < allPossibleIncludeDocsValues.length; ++i) {
            vec.add("#include_check_" + allPossibleIncludeDocsValues[i] + "#");
            vec.add("checked");
        }
        String[] allPossibleSearchPreps = new String[]{"and", "or"};
        for (int i = 0; i < allPossibleSearchPreps.length; ++i) {
            vec.add("#search_prep_check_" + allPossibleSearchPreps[i] + "#");
            if (i == 0) {
                vec.add("checked");
                continue;
            }
            vec.add("");
        }
        response.getWriter().write(imcref.getAdminTemplate("existing_doc.html", user, vec));
    }

    public void save(UserDomainObject user) throws DocumentSaveException {
        DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
        documentMapper.saveDocument(this.textDocument, user);
    }

    public static class SaveNewDocumentAndAddToMenuCommand
    implements DocumentPageFlow.SaveDocumentCommand {
        private TextDocumentDomainObject parentDocument;
        private Integer parentMenuIndex;
        private DocumentDomainObject savedDocument;

        SaveNewDocumentAndAddToMenuCommand(TextDocumentDomainObject parentDocument, Integer parentMenuIndex) {
            this.parentDocument = parentDocument;
            this.parentMenuIndex = parentMenuIndex;
        }

        public synchronized void saveDocument(DocumentDomainObject document, UserDomainObject user) throws NoPermissionToEditDocumentException, NoPermissionToAddDocumentToMenuException, DocumentSaveException {
            if (null != this.savedDocument) {
                return;
            }
            DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
            documentMapper.saveNewDocument(document, user, false);
            this.savedDocument = document;
            if (null == this.parentMenuIndex) {
                return;
            }
            MenuDomainObject menu = this.parentDocument.getMenu(this.parentMenuIndex);
            menu.addMenuItem(new MenuItemDomainObject(documentMapper.getDocumentReference(document)));
            documentMapper.saveDocument(this.parentDocument, user);
        }

        public synchronized DocumentDomainObject getSavedDocument() {
            return this.savedDocument;
        }
    }
}

