/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.SqlQueryCommand;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.SystemData;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import imcode.util.net.SMTP;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PasswordMailReminder
extends HttpServlet {
    private static final String USER_DONT_EXIST = "password_no_user.txt";
    private static final String USER_HAS_NO_EMAIL = "password_no_email.txt";
    private static final String USER_HAS_NOT_RIGHT = "password_no_right.txt";
    private static final String SENT_USER_PASSWORD = "password_sent.txt";
    private static final String USER_MAIL_BODY = "password_user_mail.txt";
    private static final String ERROR_STRING = "password_error_input.txt";
    private static final String RETURNING_DOCUMENT_SENT = "password_sent.html";
    private static final String RETURNING_DOCUMENT_NOT_SENT = "password_not_sent.html";
    private static final String RETURNING_DOCUMENT_INPUT = "password_submit.html";
    private static final int PASSWORD_PERMISSION_ID = 1;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        Utility.setDefaultHtmlContentType(res);
        ServletOutputStream out = res.getOutputStream();
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("#errorininput#");
        tags.add("");
        UserDomainObject user = Utility.getLoggedOnUser(req);
        String returnString = imcref.getAdminTemplate(RETURNING_DOCUMENT_INPUT, user, tags);
        out.print(returnString);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String returnString;
        boolean validLoginName;
        String emptyString;
        ImcmsServices imcref = Imcms.getServices();
        ImcmsAuthenticatorAndUserAndRoleMapper userMapper = Imcms.getServices().getImcmsAuthenticatorAndUserAndRoleMapper();
        SystemData sysData = imcref.getSystemData();
        String eMailServerMaster = sysData.getServerMasterAddress();
        String firstName = emptyString = "";
        String lastName = emptyString;
        String password = emptyString;
        String userEmail = emptyString;
        String userName = emptyString;
        ArrayList<String> tags = new ArrayList<String>();
        String postedLoginName = req.getParameter("login_name");
        boolean bl = validLoginName = postedLoginName != null && postedLoginName.length() != 0;
        if (validLoginName) {
            String[] subjectAndBody;
            String serverMasterMailBody;
            String returnFileBody;
            Object[] parameters = new String[]{"1", postedLoginName, postedLoginName};
            String[] queryResult = (String[])imcref.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("select login_password, first_name, last_name, email, min(permissions & ?), lang_prefix, login_name \nfrom users u \njoin lang_prefixes lp \n    on u.language = lp.lang_prefix\njoin user_roles_crossref urc \n    on u.user_id = urc.user_id left \njoin roles r \n    on r.role_id = urc.role_id\nwhere login_name = ?\nor email = ?\ngroup by login_password, first_name, last_name, email, lang_prefix, login_name", parameters, Utility.STRING_ARRAY_HANDLER));
            boolean sendMailToUser = false;
            if (queryResult != null && queryResult.length > 0) {
                boolean userHasOnlyRolesWithPermissionToGetPasswordSentByMail;
                firstName = queryResult[1];
                lastName = queryResult[2];
                userEmail = queryResult[3];
                userName = queryResult[6];
                boolean bl2 = userHasOnlyRolesWithPermissionToGetPasswordSentByMail = !"0".equals(queryResult[4]);
                if (userHasOnlyRolesWithPermissionToGetPasswordSentByMail) {
                    if (userEmail != null && Utility.isValidEmail(userEmail)) {
                        sendMailToUser = true;
                        password = queryResult[0];
                        returnFileBody = RETURNING_DOCUMENT_SENT;
                        serverMasterMailBody = SENT_USER_PASSWORD;
                    } else {
                        returnFileBody = RETURNING_DOCUMENT_NOT_SENT;
                        serverMasterMailBody = USER_HAS_NO_EMAIL;
                    }
                } else {
                    returnFileBody = RETURNING_DOCUMENT_NOT_SENT;
                    serverMasterMailBody = USER_HAS_NOT_RIGHT;
                }
            } else {
                returnFileBody = RETURNING_DOCUMENT_NOT_SENT;
                serverMasterMailBody = USER_DONT_EXIST;
            }
            UserDomainObject user = imcref.getImcmsAuthenticatorAndUserAndRoleMapper().getUser(userName);
            if (user == null) {
                user = userMapper.getDefaultUser();
            }
            user.setCurrentContextPath(req.getContextPath());
            SMTP smtp = imcref.getSMTP();
            String host = req.getServerName();
            if (sendMailToUser) {
                ArrayList<String> mailTags = new ArrayList<String>();
                mailTags.add("#firstname#");
                mailTags.add(firstName);
                mailTags.add("#lastname#");
                mailTags.add(lastName);
                mailTags.add("#username#");
                mailTags.add(userName);
                mailTags.add("#password#");
                mailTags.add(password);
                mailTags.add("#host#");
                mailTags.add(host);
                String userMessage = imcref.getAdminTemplate(USER_MAIL_BODY, user, mailTags);
                subjectAndBody = this.getSubjectAndBody(userMessage);
                smtp.sendMail(new SMTP.Mail(eMailServerMaster, new String[]{userEmail}, subjectAndBody[0], subjectAndBody[1]));
            }
            ArrayList<String> parsVector = new ArrayList<String>();
            parsVector.add("#username#");
            parsVector.add(userName);
            parsVector.add("#email#");
            parsVector.add(userEmail);
            parsVector.add("#host#");
            parsVector.add(host);
            String serverMasterMessage = imcref.getAdminTemplate(serverMasterMailBody, userMapper.getDefaultUser(), parsVector);
            subjectAndBody = this.getSubjectAndBody(serverMasterMessage);
            smtp.sendMail(new SMTP.Mail(eMailServerMaster, new String[]{eMailServerMaster}, subjectAndBody[0], subjectAndBody[1]));
            returnString = imcref.getAdminTemplate(returnFileBody, user, null);
        } else {
            UserDomainObject user = Utility.getLoggedOnUser(req);
            String errorString = imcref.getAdminTemplate(ERROR_STRING, user, null);
            tags.add("#errorininput#");
            tags.add(errorString);
            returnString = imcref.getAdminTemplate(RETURNING_DOCUMENT_INPUT, user, tags);
        }
        Utility.setDefaultHtmlContentType(res);
        ServletOutputStream out = res.getOutputStream();
        out.print(returnString);
    }

    private String[] getSubjectAndBody(String userMessage) {
        Pattern pattern = Pattern.compile("^Subject: (.*)\n\n");
        Matcher matcher = pattern.matcher(userMessage);
        String[] subjectAndBody = new String[2];
        subjectAndBody[1] = matcher.replaceFirst("");
        subjectAndBody[0] = matcher.group(1);
        return subjectAndBody;
    }
}

