/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import com.imcode.imcms.api.DocumentVersionSelector;
import com.imcode.imcms.api.I18nLanguage;
import com.imcode.imcms.api.I18nSupport;
import com.imcode.imcms.dao.LanguageDao;
import com.imcode.imcms.servlet.GetDoc;
import com.imcode.imcms.servlet.UriEncodingWorkaroundWrapper;
import com.imcode.imcms.util.SchemaVersionChecker;
import com.imcode.imcms.util.SchemaVersionCheckerException;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.user.DocumentShowSettings;
import imcode.server.user.UserDomainObject;
import imcode.util.FallbackDecoder;
import imcode.util.Utility;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ImcmsSetupFilter
implements Filter {
    public static final String JSESSIONID_COOKIE_NAME = "JSESSIONID";
    private final Logger logger = Logger.getLogger(this.getClass());
    private Map<String, I18nLanguage> i18nHosts = new HashMap<String, I18nLanguage>();

    public void doFilter(ServletRequest r, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        UserDomainObject user;
        r.setCharacterEncoding("UTF-8");
        Object request = (HttpServletRequest)r;
        HttpSession session = request.getSession();
        ImcmsServices service = Imcms.getServices();
        if (session.isNew()) {
            service.incrementSessionCounter();
            this.setDomainSessionCookie(response, session);
        }
        String workaroundUriEncoding = service.getConfig().getWorkaroundUriEncoding();
        FallbackDecoder fallbackDecoder = new FallbackDecoder(Charset.forName("UTF-8"), null != workaroundUriEncoding ? Charset.forName(workaroundUriEncoding) : Charset.defaultCharset());
        if (null != workaroundUriEncoding) {
            request = new UriEncodingWorkaroundWrapper((HttpServletRequest)request, fallbackDecoder);
        }
        if (null == (user = Utility.getLoggedOnUser(request))) {
            user = service.verifyUserByIpOrDefault(request.getRemoteAddr());
            assert (user.isActive());
            Utility.makeUserLoggedIn(request, user);
        }
        Imcms.setUser(user);
        this.updateUserI18nSetting((HttpServletRequest)request, user);
        this.updateUserShowSettings((HttpServletRequest)request, user);
        ResourceBundle resourceBundle = Utility.getResourceBundle(request);
        Config.set((ServletRequest)request, (String)"javax.servlet.jsp.jstl.fmt.localizationContext", (Object)new LocalizationContext(resourceBundle));
        Utility.initRequestWithApi((ServletRequest)request, user);
        NDC.setMaxDepth((int)0);
        String contextPath = request.getContextPath();
        if (!"".equals(contextPath)) {
            NDC.push((String)contextPath);
        }
        NDC.push((String)StringUtils.substringAfterLast((String)request.getRequestURI(), (String)"/"));
        this.handleDocumentUri(chain, (HttpServletRequest)request, response, service, fallbackDecoder);
        NDC.setMaxDepth((int)0);
    }

    private void handleDocumentUri(FilterChain chain, HttpServletRequest request, ServletResponse response, ImcmsServices service, FallbackDecoder fallbackDecoder) throws ServletException, IOException {
        String path = Utility.fallbackUrlDecode(request.getRequestURI(), fallbackDecoder);
        path = StringUtils.substringAfter((String)path, (String)request.getContextPath());
        String documentIdString = ImcmsSetupFilter.getDocumentIdString(service, path);
        ServletContext servletContext = request.getSession().getServletContext();
        if (null == servletContext.getResourcePaths(path)) {
            UserDomainObject user = Utility.getLoggedOnUser(request);
            DocumentDomainObject document = service.getDocumentMapper().getDocumentForShowing(documentIdString, user);
            if (null != document) {
                try {
                    GetDoc.viewDoc(document, request, (HttpServletResponse)response);
                    return;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
        }
        chain.doFilter((ServletRequest)request, response);
    }

    public static String getDocumentIdString(ImcmsServices service, String path) {
        String documentPathPrefix = service.getConfig().getDocumentPathPrefix();
        String documentIdString = null;
        if (StringUtils.isNotBlank((String)documentPathPrefix) && path.startsWith(documentPathPrefix) && (documentIdString = path.substring(documentPathPrefix.length())).endsWith("/")) {
            documentIdString = documentIdString.substring(0, documentIdString.length() - 1);
        }
        return documentIdString;
    }

    private void setDomainSessionCookie(ServletResponse response, HttpSession session) {
        String domain = Imcms.getServices().getConfig().getSessionCookieDomain();
        if (StringUtils.isNotBlank((String)domain)) {
            Cookie cookie = new Cookie(JSESSIONID_COOKIE_NAME, session.getId());
            cookie.setDomain(domain);
            cookie.setPath("/");
            ((HttpServletResponse)response).addCookie(cookie);
        }
    }

    private void updateUserI18nSetting(HttpServletRequest request, UserDomainObject user) throws ServletException {
        String languageCode;
        HttpSession session = request.getSession();
        I18nLanguage language = (I18nLanguage)session.getAttribute("lang");
        if (language == null && this.i18nHosts.size() > 0) {
            String hostname = request.getServerName();
            language = this.i18nHosts.get(hostname);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Hostname [" + hostname + "] mapped to language [" + language + "]."));
            }
        }
        if ((languageCode = request.getParameter("lang")) != null) {
            language = I18nSupport.getByCode(languageCode);
        }
        if (language == null) {
            language = I18nSupport.getDefaultLanguage();
        }
        session.setAttribute("lang", (Object)language);
        request.setAttribute("currentLanguage", (Object)language);
        I18nSupport.setCurrentLanguage(language);
    }

    public void init(FilterConfig config) throws ServletException {
        ServletContext servletContext = config.getServletContext();
        this.initSpringframework(servletContext);
        this.initI18nSupport(servletContext);
        this.checkSchemaVersion(servletContext);
    }

    private void checkSchemaVersion(ServletContext servletContext) throws ServletException {
        SchemaVersionChecker checker = (SchemaVersionChecker)Imcms.getServices().getSpringBean("schemaVersionChecker");
        try {
            String expectedSchemaVersion = Imcms.getServerProperties().getProperty("db.schema.version", "");
            checker.checkSchemaVersion(expectedSchemaVersion);
        }
        catch (SchemaVersionCheckerException e) {
            this.logger.fatal((Object)e);
            throw e;
        }
    }

    private void initSpringframework(ServletContext servletContext) throws ServletException {
        this.logger.info((Object)"Initializing springframework web application context.");
        Imcms.webApplicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
    }

    private void updateUserShowSettings(HttpServletRequest request, UserDomainObject user) {
        String version;
        String modeValue = request.getParameter("mode");
        if (modeValue != null) {
            user.getDocumentShowSettings().setIgnoreI18nShowMode(Boolean.parseBoolean(modeValue.toLowerCase()));
        }
        if ((version = request.getParameter("version")) != null) {
            DocumentShowSettings settings = user.getDocumentShowSettings();
            if (NumberUtils.isDigits((String)version)) {
                settings.setVersionSelector(DocumentVersionSelector.createCustomSelector(Integer.valueOf(version)));
            } else {
                settings.setVersionSelector(DocumentVersionSelector.getPredefinedSelector(version));
            }
        }
    }

    private void initI18nSupport(ServletContext servletContext) throws ServletException {
        this.logger.info((Object)"Initializing i18n support.");
        LanguageDao languageDao = (LanguageDao)((Object)Imcms.getServices().getSpringBean("languageDao"));
        List<I18nLanguage> languages = languageDao.getAllLanguages();
        if (languages.size() == 0) {
            String msg = "I18n configuration error. Database table i18n_languages must contain at least one record.";
            this.logger.fatal((Object)msg);
            throw new ServletException(msg);
        }
        int defaultLanguageRecordCount = CollectionUtils.countMatches(languages, (Predicate)new Predicate(){

            public boolean evaluate(Object language) {
                return ((I18nLanguage)language).isDefault();
            }
        });
        if (defaultLanguageRecordCount == 0) {
            String msg = "I18n configuration error. Default language is not set.";
            this.logger.fatal((Object)msg);
            throw new ServletException(msg);
        }
        if (defaultLanguageRecordCount > 1) {
            String msg = "I18n configuration error. Only one language must be set default.";
            this.logger.fatal((Object)msg);
            throw new ServletException(msg);
        }
        I18nLanguage defaultLanguage = languageDao.getDefaultLanguage();
        I18nSupport.setDefaultLanguage(defaultLanguage);
        I18nSupport.setLanguages(languages);
        servletContext.setAttribute("defaultLanguage", (Object)defaultLanguage);
        servletContext.setAttribute("languages", languages);
        String prefix = "i18n.host.";
        int prefixLength = prefix.length();
        Properties properties = Imcms.getServerProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String[] hosts;
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            String languageCode = key.substring(prefixLength);
            String value = (String)entry.getValue();
            this.logger.info((Object)("I18n configurtion: language code [" + languageCode + "] mapped to host(s) [" + value + "]."));
            I18nLanguage language = I18nSupport.getByCode(languageCode);
            if (language == null) {
                String msg = "I18n configuration error. Language with code [" + languageCode + "] is not defined in database.";
                this.logger.fatal((Object)msg);
                throw new ServletException(msg);
            }
            for (String host : hosts = value.split("[ \\t]*,[ \\t]*")) {
                this.i18nHosts.put(host.trim(), language);
            }
        }
    }

    public void destroy() {
    }
}

