/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.imcms.api.ContentLoop;
import com.imcode.imcms.api.I18nLanguage;
import com.imcode.imcms.api.Meta;
import com.imcode.imcms.dao.ContentLoopDao;
import com.imcode.imcms.dao.ImageDao;
import com.imcode.imcms.dao.MenuDao;
import com.imcode.imcms.dao.MetaDao;
import com.imcode.imcms.dao.TextDao;
import com.imcode.imcms.mapping.DocumentGetter;
import com.imcode.imcms.mapping.orm.Include;
import com.imcode.imcms.mapping.orm.TemplateNames;
import imcode.server.document.GetterDocumentReference;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.ImageSource;
import imcode.server.document.textdocument.ImagesPathRelativePathImageSource;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.server.document.textdocument.TreeSortKeyDomainObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class TextDocumentInitializer {
    private static final Logger LOG = Logger.getLogger(TextDocumentInitializer.class);
    private DocumentGetter documentGetter;
    private MetaDao metaDao;
    private TextDao textDao;
    private MenuDao menuDao;
    private ImageDao imageDao;
    private ContentLoopDao contentLoopDao;

    public void initialize(TextDocumentDomainObject document) {
        this.initTexts(document);
        this.initImages(document);
        this.initMenus(document);
        this.initIncludes(document);
        this.initTemplateNames(document);
        this.initContentLoops(document);
    }

    private void initTexts(TextDocumentDomainObject document) {
        Meta meta = document.getMeta();
        Collection<TextDomainObject> texts = this.textDao.getTexts(meta.getId(), meta.getVersion().getVersion());
        HashMap<I18nLanguage, Map<Integer, TextDomainObject>> textsMap = new HashMap<I18nLanguage, Map<Integer, TextDomainObject>>();
        for (TextDomainObject text : texts) {
            I18nLanguage language = text.getLanguage();
            HashMap<Integer, TextDomainObject> indexMap = (HashMap<Integer, TextDomainObject>)textsMap.get(language);
            if (indexMap == null) {
                indexMap = new HashMap<Integer, TextDomainObject>();
                textsMap.put(language, indexMap);
            }
            indexMap.put(text.getIndex(), text);
        }
        document.setAllTexts(textsMap);
    }

    private void initIncludes(TextDocumentDomainObject document) {
        Collection<Include> includes = this.metaDao.getIncludes(document.getMeta().getId());
        HashMap<Integer, Integer> includesMap = new HashMap<Integer, Integer>();
        for (Include include : includes) {
            includesMap.put(include.getIndex(), include.getIncludedDocumentId());
        }
        document.setIncludesMap(includesMap);
    }

    private void initTemplateNames(TextDocumentDomainObject document) {
        TemplateNames templateNames = this.metaDao.getTemplateNames(document.getMeta().getId());
        document.setTemplateNames(templateNames);
    }

    private void initImages(TextDocumentDomainObject document) {
        Meta meta = document.getMeta();
        Collection<ImageDomainObject> images = this.imageDao.getImages(meta.getId(), meta.getVersion().getVersion());
        HashMap<I18nLanguage, Map<Integer, ImageDomainObject>> imagesMap = new HashMap<I18nLanguage, Map<Integer, ImageDomainObject>>();
        for (ImageDomainObject image : images) {
            I18nLanguage language = image.getLanguage();
            HashMap<Integer, ImageDomainObject> indexMap = (HashMap<Integer, ImageDomainObject>)imagesMap.get(language);
            if (indexMap == null) {
                indexMap = new HashMap<Integer, ImageDomainObject>();
                imagesMap.put(language, indexMap);
            }
            indexMap.put(image.getIndex(), TextDocumentInitializer.setImageSource(image));
        }
        document.setAllImages(imagesMap);
    }

    private void initMenus(TextDocumentDomainObject document) {
        List<MenuDomainObject> menus = this.menuDao.getMenus(document.getMeta().getId());
        HashMap<Integer, MenuDomainObject> menusMap = new HashMap<Integer, MenuDomainObject>();
        for (MenuDomainObject menu : menus) {
            for (Map.Entry<Integer, MenuItemDomainObject> entry : menu.getItemsMap().entrySet()) {
                Integer destinationDocumentId = entry.getKey();
                MenuItemDomainObject menuItem = entry.getValue();
                GetterDocumentReference gtr = new GetterDocumentReference(destinationDocumentId, this.documentGetter);
                menuItem.setDocumentReference(gtr);
                menuItem.setTreeSortKey(new TreeSortKeyDomainObject(menuItem.getTreeSortIndex()));
            }
            menusMap.put(menu.getIndex(), menu);
        }
        document.setMenusMap(menusMap);
    }

    public static ImageDomainObject setImageSource(ImageDomainObject image) {
        if (image == null) {
            return null;
        }
        String url = image.getImageUrl();
        if (!StringUtils.isBlank((String)url)) {
            ImagesPathRelativePathImageSource imageSource = new ImagesPathRelativePathImageSource(url);
            image.setSource(imageSource);
            image.setImageUrl(url);
            image.setType(((ImageSource)imageSource).getTypeId());
        }
        return image;
    }

    private void initContentLoops(TextDocumentDomainObject document) {
        List<ContentLoop> loops = this.contentLoopDao.getContentLoops(document.getMeta().getId());
        HashMap<Integer, ContentLoop> loopsMap = new HashMap<Integer, ContentLoop>();
        for (ContentLoop loop : loops) {
            loopsMap.put(loop.getIndex(), loop);
        }
        document.setContentLoopsMap(loopsMap);
    }

    public MetaDao getMetaDao() {
        return this.metaDao;
    }

    public void setMetaDao(MetaDao metaDao) {
        this.metaDao = metaDao;
    }

    public TextDao getTextDao() {
        return this.textDao;
    }

    public void setTextDao(TextDao textDao) {
        this.textDao = textDao;
    }

    public MenuDao getMenuDao() {
        return this.menuDao;
    }

    public void setMenuDao(MenuDao menuDao) {
        this.menuDao = menuDao;
    }

    public ImageDao getImageDao() {
        return this.imageDao;
    }

    public void setImageDao(ImageDao imageDao) {
        this.imageDao = imageDao;
    }

    public ContentLoopDao getContentLoopDao() {
        return this.contentLoopDao;
    }

    public void setContentLoopDao(ContentLoopDao contentLoopDao) {
        this.contentLoopDao = contentLoopDao;
    }

    public DocumentGetter getDocumentGetter() {
        return this.documentGetter;
    }

    public void setDocumentGetter(DocumentGetter documentGetter) {
        this.documentGetter = documentGetter;
    }
}

