/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.DeleteWhereColumnsEqualDatabaseCommand;
import com.imcode.db.commands.InsertIntoTableDatabaseCommand;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.db.commands.UpdateTableWhereColumnEqualsDatabaseCommand;
import com.imcode.db.handlers.CollectionHandler;
import com.imcode.db.handlers.RowTransformer;
import com.imcode.db.handlers.SingleObjectHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Mapper<E extends MapperObject> {
    private final Database database;

    protected Mapper(Database database) {
        this.database = database;
    }

    public E get(Object id) {
        return (E)((MapperObject)this.database.execute((DatabaseCommand)new SqlQueryCommand(this.getSelectSql() + " WHERE " + this.getIdColumnName() + " = ?", new Object[]{id}, (ResultSetHandler)new SingleObjectHandler(this.getRowTransformer()))));
    }

    public List<E> getAll() {
        return this.getAll(null, this.getDefaultOrderBy());
    }

    protected List<E> getAll(String where, String orderBy) {
        String selectSql = this.getSelectSql();
        if (null != where) {
            selectSql = selectSql + " WHERE " + where;
        }
        if (null != orderBy) {
            selectSql = selectSql + " ORDER BY " + orderBy;
        }
        return (List)this.database.execute((DatabaseCommand)new SqlQueryCommand(selectSql, null, (ResultSetHandler)new CollectionHandler(new ArrayList(), this.getRowTransformer())));
    }

    public E create(E e) {
        return this.get(this.database.execute((DatabaseCommand)new InsertIntoTableDatabaseCommand(this.getTableName(), this.getDataValues(e))));
    }

    public void delete(Object id) {
        this.database.execute((DatabaseCommand)new DeleteWhereColumnsEqualDatabaseCommand(this.getTableName(), this.getIdColumnName(), id));
    }

    public void update(E e) {
        this.database.execute((DatabaseCommand)new UpdateTableWhereColumnEqualsDatabaseCommand(this.getTableName(), this.getIdColumnName(), e.getId(), this.getDataValues(e)));
    }

    private String getSelectSql() {
        return "SELECT " + StringUtils.join(this.getColumnNames().iterator(), (String)", ") + " FROM " + this.getTableName();
    }

    private List<String> getColumnNames() {
        ArrayList<String> columnNames = new ArrayList<String>(this.getDataColumnNames());
        columnNames.add(0, this.getIdColumnName());
        return columnNames;
    }

    private RowTransformer getRowTransformer() {
        return new RowTransformer(){

            public Object createObjectFromResultSetRow(ResultSet rs) throws SQLException {
                return Mapper.this.convertRow(rs);
            }

            public Class getClassOfCreatedObjects() {
                return null;
            }
        };
    }

    protected abstract String getTableName();

    protected abstract String getIdColumnName();

    protected abstract List<String> getDataColumnNames();

    protected abstract E convertRow(ResultSet var1) throws SQLException;

    protected abstract Object[][] getDataValues(E var1);

    protected String getDefaultOrderBy() {
        return null;
    }

    public static interface MapperObject {
        public Object getId();
    }
}

