/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.imcms.api.ContentLoop;
import com.imcode.imcms.dao.ContentLoopDao;
import com.imcode.imcms.dao.ImageDao;
import com.imcode.imcms.dao.MenuDao;
import com.imcode.imcms.dao.MetaDao;
import com.imcode.imcms.dao.TextDao;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.orm.FileReference;
import com.imcode.imcms.mapping.orm.Include;
import com.imcode.imcms.mapping.orm.TemplateNames;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.io.FileInputStreamSource;
import imcode.util.io.FileUtility;
import imcode.util.io.InputStreamSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;

public class DocumentStoringVisitor
extends DocumentVisitor {
    protected ImcmsServices services;
    private static final int FILE_BUFFER_LENGTH = 2048;
    private static final int DB_FIELD_MAX_LENGTH__FILENAME = 255;

    public DocumentStoringVisitor(ImcmsServices services) {
        this.services = services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFileDocumentFile(int fileDocumentId, FileDocumentDomainObject.FileDocumentFile fileDocumentFile, String fileId) {
        try {
            boolean sameFileOnDisk;
            InputStream in;
            InputStreamSource inputStreamSource = fileDocumentFile.getInputStreamSource();
            try {
                in = inputStreamSource.getInputStream();
            }
            catch (FileNotFoundException e) {
                throw new UnhandledException("The file for filedocument " + fileDocumentId + " has disappeared.", (Throwable)e);
            }
            if (null == in) {
                return;
            }
            File file = DocumentStoringVisitor.getFileForFileDocumentFile(fileDocumentId, fileId);
            FileInputStreamSource fileInputStreamSource = new FileInputStreamSource(file);
            boolean bl = sameFileOnDisk = file.exists() && inputStreamSource.equals(fileInputStreamSource);
            if (sameFileOnDisk) {
                return;
            }
            byte[] buffer = new byte[2048];
            FileOutputStream out = new FileOutputStream(file);
            try {
                int bytesRead;
                while (-1 != (bytesRead = in.read(buffer))) {
                    ((OutputStream)out).write(buffer, 0, bytesRead);
                }
            }
            finally {
                ((OutputStream)out).close();
                in.close();
            }
            fileDocumentFile.setInputStreamSource(fileInputStreamSource);
        }
        catch (IOException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public static File getFileForFileDocumentFile(int fileDocumentId, String fileId) {
        File filePath = Imcms.getServices().getConfig().getFilePath();
        String filename = "" + fileDocumentId;
        if (StringUtils.isNotBlank((String)fileId)) {
            filename = filename + "." + FileUtility.escapeFilename(fileId);
        }
        return new File(filePath, filename);
    }

    static String makeSqlInsertString(String tableName, String[] columnNames) {
        return "INSERT INTO " + tableName + " (" + StringUtils.join((Object[])columnNames, (String)",") + ")" + "VALUES(?" + StringUtils.repeat((String)",?", (int)(columnNames.length - 1)) + ")";
    }

    void updateTextDocumentTexts(TextDocumentDomainObject textDocument, TextDocumentDomainObject oldTextDocument, UserDomainObject user) {
        TextDao textDao = (TextDao)((Object)this.services.getSpringBean("textDao"));
        Integer documentId = textDocument.getMeta().getId();
        Integer documentVersionNumber = textDocument.getMeta().getVersion().getNumber();
        for (Map<Integer, TextDomainObject> map : textDocument.getAllTexts().values()) {
            for (TextDomainObject text : map.values()) {
                if (!text.isModified()) continue;
                text.setMetaId(documentId);
                text.setMetaVersion(documentVersionNumber);
                textDao.saveText(text);
                textDao.saveTextHistory(documentId, text, user);
            }
        }
    }

    public void updateTextDocumentContentLoops(TextDocumentDomainObject textDocument, TextDocumentDomainObject oldTextDocument, UserDomainObject user) {
        ContentLoopDao dao = (ContentLoopDao)((Object)this.services.getSpringBean("contentLoopDao"));
        Integer documentId = textDocument.getMeta().getId();
        for (ContentLoop loop : textDocument.getContentLoopsMap().values()) {
            dao.saveContentLoop(documentId, loop);
        }
    }

    public void updateTextDocumentText(TextDomainObject text, UserDomainObject user) {
        TextDao textDao = (TextDao)((Object)this.services.getSpringBean("textDao"));
        textDao.saveText(text);
        textDao.saveTextHistory(text.getMetaId(), text, user);
    }

    void updateTextDocumentImages(TextDocumentDomainObject textDocument, TextDocumentDomainObject oldTextDocument, UserDomainObject user) {
        ImageDao imageDao = (ImageDao)((Object)this.services.getSpringBean("imageDao"));
        Integer metaId = textDocument.getMeta().getId();
        Integer documentVersion = textDocument.getMeta().getVersion().getVersion();
        for (Map<Integer, ImageDomainObject> map : textDocument.getAllImages().values()) {
            for (ImageDomainObject image : map.values()) {
                if (!image.isModified()) continue;
                image.setMetaId(metaId);
                image.setMetaVersion(documentVersion);
                imageDao.saveImage(image);
            }
        }
    }

    void updateTextDocumentIncludes(TextDocumentDomainObject textDocument) {
        MetaDao dao = (MetaDao)((Object)this.services.getSpringBean("metaDao"));
        HashSet<Include> includes = new HashSet<Include>();
        Integer documentId = textDocument.getMeta().getId();
        for (Map.Entry<Integer, Integer> entry : textDocument.getIncludesMap().entrySet()) {
            Include include = new Include();
            include.setMetaId(documentId);
            include.setIndex(entry.getKey());
            include.setIncludedDocumentId(entry.getValue());
            includes.add(include);
        }
        dao.saveIncludes(documentId, includes);
    }

    void updateTextDocumentTemplateNames(TextDocumentDomainObject textDocument, TextDocumentDomainObject oldTextDocument, UserDomainObject user) {
        MetaDao dao = (MetaDao)((Object)this.services.getSpringBean("metaDao"));
        TemplateNames templateNames = textDocument.getTemplateNames();
        Integer documentId = textDocument.getMeta().getId();
        templateNames.setMetaId(documentId);
        dao.saveTemplateNames(documentId, templateNames);
    }

    public void visitFileDocument(FileDocumentDomainObject fileDocument) {
        MetaDao dao = (MetaDao)((Object)this.services.getSpringBean("metaDao"));
        Map fileDocumentFiles = fileDocument.getFiles();
        dao.deleteFileReferences(fileDocument.getMeta().getId());
        for (Map.Entry entry : fileDocumentFiles.entrySet()) {
            String fileId = (String)entry.getKey();
            FileDocumentDomainObject.FileDocumentFile fileDocumentFile = (FileDocumentDomainObject.FileDocumentFile)entry.getValue();
            String filename = fileDocumentFile.getFilename();
            if (filename.length() > 255) {
                filename = this.truncateFilename(filename, 255);
            }
            boolean isDefaultFile = fileId.equals(fileDocument.getDefaultFileId());
            FileReference fileRef = new FileReference();
            fileRef.setMetaId(fileDocument.getMeta().getId());
            fileRef.setFileId(fileId);
            fileRef.setFilename(filename);
            fileRef.setDefaultFileId(isDefaultFile);
            fileRef.setMimeType(fileDocumentFile.getMimeType());
            fileRef.setCreatedAsImage(fileDocumentFile.isCreatedAsImage());
            dao.saveFileReference(fileRef);
            this.saveFileDocumentFile(fileDocument.getId(), fileDocumentFile, fileId);
        }
        DocumentMapper.deleteOtherFileDocumentFiles(fileDocument);
    }

    private String truncateFilename(String filename, int length) {
        String truncatedFilename = StringUtils.left((String)filename, (int)length);
        String extensions = this.getExtensionsFromFilename(filename);
        if (extensions.length() > length) {
            return truncatedFilename;
        }
        String basename = StringUtils.chomp((String)filename, (String)extensions);
        String truncatedBasename = StringUtils.substring((String)basename, (int)0, (int)(length - extensions.length()));
        truncatedFilename = truncatedBasename + extensions;
        return truncatedFilename;
    }

    private String getExtensionsFromFilename(String filename) {
        String extensions = "";
        Matcher matcher = Pattern.compile("(?:\\.\\w+)+$").matcher(filename);
        if (matcher.find()) {
            extensions = matcher.group();
        }
        return extensions;
    }

    protected void updateTextDocumentMenus(TextDocumentDomainObject textDocument, TextDocumentDomainObject oldTextDocument, UserDomainObject savingUser) {
        MenuDao dao = (MenuDao)((Object)this.services.getSpringBean("menuDao"));
        dao.saveDocumentMenus(textDocument.getMeta().getId(), textDocument.getMenus());
    }
}

