/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import imcode.server.document.DocumentDomainObject;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DocumentList
extends AbstractList<DocumentDomainObject>
implements Serializable {
    private List<DocumentDomainObject> list;
    private Map<Integer, DocumentDomainObject> map;

    DocumentList(Map documentMap) {
        this.map = Collections.synchronizedMap(documentMap);
        this.list = new ArrayList<DocumentDomainObject>(documentMap.size());
        Iterator<DocumentDomainObject> i$ = this.map.values().iterator();
        while (i$.hasNext()) {
            DocumentDomainObject result;
            DocumentDomainObject document = result = i$.next();
            this.list.add(document);
        }
    }

    @Override
    public synchronized DocumentDomainObject remove(int index) {
        DocumentDomainObject document = this.list.remove(index);
        this.map.remove(new Integer(document.getId()));
        return document;
    }

    @Override
    public synchronized DocumentDomainObject set(int index, DocumentDomainObject document) {
        DocumentDomainObject previousDocument = this.list.set(index, document);
        if (null != previousDocument) {
            this.map.remove(new Integer(previousDocument.getId()));
        }
        this.map.put(new Integer(document.getId()), document);
        return previousDocument;
    }

    @Override
    public synchronized DocumentDomainObject get(int index) {
        return this.list.get(index);
    }

    @Override
    public synchronized boolean add(DocumentDomainObject document) {
        this.map.put(new Integer(document.getId()), document);
        return this.list.add(document);
    }

    @Override
    public synchronized int size() {
        return this.list.size();
    }

    public synchronized Map getMap() {
        return this.map;
    }

    @Override
    public synchronized boolean contains(Object o) {
        Integer documentId;
        if (o instanceof Integer) {
            documentId = (Integer)o;
        } else {
            DocumentDomainObject document = (DocumentDomainObject)o;
            documentId = document.getId();
        }
        return this.map.containsKey(documentId);
    }
}

