/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentVersion;
import com.imcode.imcms.api.DocumentVersionSelector;
import com.imcode.imcms.api.Meta;
import com.imcode.imcms.dao.MetaDao;
import com.imcode.imcms.mapping.DocumentGetter;
import com.imcode.imcms.mapping.DocumentInitializingVisitor;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.DocumentPermissionSets;
import imcode.server.document.RoleIdToDocumentPermissionSetTypeMappings;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.user.RoleId;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseDocumentGetter
implements DocumentGetter {
    public static final int PERM_CREATE_DOCUMENT = 8;
    private ImcmsServices services;
    private MetaDao metaDao;
    private DocumentInitializingVisitor documentInitializingVisitor;

    @Override
    public DocumentDomainObject getDocument(Integer documentId) {
        List<DocumentVersion> versions = this.metaDao.getDocumentVersions(documentId);
        int size = versions.size();
        return size == 0 ? null : this.initDocument(this.loadDocument(documentId, versions.get(size - 1).getNumber()));
    }

    @Override
    public DocumentDomainObject getDocument(Integer documentId, Integer version) {
        return this.initDocument(this.loadDocument(documentId, version));
    }

    @Override
    public DocumentDomainObject getPublishedDocument(Integer documentId) {
        return this.initDocument(this.loadDocument(documentId, DocumentVersionSelector.PUBLISHED_SELECTOR));
    }

    @Override
    public DocumentDomainObject getWorkingDocument(Integer documentId) {
        return this.initDocument(this.loadDocument(documentId, DocumentVersionSelector.WORKING_SELECTOR));
    }

    @Override
    public List<DocumentDomainObject> getDocuments(Collection<Integer> documentIds) {
        LinkedList<DocumentDomainObject> documents = new LinkedList<DocumentDomainObject>();
        for (Integer documentId : documentIds) {
            DocumentDomainObject document = this.initDocument(this.loadDocument(documentId, DocumentVersionSelector.PUBLISHED_SELECTOR));
            if (document == null) continue;
            documents.add(document);
        }
        return documents;
    }

    private DocumentDomainObject loadDocument(Integer documentId, DocumentVersionSelector versionSpecifier) {
        Meta meta = this.metaDao.getMeta(documentId, versionSpecifier);
        return this.initMeta(meta);
    }

    private DocumentDomainObject loadDocument(Integer documentId, Integer version) {
        Meta meta = this.metaDao.getMeta(documentId, version);
        return this.initMeta(meta);
    }

    private DocumentDomainObject initMeta(Meta meta) {
        if (meta == null) {
            return null;
        }
        DocumentDomainObject document = DocumentDomainObject.fromDocumentTypeId(meta.getDocumentType());
        document.setMeta(meta);
        document.setActualModifiedDatetime(meta.getModifiedDatetime());
        Document.PublicationStatus publicationStatus = this.publicationStatusFromInt(meta.getPublicationStatusInt());
        document.setPublicationStatus(publicationStatus);
        this.initRoleIdToPermissionSetIdMap(document, meta);
        this.initDocumentsPermissionSets(document, meta);
        this.initDocumentsPermissionSetsForNew(document, meta);
        return document;
    }

    private DocumentDomainObject initDocument(DocumentDomainObject document) {
        if (document == null) {
            return null;
        }
        document.accept(this.documentInitializingVisitor);
        return document;
    }

    private Document.PublicationStatus publicationStatusFromInt(int publicationStatusInt) {
        Document.PublicationStatus publicationStatus = Document.PublicationStatus.NEW;
        if (2 == publicationStatusInt) {
            publicationStatus = Document.PublicationStatus.APPROVED;
        } else if (1 == publicationStatusInt) {
            publicationStatus = Document.PublicationStatus.DISAPPROVED;
        }
        return publicationStatus;
    }

    private void initRoleIdToPermissionSetIdMap(DocumentDomainObject document, Meta meta) {
        RoleIdToDocumentPermissionSetTypeMappings rolePermissionMappings = new RoleIdToDocumentPermissionSetTypeMappings();
        for (Map.Entry<Integer, Integer> roleIdToPermissionSetId : meta.getRoleIdToPermissionSetIdMap().entrySet()) {
            rolePermissionMappings.setPermissionSetTypeForRole(new RoleId(roleIdToPermissionSetId.getKey()), DocumentPermissionSetTypeDomainObject.fromInt(roleIdToPermissionSetId.getValue()));
        }
        document.setRoleIdsMappedToDocumentPermissionSetTypes(rolePermissionMappings);
    }

    private void initDocumentsPermissionSets(DocumentDomainObject document, Meta meta) {
        DocumentPermissionSets permissionSets = this.createDocumentsPermissionSets(meta.getPermissionSetBitsMap(), meta.getPermisionSetEx());
        document.setPermissionSets(permissionSets);
    }

    private void initDocumentsPermissionSetsForNew(DocumentDomainObject document, Meta meta) {
        DocumentPermissionSets permissionSets = this.createDocumentsPermissionSets(meta.getPermissionSetBitsForNewMap(), meta.getPermisionSetExForNew());
        document.setPermissionSetsForNew(permissionSets);
    }

    private DocumentPermissionSets createDocumentsPermissionSets(Map<Integer, Integer> permissionSetBitsMap, Set<Meta.PermisionSetEx> permissionSetEx) {
        Integer setId;
        DocumentPermissionSets permissionSets = new DocumentPermissionSets();
        for (Map.Entry<Integer, Integer> permissionSetBitsEntry : permissionSetBitsMap.entrySet()) {
            setId = permissionSetBitsEntry.getKey();
            Integer permissionSetBits = permissionSetBitsEntry.getValue();
            DocumentPermissionSetDomainObject restricted = permissionSets.getRestricted(setId);
            if (permissionSetBits == 0 || !restricted.isEmpty()) continue;
            restricted.setFromBits(permissionSetBits);
        }
        for (Meta.PermisionSetEx ex : permissionSetEx) {
            setId = ex.getSetId();
            DocumentPermissionSetDomainObject restricted = permissionSets.getRestricted(setId);
            this.setPermissionData(restricted, ex.getPermissionId(), ex.getPermissionData());
        }
        return permissionSets;
    }

    private void setPermissionData(DocumentPermissionSetDomainObject permissionSet, Integer permissionId, Integer permissionData) {
        if (null != permissionId) {
            TextDocumentPermissionSetDomainObject textDocumentPermissionSet = (TextDocumentPermissionSetDomainObject)permissionSet;
            switch (permissionId) {
                case 8: {
                    textDocumentPermissionSet.addAllowedDocumentTypeId(permissionData);
                    break;
                }
                case 524288: {
                    textDocumentPermissionSet.addAllowedTemplateGroupId(permissionData);
                    break;
                }
            }
        }
    }

    public ImcmsServices getServices() {
        return this.services;
    }

    public void setServices(ImcmsServices services) {
        this.services = services;
    }

    public MetaDao getMetaDao() {
        return this.metaDao;
    }

    public void setMetaDao(MetaDao metaDao) {
        this.metaDao = metaDao;
    }

    public DocumentInitializingVisitor getDocumentInitializingVisitor() {
        return this.documentInitializingVisitor;
    }

    public void setDocumentInitializingVisitor(DocumentInitializingVisitor documentInitializingVisitor) {
        this.documentInitializingVisitor = documentInitializingVisitor;
    }
}

