/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.imcms.api.DocumentVersion;
import com.imcode.imcms.api.DocumentVersionSupport;
import com.imcode.imcms.dao.MetaDao;
import com.imcode.imcms.mapping.DocumentGetter;
import com.imcode.imcms.mapping.DocumentGetterWrapper;
import imcode.server.document.DocumentDomainObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.DualHashBidiMap;
import org.apache.commons.collections.map.LRUMap;

public class CachingDocumentGetter
extends DocumentGetterWrapper {
    private Map<Integer, DocumentVersionSupport> versionsSupports;
    private Map<Integer, DocumentDomainObject> latestDocuments;
    private Map<Integer, DocumentDomainObject> publishedDocuments;
    private Map<Integer, DocumentDomainObject> workingDocuments;
    private BidiMap aliasesBidiMap;
    private MetaDao metaDao;

    public CachingDocumentGetter(DocumentGetter documentGetter, MetaDao metaDao, int cacheSize) {
        super(documentGetter);
        this.metaDao = metaDao;
        this.versionsSupports = new HashMap<Integer, DocumentVersionSupport>();
        this.latestDocuments = Collections.synchronizedMap(new LRUMap(cacheSize));
        this.workingDocuments = Collections.synchronizedMap(new LRUMap(cacheSize));
        this.publishedDocuments = Collections.synchronizedMap(new LRUMap(cacheSize));
        this.aliasesBidiMap = new DualHashBidiMap();
    }

    public DocumentVersionSupport getDocumentVersionSupport(Integer documentId) {
        List<DocumentVersion> versions;
        DocumentVersionSupport versionSupport = this.versionsSupports.get(documentId);
        if (versionSupport == null && (versions = this.metaDao.getDocumentVersions(documentId)).size() > 0) {
            versionSupport = new DocumentVersionSupport(documentId, versions);
            this.versionsSupports.put(documentId, versionSupport);
        }
        return versionSupport;
    }

    public DocumentDomainObject getPublishedDocument(Integer documentId) {
        DocumentDomainObject document = this.publishedDocuments.get(documentId);
        if (null == document && (document = super.getPublishedDocument(documentId)) != null) {
            this.publishedDocuments.put(documentId, document);
        }
        return document;
    }

    public DocumentDomainObject getDocument(Integer documentId, Integer versionNumber) {
        DocumentVersionSupport versionSupport = this.getDocumentVersionSupport(documentId);
        if (versionSupport == null) {
            return null;
        }
        DocumentVersion version = versionSupport.getVersion(versionNumber);
        if (version == null) {
            return null;
        }
        switch (version.getTag()) {
            case WORKING: {
                return this.getWorkingDocument(documentId);
            }
            case PUBLISHED: {
                return this.getPublishedDocument(documentId);
            }
        }
        return super.getDocument(documentId, versionNumber);
    }

    public DocumentDomainObject getWorkingDocument(Integer documentId) {
        DocumentDomainObject document = this.workingDocuments.get(documentId);
        if (null == document && (document = super.getWorkingDocument(documentId)) != null) {
            this.workingDocuments.put(documentId, document);
        }
        return document;
    }

    public DocumentDomainObject getDocument(Integer documentId) {
        DocumentDomainObject document = this.latestDocuments.get(documentId);
        if (null == document && (document = super.getDocument(documentId)) != null) {
            this.latestDocuments.put(documentId, document);
        }
        return document;
    }

    public void clearCache() {
        this.publishedDocuments.clear();
        this.workingDocuments.clear();
        this.latestDocuments.clear();
        this.versionsSupports.clear();
        this.aliasesBidiMap.clear();
    }

    public void removeDocumentFromCache(Integer documentId) {
        this.publishedDocuments.remove(documentId);
        this.workingDocuments.remove(documentId);
        this.latestDocuments.remove(documentId);
        this.versionsSupports.remove(documentId);
        this.aliasesBidiMap.remove((Object)documentId);
    }

    public Integer getDocumentIdByAlias(String alias) {
        Integer documentId = (Integer)this.aliasesBidiMap.getKey((Object)alias);
        if (documentId == null && (documentId = this.metaDao.getDocumentIdByAlias(alias)) != null) {
            this.aliasesBidiMap.put((Object)documentId, (Object)alias);
        }
        return documentId;
    }

    public MetaDao getMetaDao() {
        return this.metaDao;
    }

    public void setMetaDao(MetaDao metaDao) {
        this.metaDao = metaDao;
    }
}

