/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.flow;

import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.I18nMeta;
import com.imcode.imcms.api.Meta;
import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.flow.DocumentPageFlow;
import com.imcode.imcms.flow.EditDocumentPageFlow;
import com.imcode.imcms.mapping.CategoryMapper;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.servlet.admin.ImageBrowser;
import com.imcode.imcms.servlet.admin.ListDocumentAliasPage;
import com.imcode.imcms.servlet.admin.UserFinder;
import com.imcode.imcms.util.l10n.LocalizedMessage;
import com.imcode.util.KeywordsParser;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.CategoryDomainObject;
import imcode.server.document.CategoryTypeDomainObject;
import imcode.server.document.DocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.HttpSessionUtils;
import imcode.util.Utility;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ObjectUtils;

public class EditDocumentInformationPageFlow
extends EditDocumentPageFlow {
    private static final String URL_I15D_PAGE__DOCINFO = "/jsp/docadmin/document_information.jsp";
    public static final String REQUEST_PARAMETER__HEADLINE = "headline";
    public static final String REQUEST_PARAMETER__MENUTEXT = "menutext";
    public static final String REQUEST_PARAMETER__COPY_HEADLINE_AND_TEXT_TO_TEXTFIELDS = "copy_headline_and_text_to_textfields";
    public static final String REQUEST_PARAMETER__IMAGE = "image";
    public static final String REQUEST_PARAMETER__DOCUMENT_ALIAS = "document_alias";
    public static final String REQUEST_PARAMETER__PUBLICATION_START_DATE = "activated_date";
    public static final String REQUEST_PARAMETER__PUBLICATION_START_TIME = "activated_time";
    public static final String REQUEST_PARAMETER__ARCHIVED_DATE = "archived_date";
    public static final String REQUEST_PARAMETER__ARCHIVED_TIME = "archived_time";
    public static final String REQUEST_PARAMETER__SECTIONS = "change_section";
    public static final String REQUEST_PARAMETER__PUBLICATION_END_DATE = "publication_end_date";
    public static final String REQUEST_PARAMETER__PUBLICATION_END_TIME = "publication_end_time";
    public static final String REQUEST_PARAMETER__CATEGORIES = "categories";
    public static final String REQUEST_PARAMETER__CATEGORY_IDS_TO_REMOVE = "categories_to_remove";
    public static final String REQUEST_PARAMETER__CATEGORY_IDS_TO_ADD = "categories_to_add";
    public static final String REQUEST_PARAMETER__ADD_CATEGORY = "add_category";
    public static final String REQUEST_PARAMETER__REMOVE_CATEGORY = "remove_category";
    public static final String REQUEST_PARAMETER__VISIBLE_IN_MENU_FOR_UNAUTHORIZED_USERS = "show_meta";
    public static final String REQUEST_PARAMETER__LINKABLE_BY_OTHER_USERS = "shared";
    public static final String REQUEST_PARAMETER__KEYWORDS = "classification";
    public static final String REQUEST_PARAMETER__SEARCH_DISABLED = "disable_search";
    public static final String REQUEST_PARAMETER__TARGET = "target";
    public static final String REQUEST_PARAMETER__CREATED_DATE = "date_created";
    public static final String REQUEST_PARAMETER__CREATED_TIME = "created_time";
    public static final String REQUEST_PARAMETER__MODIFIED_DATE = "date_modified";
    public static final String REQUEST_PARAMETER__MODIFIED_TIME = "modified_time";
    public static final String REQUEST_PARAMETER__STATUS = "status";
    public static final String REQUEST_PARAMETER__GO_TO_PUBLISHER_BROWSER = "browseForPublisher";
    public static final String REQUEST_PARAMETER__GO_TO_CREATOR_BROWSER = "browseForCreator";
    public static final String REQUEST_PARAMETER__GO_TO_IMAGE_BROWSER = "browseForMenuImage";
    public static final String REQUEST_PARAMETER__GO_TO_ALIAS_LIST = "listDocumentAlias";
    public static final String PAGE__DOCUMENT_INFORMATION = "document_information";
    public static final String REQUEST_PARAMETER__MISSING_I18N_SHOW_RULE = "missingI18nShowRule";
    public static final String REQUEST_PARAMETER__ENABLED_I18N = "activeLanguage";
    public static final String REQUEST_PARAMETER__I18N_CODE = "i18nCode";
    public static final String REQUEST_PARAMETER__STATUS__NEW = "new";
    public static final String REQUEST_PARAMETER__STATUS__APPROVED = "approved";
    public static final String REQUEST_PARAMETER__STATUS__DISAPPROVED = "disapproved";
    private static final LocalizedMessage BUTTON_TEXT__SELECT_USER = new LocalizedMessage("templates/sv/AdminChangeUser.htm/2007");
    private static final LocalizedMessage HEADLINE__SELECT_CREATOR = new LocalizedMessage("server/src/com/imcode/imcms/flow/EditDocumentInformationPageFlow/select_creator_headline");
    private static final LocalizedMessage HEADLINE__SELECT_PUBLISHER = new LocalizedMessage("server/src/com/imcode/imcms/flow/EditDocumentInformationPageFlow/select_publisher_headline");
    public static final LocalizedMessage ALIAS_ERROR__ALREADY_EXIST = new LocalizedMessage("server/src/com/imcode/imcms/flow/EditDocumentInformationPageFlow/alias_error__already_exist_message");
    public static final LocalizedMessage ALIAS_ERROR__USED_BY_SYSTEM = new LocalizedMessage("server/src/com/imcode/imcms/flow/EditDocumentInformationPageFlow/alias_error__used_by_system_message");
    private Set<LocalizedMessage> errors = new HashSet<LocalizedMessage>();
    private boolean adminButtonsHidden;

    public EditDocumentInformationPageFlow(DocumentDomainObject document, DispatchCommand returnCommand, DocumentPageFlow.SaveDocumentCommand saveDocumentCommand) {
        super(document, returnCommand, saveDocumentCommand);
    }

    protected void dispatchFromEditPage(HttpServletRequest request, HttpServletResponse response, String page) throws IOException, ServletException {
        if (PAGE__DOCUMENT_INFORMATION.equals(page)) {
            this.dispatchFromDocumentInformation(request, response);
        }
    }

    private void dispatchFromDocumentInformation(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        EditDocumentInformationPageFlow.setDocumentAttributesFromRequestParameters(this.document, request, this.errors);
        if (null != request.getParameter(REQUEST_PARAMETER__GO_TO_PUBLISHER_BROWSER)) {
            this.dispatchToPublisherUserBrowser(request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__GO_TO_CREATOR_BROWSER)) {
            this.dispatchToCreatorUserBrowser(request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__GO_TO_IMAGE_BROWSER)) {
            this.dispatchToImageBrowser(request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__GO_TO_ALIAS_LIST)) {
            this.dispatchToAliasList(request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__ADD_CATEGORY)) {
            if (null != request.getParameter(REQUEST_PARAMETER__CATEGORY_IDS_TO_ADD)) {
                String[] categoriesToAdd;
                for (String categoryIdToAdd : categoriesToAdd = request.getParameterValues(REQUEST_PARAMETER__CATEGORY_IDS_TO_ADD)) {
                    this.document.addCategoryId(Integer.parseInt(categoryIdToAdd));
                }
            }
            this.dispatchToFirstPage(request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__REMOVE_CATEGORY)) {
            if (null != request.getParameter(REQUEST_PARAMETER__CATEGORY_IDS_TO_REMOVE)) {
                String[] categoriesToRemove;
                for (String categoryIdToRemove : categoriesToRemove = request.getParameterValues(REQUEST_PARAMETER__CATEGORY_IDS_TO_REMOVE)) {
                    this.document.removeCategoryId(Integer.parseInt(categoryIdToRemove));
                }
            }
            this.dispatchToFirstPage(request, response);
        }
    }

    private void dispatchToImageBrowser(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        final String i18nCode = request.getParameter(REQUEST_PARAMETER__I18N_CODE);
        ImageBrowser imageBrowser = new ImageBrowser();
        final String flowSessionAttributeName = HttpSessionUtils.getSessionAttributeNameFromRequest(request, "flow");
        imageBrowser.setCancelCommand(new DispatchCommand(){

            public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                request.setAttribute("flow", (Object)flowSessionAttributeName);
                EditDocumentInformationPageFlow.this.dispatchToFirstPage(request, response);
            }
        });
        imageBrowser.setSelectImageUrlCommand(new ImageBrowser.SelectImageUrlCommand(){

            public void selectImageUrl(String imageUrl, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if (i18nCode != null) {
                    for (I18nMeta i18nPart : EditDocumentInformationPageFlow.this.document.getMeta().getI18nMetas()) {
                        if (!i18nPart.getLanguage().getCode().equals(i18nCode)) continue;
                        i18nPart.setMenuImageURL(imageUrl);
                        break;
                    }
                }
                request.setAttribute("flow", (Object)flowSessionAttributeName);
                EditDocumentInformationPageFlow.this.dispatchToFirstPage(request, response);
            }
        });
        imageBrowser.forward(request, response);
    }

    private void dispatchToAliasList(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        final String flowSessionAttributeName = HttpSessionUtils.getSessionAttributeNameFromRequest(request, "flow");
        DispatchCommand cancelCommand = new DispatchCommand(){

            public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                request.setAttribute("flow", (Object)flowSessionAttributeName);
                EditDocumentInformationPageFlow.this.dispatchToFirstPage(request, response);
            }
        };
        new ListDocumentAliasPage(null, cancelCommand, request).forward(request, response);
    }

    private void dispatchToPublisherUserBrowser(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        final String flowSessionAttributeName = HttpSessionUtils.getSessionAttributeNameFromRequest(request, "flow");
        this.dispatchToUserBrowser(request, response, true, HEADLINE__SELECT_PUBLISHER, new UserFinder.SelectUserCommand(){

            public void selectUser(UserDomainObject selectedUser, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                EditDocumentInformationPageFlow.this.document.setPublisher(selectedUser);
                request.setAttribute("flow", (Object)flowSessionAttributeName);
                EditDocumentInformationPageFlow.this.dispatchToFirstPage(request, response);
            }
        });
    }

    private void dispatchToCreatorUserBrowser(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        final String flowSessionAttributeName = HttpSessionUtils.getSessionAttributeNameFromRequest(request, "flow");
        this.dispatchToUserBrowser(request, response, false, HEADLINE__SELECT_CREATOR, new UserFinder.SelectUserCommand(){

            public void selectUser(UserDomainObject selectedUser, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                EditDocumentInformationPageFlow.this.document.setCreator(selectedUser);
                request.setAttribute("flow", (Object)flowSessionAttributeName);
                EditDocumentInformationPageFlow.this.dispatchToFirstPage(request, response);
            }
        });
    }

    private void dispatchToUserBrowser(HttpServletRequest request, HttpServletResponse response, boolean nullSelectable, LocalizedMessage headline, UserFinder.SelectUserCommand selectUserCommand) throws IOException, ServletException {
        UserFinder userFinder = UserFinder.getInstance(request);
        userFinder.setHeadline(headline);
        userFinder.setSelectButtonText(BUTTON_TEXT__SELECT_USER);
        userFinder.setUsersAddable(false);
        userFinder.setNullSelectable(nullSelectable);
        userFinder.setSelectUserCommand(selectUserCommand);
        final String flowSessionAttributeName = HttpSessionUtils.getSessionAttributeNameFromRequest(request, "flow");
        userFinder.setCancelCommand(new DispatchCommand(){

            public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                request.setAttribute("flow", (Object)flowSessionAttributeName);
                EditDocumentInformationPageFlow.this.dispatchToFirstPage(request, response);
            }
        });
        userFinder.forward(request, response);
    }

    protected void dispatchToFirstPage(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.dispatchToDocumentInformationPage(request, response);
    }

    private void dispatchToDocumentInformationPage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DocumentInformationPage documentInformationPage = new DocumentInformationPage(this.getDocument(), this.adminButtonsHidden, this.errors);
        documentInformationPage.forward(request, response);
    }

    protected void dispatchOkFromEditPage(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.dispatchOkFromDocumentInformation(request, response);
    }

    private void dispatchOkFromDocumentInformation(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        EditDocumentInformationPageFlow.setDocumentAttributesFromRequestParameters(this.document, request, this.errors);
        if (!this.errors.isEmpty()) {
            this.dispatchToDocumentInformationPage(request, response);
        }
    }

    private static void setDocumentAttributesFromRequestParameters(DocumentDomainObject document, HttpServletRequest request, Set errors) {
        CategoryTypeDomainObject[] categoryTypes;
        ImcmsServices service = Imcms.getServices();
        CategoryMapper categoryMapper = service.getCategoryMapper();
        DocumentMapper documentMapper = service.getDocumentMapper();
        Meta meta = document.getMeta();
        for (I18nMeta i18nMeta : meta.getI18nMetas()) {
            String suffix = "_" + i18nMeta.getLanguage().getCode();
            String headline = request.getParameter(REQUEST_PARAMETER__HEADLINE + suffix);
            String menuText = request.getParameter(REQUEST_PARAMETER__MENUTEXT + suffix);
            String imageURL = request.getParameter(REQUEST_PARAMETER__IMAGE + suffix);
            boolean enabled = request.getParameter(REQUEST_PARAMETER__ENABLED_I18N + suffix) != null;
            i18nMeta.setHeadline(headline);
            i18nMeta.setMenuText(menuText);
            i18nMeta.setEnabled(enabled);
            i18nMeta.setMenuImageURL(imageURL);
            String keywordsString = request.getParameter(REQUEST_PARAMETER__KEYWORDS + suffix);
            KeywordsParser keywordsParser = new KeywordsParser();
            String[] values = keywordsParser.parseKeywords(keywordsString);
            HashSet<String> keywords = new HashSet<String>();
            for (String keyword : values) {
                keywords.add(keyword);
            }
            i18nMeta.setKeywords(keywords);
        }
        String missingI18nShowRule = request.getParameter(REQUEST_PARAMETER__MISSING_I18N_SHOW_RULE);
        meta.setUnavailableI18nDataSubstitution(Meta.UnavailableI18nDataSubstitution.valueOf(missingI18nShowRule));
        String status = request.getParameter(REQUEST_PARAMETER__STATUS);
        Document.PublicationStatus publicationStatus = EditDocumentInformationPageFlow.publicationStatusFromString(status);
        document.setPublicationStatus(publicationStatus);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
        Date publicationStartDatetime = EditDocumentInformationPageFlow.parseDatetimeParameters(request, REQUEST_PARAMETER__PUBLICATION_START_DATE, REQUEST_PARAMETER__PUBLICATION_START_TIME, dateFormat, timeFormat);
        Date archivedDatetime = EditDocumentInformationPageFlow.parseDatetimeParameters(request, REQUEST_PARAMETER__ARCHIVED_DATE, REQUEST_PARAMETER__ARCHIVED_TIME, dateFormat, timeFormat);
        Date publicationEndDatetime = EditDocumentInformationPageFlow.parseDatetimeParameters(request, REQUEST_PARAMETER__PUBLICATION_END_DATE, REQUEST_PARAMETER__PUBLICATION_END_TIME, dateFormat, timeFormat);
        document.setPublicationStartDatetime(publicationStartDatetime);
        document.setArchivedDatetime(archivedDatetime);
        document.setPublicationEndDatetime(publicationEndDatetime);
        document.removeAllSections();
        String[] sectionIds = request.getParameterValues(REQUEST_PARAMETER__SECTIONS);
        for (int i = 0; null != sectionIds && i < sectionIds.length; ++i) {
            int sectionId = Integer.parseInt(sectionIds[i]);
            document.addSectionId(sectionId);
        }
        for (CategoryTypeDomainObject categoryType : categoryTypes = categoryMapper.getAllCategoryTypes()) {
            boolean shouldRemoveCategoriesOfType;
            boolean categoryTypeIsSingleChoice = 1 == categoryType.getMaxChoices();
            boolean bl = shouldRemoveCategoriesOfType = categoryTypeIsSingleChoice || categoryType.hasImages();
            if (!shouldRemoveCategoriesOfType) continue;
            Set<Integer> categoryIds = document.getCategoryIds();
            Set categoriesOfType = categoryMapper.getCategoriesOfType(categoryType, categoryIds);
            for (CategoryDomainObject category : categoriesOfType) {
                document.removeCategoryId(category.getId());
            }
        }
        String[] categoryIds = request.getParameterValues(REQUEST_PARAMETER__CATEGORIES);
        for (int i = 0; null != categoryIds && i < categoryIds.length; ++i) {
            try {
                int categoryId = Integer.parseInt(categoryIds[i]);
                document.addCategoryId(categoryId);
                continue;
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        boolean visibleInMenuForUnauthorizedUsers = "1".equals(request.getParameter(REQUEST_PARAMETER__VISIBLE_IN_MENU_FOR_UNAUTHORIZED_USERS));
        document.setLinkedForUnauthorizedUsers(visibleInMenuForUnauthorizedUsers);
        boolean linkableByOtherUsers = "1".equals(request.getParameter(REQUEST_PARAMETER__LINKABLE_BY_OTHER_USERS));
        document.setLinkableByOtherUsers(linkableByOtherUsers);
        if (null != request.getParameter(REQUEST_PARAMETER__DOCUMENT_ALIAS)) {
            errors.remove(ALIAS_ERROR__ALREADY_EXIST);
            errors.remove(ALIAS_ERROR__USED_BY_SYSTEM);
            String oldAlias = document.getAlias();
            String newAlias = request.getParameter(REQUEST_PARAMETER__DOCUMENT_ALIAS).trim().replaceAll("[%?]", "");
            if (oldAlias == null || !newAlias.equals(oldAlias.toLowerCase()) && newAlias.length() > 0) {
                Set<String> allAlias = documentMapper.getAllDocumentAlias();
                File path = new File(Imcms.getPath(), newAlias);
                if (allAlias.contains(newAlias.toLowerCase())) {
                    errors.add(ALIAS_ERROR__ALREADY_EXIST);
                    newAlias = oldAlias;
                } else if (newAlias.length() > 0 && path.exists()) {
                    errors.add(ALIAS_ERROR__USED_BY_SYSTEM);
                    newAlias = oldAlias;
                }
            }
            if (newAlias != null && newAlias.length() > 0) {
                document.setAlias(newAlias);
            } else {
                document.setAlias(null);
            }
        }
        boolean searchDisabled = "1".equals(request.getParameter(REQUEST_PARAMETER__SEARCH_DISABLED));
        document.setSearchDisabled(searchDisabled);
        String target = EditDocumentInformationPageFlow.getTargetFromRequest(request, REQUEST_PARAMETER__TARGET);
        document.setTarget(target);
        Date createdDatetime = (Date)ObjectUtils.defaultIfNull((Object)EditDocumentInformationPageFlow.parseDatetimeParameters(request, REQUEST_PARAMETER__CREATED_DATE, REQUEST_PARAMETER__CREATED_TIME, dateFormat, timeFormat), (Object)new Date());
        Date modifiedDatetime = (Date)ObjectUtils.defaultIfNull((Object)EditDocumentInformationPageFlow.parseDatetimeParameters(request, REQUEST_PARAMETER__MODIFIED_DATE, REQUEST_PARAMETER__MODIFIED_TIME, dateFormat, timeFormat), (Object)createdDatetime);
        document.setCreatedDatetime(createdDatetime);
        document.setModifiedDatetime(modifiedDatetime);
    }

    private static Document.PublicationStatus publicationStatusFromString(String status) {
        Document.PublicationStatus publicationStatus = null;
        if (status.equals(REQUEST_PARAMETER__STATUS__NEW)) {
            publicationStatus = Document.PublicationStatus.NEW;
        } else if (status.equals(REQUEST_PARAMETER__STATUS__APPROVED)) {
            publicationStatus = Document.PublicationStatus.APPROVED;
        } else if (status.equals(REQUEST_PARAMETER__STATUS__DISAPPROVED)) {
            publicationStatus = Document.PublicationStatus.DISAPPROVED;
        }
        return publicationStatus;
    }

    public static String getTargetFromRequest(HttpServletRequest request, String parameterName) {
        String[] possibleTargets = request.getParameterValues(parameterName);
        String target = null;
        if (null != possibleTargets) {
            for (String possibleTarget : possibleTargets) {
                boolean targetIsPredefinedTarget;
                target = possibleTarget;
                boolean bl = targetIsPredefinedTarget = "_self".equalsIgnoreCase(target) || "_blank".equalsIgnoreCase(target) || "_parent".equalsIgnoreCase(target) || "_top".equalsIgnoreCase(target);
                if (targetIsPredefinedTarget) break;
            }
        }
        return target;
    }

    private static Date parseDatetimeParameters(HttpServletRequest req, String dateParameterName, String timeParameterName, DateFormat dateformat, DateFormat timeformat) {
        Date time;
        Date date;
        String dateStr = req.getParameter(dateParameterName);
        String timeStr = req.getParameter(timeParameterName);
        try {
            date = dateformat.parse(dateStr);
        }
        catch (ParseException pe) {
            return null;
        }
        catch (NullPointerException npe) {
            return null;
        }
        try {
            timeformat.setTimeZone(TimeZone.getTimeZone("GMT"));
            time = timeformat.parse(timeStr);
        }
        catch (ParseException pe) {
            return date;
        }
        catch (NullPointerException npe) {
            return date;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(14, (int)time.getTime());
        return calendar.getTime();
    }

    public void setAdminButtonsHidden(boolean adminButtonsHidden) {
        this.adminButtonsHidden = adminButtonsHidden;
    }

    public static class DocumentInformationPage {
        private static final String REQUEST_ATTRIBUTE__DOCUMENT_INFORMATION_PAGE = "documentInformationPage";
        private DocumentDomainObject document;
        private boolean adminButtonsHidden;
        private Set errors;
        private Meta meta;

        public DocumentInformationPage(DocumentDomainObject document, boolean adminButtonsHidden, Set errors) {
            this.document = document;
            this.adminButtonsHidden = adminButtonsHidden;
            this.errors = errors;
        }

        public void forward(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            request.setAttribute(REQUEST_ATTRIBUTE__DOCUMENT_INFORMATION_PAGE, (Object)this);
            UserDomainObject user = Utility.getLoggedOnUser(request);
            request.getRequestDispatcher("/imcms/" + user.getLanguageIso639_2() + EditDocumentInformationPageFlow.URL_I15D_PAGE__DOCINFO).forward((ServletRequest)request, (ServletResponse)response);
        }

        public static DocumentInformationPage fromRequest(HttpServletRequest request) {
            return (DocumentInformationPage)request.getAttribute(REQUEST_ATTRIBUTE__DOCUMENT_INFORMATION_PAGE);
        }

        public DocumentDomainObject getDocument() {
            return this.document;
        }

        public boolean isAdminButtonsHidden() {
            return this.adminButtonsHidden;
        }

        public Set getErrors() {
            return this.errors;
        }
    }
}

