/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.dao;

import com.imcode.imcms.api.Content;
import com.imcode.imcms.api.ContentLoop;
import java.util.List;
import org.hibernate.Query;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentLoopDao
extends HibernateTemplate {
    private ContentIndexes getNextContentIndexes(Long loopId) {
        List nextIndexesList = this.findByNamedQueryAndNamedParam("Content.getNextIndexes", "loopId", loopId);
        Object[] indexes = (Object[])nextIndexesList.get(0);
        Integer lower = indexes[0] == null ? 0 : (Integer)indexes[0];
        Integer higher = indexes[1] == null ? 0 : (Integer)indexes[1];
        Integer sequence = indexes[2] == null ? 0 : (Integer)indexes[2];
        return new ContentIndexes(lower, higher, sequence);
    }

    @Transactional
    public synchronized Content addFisrtContent(Long loopId) {
        ContentIndexes indexes = this.getNextContentIndexes(loopId);
        return this.createContent(loopId, indexes.sequence, indexes.lower);
    }

    @Transactional
    public Content addFisrtContent(ContentLoop loop) {
        return this.addFisrtContent(loop.getId());
    }

    @Transactional
    public synchronized Content addLastContent(Long loopId) {
        ContentIndexes indexes = this.getNextContentIndexes(loopId);
        return this.createContent(loopId, indexes.sequence, indexes.higher);
    }

    @Transactional
    public Content addLastContent(ContentLoop loop) {
        return this.addLastContent(loop.getId());
    }

    @Transactional
    public synchronized ContentLoop saveContentLoop(Integer documentId, ContentLoop contentLoop) {
        Long loopId = contentLoop.getId();
        if (loopId != null) {
            this.getSession().createQuery("DELETE FROM Content c WHERE c.loopId = :loopId").setParameter("loopId", (Object)loopId).executeUpdate();
            this.getSession().createQuery("DELETE FROM ContentLoop l WHERE l.id = :id").setParameter("id", (Object)loopId).executeUpdate();
        }
        for (Content content : contentLoop.getContents()) {
            content.setId(null);
            content.setLoopId(null);
        }
        contentLoop.setId(null);
        contentLoop.setMetaId(documentId);
        this.save(contentLoop);
        return contentLoop;
    }

    private Content createContent(Long loopId, Integer sequenceIndex, Integer orderIndex) {
        Content content = new Content();
        content.setLoopId(loopId);
        content.setSequenceIndex(sequenceIndex);
        content.setOrderIndex(orderIndex);
        this.save(content);
        return content;
    }

    @Transactional
    public ContentLoop createContentLoop(Integer documentId, Integer loopIndex, Integer baseIndex) {
        ContentLoop loop = new ContentLoop();
        loop.setMetaId(documentId);
        loop.setIndex(loopIndex);
        loop.setBaseIndex(baseIndex);
        this.save(loop);
        return loop;
    }

    @Transactional
    public void deleteContent(Long id) {
        this.getSession().getNamedQuery("Content.delete").setParameter("id", (Object)id).executeUpdate();
    }

    @Transactional
    public synchronized void deleteContent(ContentLoop loop, int sequenceIndex) {
        Long contentId = this.getContentId(loop.getId(), sequenceIndex);
        this.deleteContent(contentId);
    }

    @Transactional
    public void deleteContent(Content content) {
        this.deleteContent(content.getId());
    }

    @Transactional
    public ContentLoop getContentLoop(Integer documentId, Integer index) {
        return (ContentLoop)this.getSession().getNamedQuery("ContentLoop.getByMetaIdAndIndex").setParameter("metaId", (Object)documentId).setParameter("index", (Object)index).uniqueResult();
    }

    @Transactional
    public List<ContentLoop> getContentLoops(Integer documentId) {
        return this.findByNamedQueryAndNamedParam("ContentLoop.getByMetaId", "metaId", documentId);
    }

    private Long getContentId(Long loopId, Integer sequenceIndex) {
        return (Long)this.getSession().getNamedQuery("Content.getContentIdByLoopIdAndSequenceIndex").setParameter("loopId", (Object)loopId).setParameter("sequenceIndex", (Object)sequenceIndex).uniqueResult();
    }

    @Transactional
    public synchronized void moveContentUp(ContentLoop loop, Integer sequenceIndex) {
        Long contentId = this.getContentId(loop.getId(), sequenceIndex);
        if (contentId != null) {
            this.moveContentUp(loop, contentId);
        }
    }

    @Transactional
    public synchronized void moveContentUp(ContentLoop loop, Long contentId) {
        List<Content> contents = loop.getContents();
        int size = contents.size();
        Query hql = this.getSession().getNamedQuery("Content.updateOrderIndex");
        for (int i = 0; i < size; ++i) {
            Content content = contents.get(i);
            if (!content.getId().equals(contentId)) continue;
            if (i == 0) break;
            ContentIndexes contentIndexes = this.getNextContentIndexes(loop.getId());
            Content prevContent = contents.get(i - 1);
            Integer prevIndex = prevContent.getOrderIndex();
            Integer currentIndex = content.getOrderIndex();
            Integer tempIndex = contentIndexes.higher;
            hql.setParameter("orderIndex", (Object)tempIndex);
            hql.setLong("id", prevContent.getId().longValue());
            int n = hql.executeUpdate();
            hql.setParameter("orderIndex", (Object)prevIndex);
            hql.setLong("id", content.getId().longValue());
            n = hql.executeUpdate();
            hql.setParameter("orderIndex", (Object)currentIndex);
            hql.setLong("id", prevContent.getId().longValue());
            n = hql.executeUpdate();
            break;
        }
    }

    @Transactional
    public synchronized void moveContentDown(ContentLoop loop, Integer sequenceIndex) {
        Long contentId = this.getContentId(loop.getId(), sequenceIndex);
        if (contentId != null) {
            this.moveContentDown(loop, contentId);
        }
    }

    @Transactional
    public synchronized void moveContentDown(ContentLoop loop, Long contentId) {
        List<Content> contents = loop.getContents();
        int size = contents.size();
        Query hql = this.getSession().getNamedQuery("Content.updateOrderIndex");
        for (int i = 0; i < size; ++i) {
            Content content = contents.get(i);
            if (!content.getId().equals(contentId)) continue;
            if (i == size - 1) break;
            ContentIndexes contentIndexes = this.getNextContentIndexes(loop.getId());
            Content nextContent = contents.get(i + 1);
            Integer nextIndex = nextContent.getOrderIndex();
            Integer currentIndex = content.getOrderIndex();
            Integer tempIndex = contentIndexes.lower;
            hql.setParameter("orderIndex", (Object)tempIndex);
            hql.setLong("id", nextContent.getId().longValue());
            int n = hql.executeUpdate();
            hql.setParameter("orderIndex", (Object)nextIndex);
            hql.setLong("id", content.getId().longValue());
            n = hql.executeUpdate();
            hql.setParameter("orderIndex", (Object)currentIndex);
            hql.setLong("id", nextContent.getId().longValue());
            n = hql.executeUpdate();
            break;
        }
    }

    @Transactional
    public synchronized Content insertNewContentAfter(ContentLoop loop, Integer sequenceIndex) {
        Long contentId = this.getContentId(loop.getId(), sequenceIndex);
        if (contentId == null) {
            throw new RuntimeException(String.format("Content with loop id=%s and sequence index=%s does not exist.", loop.getId(), sequenceIndex));
        }
        return this.insertNewContentAfter(loop, contentId);
    }

    @Transactional
    public synchronized Content insertNewContentAfter(ContentLoop loop, Long contentId) {
        Query hql = this.getSession().getNamedQuery("Content.updateOrderIndex");
        ContentIndexes contentIndexes = this.getNextContentIndexes(loop.getId());
        int nextHigherOrderIndex = contentIndexes.higher;
        Content newContent = null;
        List<Content> contents = loop.getContents();
        int size = contents.size();
        for (int i = size - 1; i >= 0; --i) {
            Content content = contents.get(i);
            if (content.getId().equals(contentId)) {
                newContent = new Content();
                newContent.setLoopId(loop.getId());
                newContent.setSequenceIndex(contentIndexes.sequence);
                newContent.setOrderIndex(nextHigherOrderIndex);
                this.save(newContent);
                break;
            }
            int currentOrderIndex = content.getOrderIndex();
            hql.setParameter("orderIndex", (Object)nextHigherOrderIndex);
            hql.setParameter("id", (Object)content.getId());
            hql.executeUpdate();
            nextHigherOrderIndex = currentOrderIndex;
        }
        if (newContent == null) {
            throw new RuntimeException("Content with id [" + contentId + "] not found for loop id [" + loop.getId() + "].");
        }
        return newContent;
    }

    @Transactional
    public synchronized Content insertNewContentBefore(ContentLoop loop, Integer sequenceIndex) {
        Long contentId = this.getContentId(loop.getId(), sequenceIndex);
        if (contentId == null) {
            throw new RuntimeException(String.format("Content with loop id=%s and sequence index=%s does not exist.", loop.getId(), sequenceIndex));
        }
        return this.insertNewContentBefore(loop, contentId);
    }

    @Transactional
    public synchronized Content insertNewContentBefore(ContentLoop loop, Long contentId) {
        Query hql = this.getSession().getNamedQuery("Content.updateOrderIndex");
        ContentIndexes contentIndexes = this.getNextContentIndexes(loop.getId());
        int nextLowerOrderIndex = contentIndexes.lower;
        Content newContent = null;
        for (Content content : loop.getContents()) {
            if (content.getId().equals(contentId)) {
                newContent = new Content();
                newContent.setLoopId(loop.getId());
                newContent.setSequenceIndex(contentIndexes.sequence);
                newContent.setOrderIndex(nextLowerOrderIndex);
                this.save(newContent);
                break;
            }
            int currentOrderIndex = content.getOrderIndex();
            hql.setParameter("orderIndex", (Object)nextLowerOrderIndex);
            hql.setParameter("id", (Object)content.getId());
            hql.executeUpdate();
            nextLowerOrderIndex = currentOrderIndex;
        }
        if (newContent == null) {
            throw new RuntimeException("Content with id [" + contentId + "] not found for loop id [" + loop.getId() + "].");
        }
        return newContent;
    }

    private static final class ContentIndexes {
        final Integer lower;
        final Integer higher;
        final Integer sequence;

        public ContentIndexes(Integer lower, Integer higher, Integer sequence) {
            this.lower = lower;
            this.higher = higher;
            this.sequence = sequence;
        }
    }
}

