/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.I18nException;
import com.imcode.imcms.api.I18nLanguage;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class I18nSupport {
    private static ThreadLocal<I18nLanguage> currentLanguage = new ThreadLocal();
    private static I18nLanguage defaultLanguage;
    private static List<I18nLanguage> languages;
    private static Map<String, I18nLanguage> codeMap;
    private static Map<Integer, I18nLanguage> idMap;

    private I18nSupport() {
    }

    public static void setDefaultLanguage(I18nLanguage language) throws IllegalArgumentException {
        if (language == null) {
            throw new IllegalArgumentException("Language argument can not be null.");
        }
        defaultLanguage = language;
    }

    public static I18nLanguage getDefaultLanguage() throws I18nException {
        if (defaultLanguage == null) {
            throw new I18nException("Default language is not set.");
        }
        return defaultLanguage;
    }

    public static I18nLanguage getCurrentLanguage() throws I18nException {
        I18nLanguage language = currentLanguage.get();
        if (language == null) {
            throw new I18nException("Current language is not set.");
        }
        return language;
    }

    public static void setCurrentLanguage(I18nLanguage language) throws IllegalArgumentException {
        if (language == null) {
            throw new IllegalArgumentException("Language argument can not be null.");
        }
        currentLanguage.set(language);
    }

    public static boolean isDefault(I18nLanguage language) {
        if (language == null) {
            throw new IllegalArgumentException("Language argument can not be null.");
        }
        return language.equals(I18nSupport.getDefaultLanguage());
    }

    public static boolean isCurrent(I18nLanguage language) {
        if (language == null) {
            throw new IllegalArgumentException("Language argument can not be null.");
        }
        return language.equals(I18nSupport.getCurrentLanguage());
    }

    public static List<I18nLanguage> getLanguages() {
        return languages;
    }

    public static void setLanguages(List<I18nLanguage> languages) {
        if (languages == null) {
            throw new IllegalArgumentException("Languages argument can not be null.");
        }
        I18nSupport.languages = languages;
        idMap = new HashMap<Integer, I18nLanguage>();
        codeMap = new HashMap<String, I18nLanguage>();
        for (I18nLanguage language : languages) {
            idMap.put(language.getId(), language);
            codeMap.put(language.getCode(), language);
        }
    }

    public static I18nLanguage getByCode(String code) {
        return codeMap.get(code);
    }

    public static I18nLanguage getById(Integer id) {
        return idMap.get(id);
    }

    public static boolean isEnabled() {
        return defaultLanguage != null && currentLanguage != null;
    }

    public static boolean getCurrentIsDefault() {
        return I18nSupport.getCurrentLanguage().equals(I18nSupport.getDefaultLanguage());
    }
}

