/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.DocumentVersion;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentVersionSupport {
    private Integer documentId;
    private DocumentVersion latestVersion;
    private DocumentVersion workingVersion;
    private DocumentVersion publishedVersion;
    private List<DocumentVersion> versions;
    private Map<Integer, DocumentVersion> versionsMap = new TreeMap<Integer, DocumentVersion>();

    public DocumentVersionSupport(Integer documentId, List<DocumentVersion> versions) {
        for (DocumentVersion version : versions) {
            this.versionsMap.put(version.getNumber(), version);
            switch (version.getTag()) {
                case PUBLISHED: {
                    this.publishedVersion = version;
                    break;
                }
                case WORKING: {
                    this.workingVersion = version;
                }
            }
            this.latestVersion = version;
        }
        this.documentId = documentId;
        this.versions = Collections.unmodifiableList(versions);
        this.versionsMap = Collections.unmodifiableMap(this.versionsMap);
    }

    public Integer getDocumentId() {
        return this.documentId;
    }

    public DocumentVersion getVersion(Integer versionNumber) {
        return this.versionsMap.get(versionNumber);
    }

    public boolean isPublishedVersionNumber(Integer versionNumber) {
        return this.hasPublishedVersion() && this.getPublishedVersion().getNumber().equals(versionNumber);
    }

    public boolean isWorkingVersionNumber(Integer versionNumber) {
        return this.hasWorkingVersion() && this.getWorkingVersion().getNumber().equals(versionNumber);
    }

    public DocumentVersion getLatestVersion() {
        return this.latestVersion;
    }

    public DocumentVersion getWorkingVersion() {
        return this.workingVersion;
    }

    public DocumentVersion getPublishedVersion() {
        return this.publishedVersion;
    }

    public List<DocumentVersion> getVersions() {
        return this.versions;
    }

    public Map<Integer, DocumentVersion> getVersionsMap() {
        return this.versionsMap;
    }

    public boolean hasWorkingVersion() {
        return this.workingVersion != null;
    }

    public boolean hasPublishedVersion() {
        return this.publishedVersion != null;
    }

    public int getVersionsCount() {
        return this.versions.size();
    }

    public Integer getPuplishedVersionNumber() {
        return this.hasPublishedVersion() ? this.getPublishedVersion().getNumber() : null;
    }

    public Integer getWorkingVersionNumber() {
        return this.hasWorkingVersion() ? this.getWorkingVersion().getNumber() : null;
    }
}

