/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.mapping.DocumentGetter;
import imcode.server.document.DocumentDomainObject;

public class DocumentVersionSelector {
    public static final DocumentVersionSelector PUBLISHED_SELECTOR = new DocumentVersionSelector(Type.PUBLISHED, null){

        public DocumentDomainObject getDocument(DocumentGetter documentGetter, Integer documentId) {
            return documentGetter.getPublishedDocument(documentId);
        }
    };
    public static final DocumentVersionSelector WORKING_SELECTOR = new DocumentVersionSelector(Type.WORKING, null){

        public DocumentDomainObject getDocument(DocumentGetter documentGetter, Integer documentId) {
            return documentGetter.getWorkingDocument(documentId);
        }
    };
    private final Type type;
    private final Integer versionNumber;

    private DocumentVersionSelector(Type type, Integer number) {
        this.type = type;
        this.versionNumber = number;
    }

    public static DocumentVersionSelector createCustomSelector(Integer number) {
        if (number == null) {
            throw new IllegalArgumentException("number argument can not be null.");
        }
        return new DocumentVersionSelector(Type.CUSTOM, number);
    }

    public static DocumentVersionSelector getPredefinedSelector(String typeName) {
        try {
            switch (Type.valueOf(typeName.toUpperCase())) {
                case PUBLISHED: {
                    return PUBLISHED_SELECTOR;
                }
                case WORKING: {
                    return WORKING_SELECTOR;
                }
            }
            throw new IllegalArgumentException(String.format("%s is not a predefined selector's type name. Legal type names are: %s and %s", new Object[]{typeName, Type.PUBLISHED, Type.WORKING}));
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("typeName argument can not be null.", e);
        }
    }

    public DocumentDomainObject getDocument(DocumentGetter documentGetter, Integer documentId) {
        return documentGetter.getDocument(documentId, this.versionNumber);
    }

    public Type getType() {
        return this.type;
    }

    public Integer getVersionNumber() {
        return this.versionNumber;
    }

    public boolean isPublished() {
        return this.type == Type.WORKING;
    }

    public boolean isWorking() {
        return this.type == Type.PUBLISHED;
    }

    public boolean isCustom() {
        return this.type == Type.CUSTOM;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        PUBLISHED,
        WORKING,
        CUSTOM;

    }
}

