/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import imcode.util.FallbackDecoder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.CopyUtils;

public class CachingFileLoader {
    private static final int FILE_CACHE_SIZE = 100;
    private Map fileCache = Collections.synchronizedMap(new LRUMap(100));

    public String getCachedFileString(File file) throws IOException {
        String cachedContents = this.getCachedFileStringIfRecent(file);
        if (null == cachedContents) {
            cachedContents = this.decodeFile(file);
            this.cacheFile(file, cachedContents);
        }
        return cachedContents;
    }

    private String decodeFile(File file) throws IOException {
        Charset utf8Charset = Charset.forName("UTF-8");
        Charset fallbackCharset = Charset.defaultCharset();
        if (fallbackCharset.equals(utf8Charset) || fallbackCharset.equals(Charset.forName("US-ASCII"))) {
            fallbackCharset = Charset.forName("ISO-8859-1");
        }
        return this.decodeFile(file, utf8Charset, fallbackCharset);
    }

    private String decodeFile(File file, Charset charset, Charset fallbackCharset) throws IOException {
        return new FallbackDecoder(charset, fallbackCharset).decodeBytes(this.readFile(file), "file " + file.toString());
    }

    private byte[] readFile(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        CopyUtils.copy((InputStream)fileInputStream, (OutputStream)os);
        return os.toByteArray();
    }

    private void cacheFile(File file, String contents) {
        this.fileCache.put(file, new Object[]{contents, new Long(System.currentTimeMillis())});
    }

    public String getCachedFileStringIfRecent(File file) {
        Object[] file_and_date = (Object[])this.fileCache.get(file);
        if (file_and_date != null && file.lastModified() <= (Long)file_and_date[1]) {
            return (String)file_and_date[0];
        }
        return null;
    }
}

