/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.user;

import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import com.imcode.db.commands.CompositeDatabaseCommand;
import com.imcode.db.commands.DeleteWhereColumnsEqualDatabaseCommand;
import com.imcode.db.commands.InsertIntoTableDatabaseCommand;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.db.commands.TransactionDatabaseCommand;
import com.imcode.db.exceptions.IntegrityConstraintViolationException;
import com.imcode.db.exceptions.StringTruncationException;
import com.imcode.imcms.db.StringArrayResultSetHandler;
import imcode.server.ImcmsServices;
import imcode.server.user.Authenticator;
import imcode.server.user.NameTooLongException;
import imcode.server.user.PhoneNumber;
import imcode.server.user.PhoneNumberType;
import imcode.server.user.RoleAlreadyExistsException;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.RoleGetter;
import imcode.server.user.RoleId;
import imcode.server.user.RolePermissionDomainObject;
import imcode.server.user.UserAlreadyExistsException;
import imcode.server.user.UserAndRoleRegistry;
import imcode.server.user.UserAndRoleRegistryException;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;

public class ImcmsAuthenticatorAndUserAndRoleMapper
implements UserAndRoleRegistry,
Authenticator,
RoleGetter {
    private static final Logger log = Logger.getLogger(ImcmsAuthenticatorAndUserAndRoleMapper.class);
    private static final String SPROC_GET_ALL_ROLES = "GetAllRoles";
    private static final String SPROC_GET_USER_ROLES = "GetUserRoles";
    private static final String SPROC_GET_USERS_WHO_BELONGS_TO_ROLE = "GetUsersWhoBelongsToRole";
    private static final String SPROC_DEL_PHONE_NR = "DelPhoneNr";
    private static final int USER_EXTERN_ID = 2;
    private static final String SQL_SELECT_USERS = "SELECT user_id, login_name, login_password, first_name, last_name, title, company, address, city, zip, country, county_council, email, language, active, create_date, external, session_id FROM users";
    public static final String SQL_ROLES_COLUMNS = "roles.role_id, roles.role_name, roles.admin_role, roles.permissions";
    private static final String SQL_SELECT_ALL_ROLES = "SELECT roles.role_id, roles.role_name, roles.admin_role, roles.permissions FROM roles";
    private static final String SQL_SELECT_ALL_ROLES_EXCEPT_USERS_ROLE = "SELECT roles.role_id, roles.role_name, roles.admin_role, roles.permissions FROM roles WHERE roles.role_id != 2";
    public static final String SQL_SELECT_ROLE_BY_NAME = "SELECT roles.role_id, roles.role_name, roles.admin_role, roles.permissions FROM roles WHERE role_name = ?";
    private static final String SQL_SELECT_ROLE_BY_ID = "SELECT roles.role_id, roles.role_name, roles.admin_role, roles.permissions FROM roles WHERE role_id = ?";
    public static final String SQL_INSERT_INTO_ROLES = "INSERT INTO roles (role_name, permissions, admin_role) VALUES(?,?,0)";
    private static final String TABLE__USERADMIN_ROLE_CROSSREF = "useradmin_role_crossref";
    private static final String SQL__SELECT_USER_BY_ID = "SELECT user_id, login_name, login_password, first_name, last_name, title, company, address, city, zip, country, county_council, email, language, active, create_date, external, session_id FROM users WHERE user_id = ?";
    private static final String SQL_UPDATE_USER_SESSION = "update users set session_id = ? where user_id = ?";
    private static final String SQL_SELECT_USER_SESSION = "select session_id from users where user_id = ?";
    private final ImcmsServices services;

    public ImcmsAuthenticatorAndUserAndRoleMapper(ImcmsServices services) {
        this.services = services;
    }

    public boolean authenticate(String loginName, String password) {
        boolean userExistsAndPasswordIsCorrect = false;
        UserDomainObject user = this.getUser(loginName);
        if (null != user) {
            String password_from_db = user.getPassword();
            userExistsAndPasswordIsCorrect = password_from_db.equals(password) && user.isActive();
        }
        return userExistsAndPasswordIsCorrect;
    }

    public UserDomainObject getUser(String loginName) {
        return this.getUserFromSqlRow(this.sqlSelectUserByName(loginName));
    }

    private String[] sqlSelectUserByName(String loginName) {
        Object[] parameters = new String[]{loginName.trim()};
        return (String[])this.services.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT user_id, login_name, login_password, first_name, last_name, title, company, address, city, zip, country, county_council, email, language, active, create_date, external, session_id FROM users WHERE login_name = ?", parameters, Utility.STRING_ARRAY_HANDLER));
    }

    private UserDomainObject getUserFromSqlRow(String[] sqlResult) {
        UserDomainObject user;
        if (sqlResult.length == 0) {
            user = null;
        } else {
            user = new UserDomainObject(Integer.parseInt(sqlResult[0]));
            this.initUserFromSqlData(user, sqlResult);
            this.initUserRoles(user);
            this.initUserPhoneNumbers(user);
            this.initUserUserAdminRoles(user);
        }
        return user;
    }

    void initUserFromSqlData(UserDomainObject user, String[] sqlResult) {
        user.setLoginName(sqlResult[1]);
        user.setPassword(sqlResult[2].trim());
        user.setFirstName(sqlResult[3]);
        user.setLastName(sqlResult[4]);
        user.setTitle(sqlResult[5]);
        user.setCompany(sqlResult[6]);
        user.setAddress(sqlResult[7]);
        user.setCity(sqlResult[8]);
        user.setZip(sqlResult[9]);
        user.setCountry(sqlResult[10]);
        user.setProvince(sqlResult[11]);
        user.setEmailAddress(sqlResult[12]);
        user.setLanguageIso639_2((String)ObjectUtils.defaultIfNull((Object)sqlResult[13], (Object)this.services.getLanguageMapper().getDefaultLanguage()));
        user.setActive(0 != Integer.parseInt(sqlResult[14]));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        user.setCreateDate(Utility.parseDateFormat(dateFormat, sqlResult[15]));
        user.setImcmsExternal(0 != Integer.parseInt(sqlResult[16]));
        user.setSessionId(sqlResult[17]);
    }

    private RoleId[] getRoleReferencesForUser(UserDomainObject user) {
        try {
            String sqlStr = "SELECT roles.role_id, roles.role_name, roles.admin_role, roles.permissions FROM roles, user_roles_crossref WHERE user_roles_crossref.role_id = roles.role_id AND user_roles_crossref.user_id = ?";
            Object[] parameters = new String[]{"" + user.getId()};
            String[][] sqlResult = (String[][])this.services.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
            RoleId[] roleReferences = new RoleId[sqlResult.length];
            for (int i = 0; i < sqlResult.length; ++i) {
                String[] sqlRow = sqlResult[i];
                roleReferences[i] = this.getRoleReferenceFromSqlResult(sqlRow);
            }
            return roleReferences;
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private RoleId getRoleReferenceFromSqlResult(String[] sqlRow) {
        return new RoleId(Integer.parseInt(sqlRow[0]));
    }

    public UserDomainObject getUser(int userId) {
        return this.getUserFromSqlRow(this.sqlSelectUserById(userId));
    }

    private String[][] sqlSelectAllUsers(boolean includeUserExtern, boolean includeInactiveUsers) {
        ArrayList<String> whereTests = new ArrayList<String>();
        if (!includeUserExtern) {
            whereTests.add("user_id != 2");
        }
        if (!includeInactiveUsers) {
            whereTests.add("active = 1");
        }
        String sqlStr = SQL_SELECT_USERS;
        if (whereTests.size() > 0) {
            sqlStr = sqlStr + " WHERE " + StringUtils.join(whereTests.iterator(), (String)" AND ");
        }
        try {
            Object[] parameters = new String[]{};
            return (String[][])this.services.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    String[] sqlSelectUserById(int userId) {
        try {
            Object[] parameters = new String[]{"" + userId};
            return (String[])this.services.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(SQL__SELECT_USER_BY_ID, parameters, Utility.STRING_ARRAY_HANDLER));
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public void saveUser(String loginName, UserDomainObject userToSave) {
        UserDomainObject imcmsUser = this.getUser(loginName);
        userToSave.setId(imcmsUser.getId());
        userToSave.setLoginName(loginName);
        this.saveUser(userToSave);
    }

    public void updateUserSessionId(UserDomainObject loggedInUser) {
        this.services.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand(SQL_UPDATE_USER_SESSION, new Object[]{loggedInUser.getSessionId(), loggedInUser.getId()}));
    }

    public String getUserSessionId(UserDomainObject loggedInUser) {
        return (String)this.services.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(SQL_SELECT_USER_SESSION, new Object[]{loggedInUser.getId()}, Utility.SINGLE_STRING_HANDLER));
    }

    public void saveUser(UserDomainObject user) {
        Object[] params = new String[]{user.getLoginName(), null == user.getPassword() ? "" : user.getPassword(), user.getFirstName(), user.getLastName(), user.getTitle(), user.getCompany(), user.getAddress(), user.getCity(), user.getZip(), user.getCountry(), user.getProvince(), user.getEmailAddress(), user.isImcmsExternal() ? "1" : "0", user.isActive() ? "1" : "0", user.getLanguageIso639_2(), "" + user.getId()};
        try {
            this.services.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand("UPDATE users \nSET login_name = ?,\nlogin_password = ?,\nfirst_name = ?,\nlast_name = ?,\ntitle = ?,\ncompany = ?,\naddress =  ?,\ncity = ?,\nzip = ?,\ncountry = ?,\ncounty_council = ?,\nemail = ?,\nexternal = ?,\nactive = ?,\nlanguage = ?\nWHERE user_id = ?", params));
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
        this.updateUserRoles(user);
        this.removePhoneNumbers(user);
        this.addPhoneNumbers(user);
    }

    private void updateUserRoles(UserDomainObject newUser) {
        HashSet<RoleId> newUserRoleIds = new HashSet<RoleId>(Arrays.asList(newUser.getRoleIds()));
        newUserRoleIds.add(RoleId.USERS);
        CompositeDatabaseCommand updateUserRolesCommand = new CompositeDatabaseCommand((DatabaseCommand)new DeleteWhereColumnsEqualDatabaseCommand("user_roles_crossref", "user_id", (Object)new Integer(newUser.getId())));
        for (RoleId roleId : newUserRoleIds) {
            updateUserRolesCommand.add((DatabaseCommand)new InsertIntoTableDatabaseCommand("user_roles_crossref", (Object[][])new String[][]{{"user_id", "" + newUser.getId()}, {"role_id", "" + roleId.intValue()}}));
        }
        this.services.getDatabase().execute((DatabaseCommand)updateUserRolesCommand);
        this.sqlUpdateUserUserAdminRoles(newUser);
    }

    private void sqlUpdateUserUserAdminRoles(UserDomainObject user) {
        RoleId[] userAdminRolesReferences;
        DeleteWhereColumnsEqualDatabaseCommand deleteAllUserAdminRolesForUserCommand = new DeleteWhereColumnsEqualDatabaseCommand(TABLE__USERADMIN_ROLE_CROSSREF, "user_id", (Object)("" + user.getId()));
        CompositeDatabaseCommand updateUserAdminRolesCommand = new CompositeDatabaseCommand((DatabaseCommand)deleteAllUserAdminRolesForUserCommand);
        for (RoleId userAdminRoleId : userAdminRolesReferences = user.getUserAdminRoleIds()) {
            updateUserAdminRolesCommand.add((DatabaseCommand)new InsertIntoTableDatabaseCommand(TABLE__USERADMIN_ROLE_CROSSREF, (Object[][])new String[][]{{"user_id", "" + user.getId()}, {"role_id", "" + userAdminRoleId.intValue()}}));
        }
        this.services.getDatabase().execute((DatabaseCommand)updateUserAdminRolesCommand);
    }

    public synchronized void addUser(UserDomainObject user) throws UserAlreadyExistsException {
        if (null != this.getUser(user.getLoginName())) {
            throw new UserAlreadyExistsException("A user with the name \"" + user.getLoginName() + "\" already exists.");
        }
        try {
            if (user.isImcmsExternal()) {
                user.setPassword("");
            }
            Number newUserId = (Number)this.services.getDatabase().execute((DatabaseCommand)new InsertIntoTableDatabaseCommand("users", (Object[][])new String[][]{{"login_name", user.getLoginName()}, {"login_password", user.getPassword()}, {"first_name", user.getFirstName()}, {"last_name", user.getLastName()}, {"title", user.getTitle()}, {"company", user.getCompany()}, {"address", user.getAddress()}, {"city", user.getCity()}, {"zip", user.getZip()}, {"country", user.getCountry()}, {"county_council", user.getProvince()}, {"email", user.getEmailAddress()}, {"external", user.isImcmsExternal() ? "1" : "0"}, {"active", user.isActive() ? "1" : "0"}, {"language", user.getLanguageIso639_2()}, {"create_date", Utility.makeSqlStringFromDate(new Date())}}));
            int newIntUserId = newUserId.intValue();
            user.setId(newIntUserId);
            this.updateUserRoles(user);
            this.addPhoneNumbers(user);
        }
        catch (IntegrityConstraintViolationException e) {
            throw new UserAlreadyExistsException(e);
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private void removePhoneNumbers(UserDomainObject newUser) {
        Object[] sprocParameters = new String[]{String.valueOf(newUser.getId())};
        try {
            this.services.getProcedureExecutor().executeUpdateProcedure(SPROC_DEL_PHONE_NR, sprocParameters);
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private void addPhoneNumbers(UserDomainObject newUser) {
        CompositeDatabaseCommand addPhoneNumbersCommand = new CompositeDatabaseCommand();
        Set phoneNumbers = newUser.getPhoneNumbers();
        for (PhoneNumber phoneNumber : phoneNumbers) {
            addPhoneNumbersCommand.add((DatabaseCommand)new InsertIntoTableDatabaseCommand("phones", (Object[][])new String[][]{{"user_id", "" + newUser.getId()}, {"number", phoneNumber.getNumber()}, {"phonetype_id", "" + phoneNumber.getType().getId()}}));
        }
        this.services.getDatabase().execute((DatabaseCommand)addPhoneNumbersCommand);
    }

    public String[] getRoleNames(UserDomainObject user) {
        try {
            Object[] parameters = new String[]{"" + user.getId()};
            return (String[])this.services.getProcedureExecutor().executeProcedure(SPROC_GET_USER_ROLES, parameters, new StringArrayResultSetHandler());
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public String[] getAllRoleNames() {
        try {
            Object[] parameters = new String[]{};
            String[] roleNamesMinusUsers = (String[])this.services.getProcedureExecutor().executeProcedure(SPROC_GET_ALL_ROLES, parameters, new StringArrayResultSetHandler());
            HashSet<String> roleNamesSet = new HashSet<String>();
            for (int i = 0; i < roleNamesMinusUsers.length; i += 2) {
                String roleName = roleNamesMinusUsers[i + 1];
                roleNamesSet.add(roleName);
            }
            roleNamesSet.add(this.getRole(RoleId.USERS).getName());
            Object[] roleNames = roleNamesSet.toArray(new String[roleNamesSet.size()]);
            Arrays.sort(roleNames);
            return roleNames;
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public void addRoleNames(String[] externalRoleNames) {
        for (int i = 0; i < externalRoleNames.length; ++i) {
            String externalRoleName = externalRoleNames[i];
            this.addRole(externalRoleName);
        }
    }

    public UserDomainObject[] getUsers(boolean includeUserExtern, boolean includeInactiveUsers) {
        String[][] allUsersSqlResult = this.sqlSelectAllUsers(includeUserExtern, includeInactiveUsers);
        return this.getUsersFromSqlRows(allUsersSqlResult);
    }

    public UserDomainObject[] getAllUsersWithRole(RoleDomainObject role) {
        try {
            if (null == role) {
                return new UserDomainObject[0];
            }
            Object[] parameters = new String[]{"" + role.getId()};
            String[] usersWithRole = (String[])this.services.getProcedureExecutor().executeProcedure(SPROC_GET_USERS_WHO_BELONGS_TO_ROLE, parameters, new StringArrayResultSetHandler());
            UserDomainObject[] result = new UserDomainObject[usersWithRole.length / 2];
            for (int i = 0; i < result.length; ++i) {
                String userIdStr = usersWithRole[i * 2];
                result[i] = this.getUser(Integer.parseInt(userIdStr));
            }
            return result;
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public synchronized RoleDomainObject addRole(String roleName) {
        RoleDomainObject role = this.getRoleByName(roleName);
        if (null == role) {
            role = new RoleDomainObject(roleName);
            try {
                this.addRole(role);
            }
            catch (UserAndRoleRegistryException e) {
                throw new UnhandledException((Throwable)e);
            }
        }
        return role;
    }

    void addRole(final RoleDomainObject role) throws RoleAlreadyExistsException, NameTooLongException {
        try {
            final int unionOfPermissionSetIds = this.getUnionOfRolePermissionIds(role);
            int newRoleId = ((Number)this.services.getDatabase().execute((DatabaseCommand)new TransactionDatabaseCommand(){

                public Object executeInTransaction(DatabaseConnection connection) throws DatabaseException {
                    return connection.executeUpdateAndGetGeneratedKey(ImcmsAuthenticatorAndUserAndRoleMapper.SQL_INSERT_INTO_ROLES, (Object[])new String[]{role.getName(), "" + unionOfPermissionSetIds});
                }
            })).intValue();
            role.setId(new RoleId(newRoleId));
        }
        catch (IntegrityConstraintViolationException icvse) {
            throw new RoleAlreadyExistsException("A role with the name \"" + role.getName() + "\" already exists.");
        }
        catch (StringTruncationException stse) {
            throw new NameTooLongException("Role name too long: " + role.getName());
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private int getUnionOfRolePermissionIds(RoleDomainObject role) {
        int unionOfPermissionSetIds = 0;
        RolePermissionDomainObject[] rolePermissions = role.getPermissions();
        for (int i = 0; i < rolePermissions.length; ++i) {
            RolePermissionDomainObject rolePermission = rolePermissions[i];
            unionOfPermissionSetIds |= rolePermission.getId();
        }
        return unionOfPermissionSetIds;
    }

    public void deleteRole(RoleDomainObject role) {
        if (null == role) {
            return;
        }
        try {
            CompositeDatabaseCommand databaseCommand = new CompositeDatabaseCommand(new DatabaseCommand[]{new DeleteWhereColumnsEqualDatabaseCommand("roles_rights", "role_id", (Object)("" + role.getId())), new DeleteWhereColumnsEqualDatabaseCommand("user_roles_crossref", "role_id", (Object)("" + role.getId())), new DeleteWhereColumnsEqualDatabaseCommand("roles", "role_id", (Object)("" + role.getId()))});
            this.services.getDatabase().execute((DatabaseCommand)databaseCommand);
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public RoleDomainObject[] getAllRoles() {
        return this.getRoles(SQL_SELECT_ALL_ROLES);
    }

    public RoleDomainObject[] getAllRolesExceptUsersRole() {
        return this.getRoles(SQL_SELECT_ALL_ROLES_EXCEPT_USERS_ROLE);
    }

    private RoleDomainObject[] getRoles(String rolesSql) {
        try {
            Object[] parameters = new String[]{};
            String[][] sqlRows = (String[][])this.services.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(rolesSql, parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
            RoleDomainObject[] roles = new RoleDomainObject[sqlRows.length];
            for (int i = 0; i < sqlRows.length; ++i) {
                roles[i] = this.getRoleFromSqlResult(sqlRows[i]);
            }
            return roles;
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public RoleDomainObject getRoleById(int roleId) {
        try {
            Object[] parameters = new String[]{"" + roleId};
            String[] sqlResult = (String[])this.services.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(SQL_SELECT_ROLE_BY_ID, parameters, Utility.STRING_ARRAY_HANDLER));
            return this.getRoleFromSqlResult(sqlResult);
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public RoleDomainObject getRoleByName(String wantedRoleName) {
        try {
            Object[] parameters = new String[]{wantedRoleName};
            String[] sqlResult = (String[])this.services.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(SQL_SELECT_ROLE_BY_NAME, parameters, Utility.STRING_ARRAY_HANDLER));
            return this.getRoleFromSqlResult(sqlResult);
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public RoleDomainObject getRoleFromSqlResult(String[] sqlResult) {
        RoleDomainObject role = null;
        if (sqlResult.length > 0) {
            int roleId = Integer.parseInt(sqlResult[0]);
            String roleName = sqlResult[1];
            int adminRoleId = Integer.parseInt(sqlResult[2]);
            int unionOfRolePermissionIds = Integer.parseInt(sqlResult[3]);
            role = new RoleDomainObject(new RoleId(roleId), roleName, adminRoleId);
            role.addUnionOfPermissionIdsToRole(unionOfRolePermissionIds);
        }
        return role;
    }

    public UserDomainObject[] getAllUsers() {
        return this.getUsers(true, true);
    }

    public UserDomainObject[] findUsersByNamePrefix(String namePrefix, boolean includeInactiveUsers) {
        try {
            String sql = "SELECT user_id, login_name, login_password, first_name, last_name, title, company, address, city, zip, country, county_council, email, language, active, create_date, external, session_id FROM users WHERE user_id != 2 AND ( login_name LIKE ? OR first_name LIKE ? OR last_name LIKE ? OR title LIKE ? OR email LIKE ? OR company LIKE ? )";
            if (!includeInactiveUsers) {
                sql = sql + " AND active = 1";
            }
            sql = sql + " ORDER BY last_name, first_name";
            String like = namePrefix + "%";
            Object[] parameters = new String[]{like, like, like, like, like, like};
            String[][] sqlRows = (String[][])this.services.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sql, parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
            return this.getUsersFromSqlRows(sqlRows);
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private UserDomainObject[] getUsersFromSqlRows(String[][] sqlRows) {
        UserDomainObject[] users = new UserDomainObject[sqlRows.length];
        for (int i = 0; i < sqlRows.length; ++i) {
            users[i] = this.getUserFromSqlRow(sqlRows[i]);
        }
        return users;
    }

    public void initUserPhoneNumbers(UserDomainObject user) {
        PhoneNumber[] phoneNbr = this.getUserPhoneNumbers(user.getId());
        for (int i = 0; i < phoneNbr.length; ++i) {
            PhoneNumberType type = phoneNbr[i].getType();
            String number = phoneNbr[i].getNumber();
            user.addPhoneNumber(new PhoneNumber(number, type));
        }
    }

    public void initUserRoles(UserDomainObject user) {
        user.setRoleIds(this.getRoleReferencesForUser(user));
    }

    public void initUserUserAdminRoles(UserDomainObject user) {
        user.setUserAdminRolesIds(this.getUserAdminRolesReferencesForUser(user));
    }

    public void saveRole(RoleDomainObject role) throws NameTooLongException, RoleAlreadyExistsException {
        if (0 == role.getId().intValue()) {
            this.addRole(role);
        } else {
            this.saveExistingRole(role);
        }
    }

    private void saveExistingRole(RoleDomainObject role) {
        int unionOfRolePermissionIds = this.getUnionOfRolePermissionIds(role);
        try {
            Object[] parameters = new String[]{role.getName(), "" + unionOfRolePermissionIds, "" + role.getId()};
            this.services.getDatabase().execute((DatabaseCommand)new SqlUpdateCommand("UPDATE roles SET role_name = ?, permissions = ? WHERE role_id = ?", parameters));
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public PhoneNumber[] getUserPhoneNumbers(int userToChangeId) {
        try {
            Object[] parameters = new String[]{"" + userToChangeId};
            String[][] phoneNumberData = (String[][])this.services.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT   phones.number, phones.phonetype_id\nFROM   phones\nWHERE  phones.user_id = ?", parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
            ArrayList<PhoneNumber> phoneNumbers = new ArrayList<PhoneNumber>();
            for (int i = 0; i < phoneNumberData.length; ++i) {
                String[] row = phoneNumberData[i];
                String phoneNumberString = row[0];
                int phoneTypeId = Integer.parseInt(row[1]);
                PhoneNumberType phoneNumberType = PhoneNumberType.getPhoneNumberTypeById(phoneTypeId);
                PhoneNumber phoneNumber = new PhoneNumber(phoneNumberString, phoneNumberType);
                phoneNumbers.add(phoneNumber);
            }
            return phoneNumbers.toArray(new PhoneNumber[phoneNumbers.size()]);
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private RoleId[] getUserAdminRolesReferencesForUser(UserDomainObject loggedOnUser) {
        try {
            Object[] parameters = new String[]{"" + loggedOnUser.getId()};
            String[] roleIds = (String[])this.services.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT role_id\nFROM useradmin_role_crossref\nWHERE user_id = ?", parameters, Utility.STRING_ARRAY_HANDLER));
            ArrayList<RoleId> useradminPermissibleRolesList = new ArrayList<RoleId>(roleIds.length);
            for (int i = 0; i < roleIds.length; ++i) {
                useradminPermissibleRolesList.add(new RoleId(Integer.parseInt(roleIds[i])));
            }
            return useradminPermissibleRolesList.toArray(new RoleId[useradminPermissibleRolesList.size()]);
        }
        catch (DatabaseException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public UserDomainObject getDefaultUser() {
        return this.getUser(2);
    }

    public RoleDomainObject getRole(RoleId roleId) {
        return this.getRoleById(roleId.intValue());
    }

    public UserDomainObject getUserByIpAddress(String ipAddress) {
        long ip;
        try {
            ip = Utility.ipStringToLong(ipAddress);
        }
        catch (IllegalArgumentException nfe) {
            log.debug((Object)("Failed to parse ip address " + ipAddress));
            return null;
        }
        String sqlStr = "select users.user_id from users,ip_accesses where users.user_id = ip_accesses.user_id and ip_accesses.ip_start <= ? and ip_accesses.ip_end >= ?";
        Object[] parameters = new String[]{"" + ip, "" + ip};
        String userIdString = (String)this.services.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.SINGLE_STRING_HANDLER));
        if (null != userIdString) {
            return this.getUser(Integer.parseInt(userIdString));
        }
        return null;
    }
}

