/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.parser;

import com.imcode.imcms.api.TextDocumentViewing;
import imcode.server.DocumentRequest;
import imcode.server.ImcmsServices;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.TemplateGroupDomainObject;
import imcode.server.document.TemplateMapper;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.parser.MapSubstitution;
import imcode.server.parser.ParserParameters;
import imcode.server.parser.TagParser;
import imcode.server.user.UserDomainObject;
import imcode.util.Html;
import imcode.util.ShouldNotBeThrownException;
import imcode.util.Utility;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class TextDocumentParser {
    private static final Logger LOG = Logger.getLogger(TextDocumentParser.class);
    static Pattern hashtagPattern;
    private static Pattern htmlTagPattern;
    private static Pattern htmlTagHtmlPattern;
    private ImcmsServices service;

    public TextDocumentParser(ImcmsServices service) {
        this.service = service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parsePage(ParserParameters paramsToParse, Writer out) throws IOException {
        NDC.push((String)"parsePage");
        try {
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            this.untimedParsePage(paramsToParse, out);
            stopWatch.stop();
            LOG.trace((Object)("Parsing template took " + stopWatch.getTime() + "ms."));
        }
        finally {
            NDC.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void untimedParsePage(ParserParameters parserParameters, Writer out) throws IOException {
        block10: {
            TextDocumentViewing viewing = new TextDocumentViewing(parserParameters);
            TextDocumentViewing previousViewing = TextDocumentViewing.putInRequest(viewing);
            ParserParameters previousParameters = ParserParameters.putInRequest(parserParameters);
            try {
                TemplateDomainObject template1;
                DocumentRequest documentRequest = parserParameters.getDocumentRequest();
                TextDocumentDomainObject document = (TextDocumentDomainObject)documentRequest.getDocument();
                UserDomainObject user = documentRequest.getUser();
                String templateName = document.getTemplateName();
                TemplateMapper templateMapper = this.service.getTemplateMapper();
                if (parserParameters.getTemplateName() != null && null != (template1 = templateMapper.getTemplateByName(parserParameters.getTemplateName()))) {
                    templateName = template1.getName();
                }
                TemplateDomainObject template = templateMapper.getTemplateByName(templateName);
                Perl5Matcher patMat = new Perl5Matcher();
                final String imcmsMessage = this.service.getAdminTemplate("textdoc/imcms_message.html", user, null);
                if (null == template) {
                    throw new RuntimeException("Template not found: " + templateName);
                }
                if (template.getFileName().endsWith(".jsp") || template.getFileName().endsWith(".jspx")) {
                    try {
                        HttpServletRequest request = documentRequest.getHttpServletRequest();
                        HttpServletResponse response = documentRequest.getHttpServletResponse();
                        String contents = Utility.getContents("/WEB-INF/templates/text/" + template.getFileName(), request, response);
                        contents = Util.substitute((PatternMatcher)patMat, (Pattern)htmlTagHtmlPattern, (Substitution)new Substitution(){

                            public void appendSubstitution(StringBuffer stringBuffer, MatchResult matchResult, int i, PatternMatcherInput patternMatcherInput, PatternMatcher patternMatcher, Pattern pattern) {
                                stringBuffer.append(imcmsMessage).append(matchResult.group(0));
                            }
                        }, (String)contents);
                        out.write(contents);
                        break block10;
                    }
                    catch (ServletException e) {
                        throw new UnhandledException((Throwable)e);
                    }
                }
                String templateContent = this.service.getTemplateMapper().getTemplateData(templateName);
                SimpleDateFormat datetimeFormatWithSeconds = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Properties hashTags = this.getHashTags(user, datetimeFormatWithSeconds, document, viewing.isEditingTemplate(), parserParameters);
                MapSubstitution hashtagsubstitution = new MapSubstitution(hashTags, true);
                TagParser tagParser = new TagParser(this, parserParameters);
                String tagsReplaced = tagParser.replaceTags(templateContent, false);
                tagsReplaced = Util.substitute((PatternMatcher)patMat, (Pattern)hashtagPattern, (Substitution)hashtagsubstitution, (String)tagsReplaced, (int)-1);
                String emphasizedAndTagsReplaced = this.applyEmphasis(documentRequest, user, tagsReplaced, patMat);
                out.write(Util.substitute((PatternMatcher)patMat, (Pattern)htmlTagHtmlPattern, (Substitution)new Substitution(){

                    public void appendSubstitution(StringBuffer stringBuffer, MatchResult matchResult, int i, PatternMatcherInput patternMatcherInput, PatternMatcher patternMatcher, Pattern pattern) {
                        stringBuffer.append(imcmsMessage).append(matchResult.group(0));
                    }
                }, (String)emphasizedAndTagsReplaced));
            }
            finally {
                if (null != previousViewing) {
                    TextDocumentViewing.putInRequest(previousViewing);
                }
                if (null != previousParameters) {
                    ParserParameters.putInRequest(previousParameters);
                }
            }
        }
    }

    private String applyEmphasis(DocumentRequest documentRequest, UserDomainObject user, String string, Perl5Matcher patMat) {
        String[] emp = documentRequest.getEmphasize();
        if (emp != null) {
            String non_html_tag_string;
            String emphasize_string = this.service.getAdminTemplate("textdoc/emphasize.html", user, null);
            Perl5Substitution emphasize_substitution = new Perl5Substitution(emphasize_string);
            StringBuffer result = new StringBuffer(string.length());
            PatternMatcherInput emp_input = new PatternMatcherInput(string);
            int last_html_offset = 0;
            while (patMat.contains(emp_input, htmlTagPattern)) {
                int current_html_offset = emp_input.getMatchBeginOffset();
                non_html_tag_string = result.substring(last_html_offset, current_html_offset);
                last_html_offset = emp_input.getMatchEndOffset();
                String html_tag_string = result.substring(current_html_offset, last_html_offset);
                non_html_tag_string = this.emphasizeString(non_html_tag_string, emp, (Substitution)emphasize_substitution, (PatternMatcher)patMat);
                result.append(non_html_tag_string);
                result.append(html_tag_string);
            }
            non_html_tag_string = result.substring(last_html_offset);
            non_html_tag_string = this.emphasizeString(non_html_tag_string, emp, (Substitution)emphasize_substitution, (PatternMatcher)patMat);
            result.append(non_html_tag_string);
            return result.toString();
        }
        return string;
    }

    private Properties getHashTags(UserDomainObject user, SimpleDateFormat datetimeFormatWithSeconds, TextDocumentDomainObject document, boolean templatemode, ParserParameters parserParameters) throws IOException {
        Properties tags = new Properties();
        tags.setProperty("#userName#", user.getFullName());
        tags.setProperty("#session_counter#", String.valueOf(this.service.getSessionCounter()));
        tags.setProperty("#session_counter_date#", this.service.getSessionCounterDateAsString());
        tags.setProperty("#lastDate#", datetimeFormatWithSeconds.format(document.getModifiedDatetime()));
        tags.setProperty("#metaHeadline#", document.getHeadline());
        tags.setProperty("#metaText#", document.getMenuText());
        String meta_image = document.getMenuImage();
        if (!"".equals(meta_image)) {
            meta_image = "<img src=\"" + meta_image + "\" border=\"0\">";
        }
        tags.setProperty("#metaImage#", meta_image);
        tags.setProperty("#sys_message#", this.service.getSystemData().getSystemMessage());
        tags.setProperty("#webMaster#", this.service.getSystemData().getWebMaster());
        tags.setProperty("#webMasterEmail#", this.service.getSystemData().getWebMasterAddress());
        tags.setProperty("#serverMaster#", this.service.getSystemData().getServerMaster());
        tags.setProperty("#serverMasterEmail#", this.service.getSystemData().getServerMasterAddress());
        tags.setProperty("#param#", parserParameters.getParameter());
        if (parserParameters.getFlags() >= 0 && parserParameters.isAdminButtonsVisible()) {
            tags.setProperty("#adminMode#", Html.getAdminButtons(user, document, parserParameters.getDocumentRequest().getHttpServletRequest(), parserParameters.getDocumentRequest().getHttpServletResponse()));
        }
        String changeTemplateUi = TextDocumentParser.createChangeTemplateUi(templatemode, user, document, this.service);
        tags.setProperty("#changePage#", changeTemplateUi);
        return tags;
    }

    public static String createChangeTemplateUi(boolean templatemode, UserDomainObject user, TextDocumentDomainObject document, ImcmsServices service) throws IOException {
        String changeTemplateUi = "";
        if (templatemode) {
            TemplateMapper templateMapper = service.getTemplateMapper();
            TemplateGroupDomainObject selectedTemplateGroup = user.getTemplateGroup();
            if (null == selectedTemplateGroup) {
                selectedTemplateGroup = templateMapper.getTemplateGroupById(document.getTemplateGroupId());
            }
            TextDocumentPermissionSetDomainObject textDocumentPermissionSet = (TextDocumentPermissionSetDomainObject)user.getPermissionSetFor(document);
            Set allowedTemplateGroupIds = textDocumentPermissionSet.getAllowedTemplateGroupIds();
            List allowedTemplateGroups = templateMapper.getTemplateGroups(allowedTemplateGroupIds);
            String templateGroupsHtmlOptionList = templateMapper.createHtmlOptionListOfTemplateGroups(allowedTemplateGroups, selectedTemplateGroup);
            ArrayList<TemplateDomainObject> templates = new ArrayList();
            if (allowedTemplateGroupIds.contains(new Integer(selectedTemplateGroup.getId()))) {
                templates = templateMapper.getTemplatesInGroup(selectedTemplateGroup);
            }
            String templateId = document.getTemplateName();
            TemplateDomainObject template = templateMapper.getTemplateByName(templateId);
            String templatesHtmlOptionList = templateMapper.createHtmlOptionListOfTemplates(templates, template);
            ArrayList<String> temptags = new ArrayList<String>();
            temptags.add("#getMetaId#");
            temptags.add("" + document.getId());
            temptags.add("#group#");
            temptags.add(selectedTemplateGroup.getName());
            temptags.add("#getTemplateGroups#");
            temptags.add(templateGroupsHtmlOptionList);
            temptags.add("#simple_name#");
            temptags.add(template.getName());
            temptags.add("#getTemplatesInGroup#");
            temptags.add(templatesHtmlOptionList);
            changeTemplateUi = service.getAdminTemplate("textdoc/inPage_admin.html", user, temptags);
        }
        return changeTemplateUi;
    }

    private String emphasizeString(String string, String[] emp, Substitution emphasize_substitution, PatternMatcher patMat) {
        String emphasizedString = string;
        Perl5Compiler empCompiler = new Perl5Compiler();
        for (String anEmp : emp) {
            try {
                Pattern empPattern = empCompiler.compile("(" + Perl5Compiler.quotemeta((String)anEmp) + ")", 1);
                emphasizedString = Util.substitute((PatternMatcher)patMat, (Pattern)empPattern, (Substitution)emphasize_substitution, (String)emphasizedString, (int)-1);
            }
            catch (MalformedPatternException ex) {
                throw new ShouldNotBeThrownException(ex);
            }
        }
        return emphasizedString;
    }

    static {
        Perl5Compiler patComp = new Perl5Compiler();
        try {
            htmlTagPattern = patComp.compile("<[^>]+?>", 32768);
            htmlTagHtmlPattern = patComp.compile("<[hH][tT][mM][lL]\\b", 32768);
            hashtagPattern = patComp.compile("#[^ #\"<>&;\\t\\r\\n]+#", 32768);
        }
        catch (MalformedPatternException ignored) {
            LOG.fatal((Object)"Bad pattern.", (Throwable)ignored);
        }
    }
}

