/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import com.imcode.imcms.api.Content;
import com.imcode.imcms.api.ContentLoop;
import com.imcode.imcms.api.I18nLanguage;
import com.imcode.imcms.api.I18nSupport;
import com.imcode.imcms.mapping.orm.TemplateNames;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentTypeDomainObject;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextDocumentDomainObject
extends DocumentDomainObject {
    private Map<I18nLanguage, Map<Integer, ImageDomainObject>> images = new HashMap<I18nLanguage, Map<Integer, ImageDomainObject>>();
    private Map<I18nLanguage, Map<Integer, TextDomainObject>> texts = new HashMap<I18nLanguage, Map<Integer, TextDomainObject>>();
    private Map<Integer, Integer> includesMap = new HashMap<Integer, Integer>();
    private Map<Integer, MenuDomainObject> menusMap = new HashMap<Integer, MenuDomainObject>();
    private TemplateNames templateNames = new TemplateNames();
    private Map<Integer, ContentLoop> contentLoopsMap = new HashMap<Integer, ContentLoop>();

    public TextDocumentDomainObject() {
        this(0);
    }

    public TextDocumentDomainObject(int documentId) {
        this.setId(documentId);
    }

    @Override
    public TextDocumentDomainObject clone() {
        TextDocumentDomainObject clone = (TextDocumentDomainObject)super.clone();
        clone.images = this.cloneImages();
        clone.includesMap = this.cloneIncludesMap();
        clone.menusMap = this.cloneMenusMap();
        clone.templateNames = this.cloneTemplateNames();
        clone.texts = this.cloneTexts();
        clone.contentLoopsMap = this.cloneContentLoopsMap();
        return clone;
    }

    @Override
    public DocumentTypeDomainObject getDocumentType() {
        return DocumentTypeDomainObject.TEXT;
    }

    public Set getChildDocumentIds() {
        HashSet<Integer> childDocuments = new HashSet<Integer>();
        for (MenuDomainObject menu : this.getMenus().values()) {
            MenuItemDomainObject[] menuItems = menu.getMenuItems();
            for (int i = 0; i < menuItems.length; ++i) {
                MenuItemDomainObject menuItem = menuItems[i];
                childDocuments.add(new Integer(menuItem.getDocumentId()));
            }
        }
        return childDocuments;
    }

    private Map<Integer, ImageDomainObject> getImagesMap() {
        I18nLanguage language = I18nSupport.getCurrentLanguage();
        return this.getImagesMap(language);
    }

    private Map<Integer, ImageDomainObject> getImagesMap(I18nLanguage language) {
        Map<Integer, ImageDomainObject> map = this.images.get(language);
        if (map == null) {
            map = new HashMap<Integer, ImageDomainObject>();
            this.images.put(language, map);
        }
        return map;
    }

    public Integer getIncludedDocumentId(int includeIndex) {
        return this.includesMap.get(includeIndex);
    }

    public MenuDomainObject getMenu(int menuIndex) {
        MenuDomainObject menu = this.menusMap.get(menuIndex);
        if (null == menu) {
            menu = new MenuDomainObject();
            this.setMenu(menuIndex, menu);
        }
        return menu;
    }

    public TextDomainObject getText(int textFieldIndex) {
        I18nLanguage language = I18nSupport.getCurrentLanguage();
        TextDomainObject text = this.getText(language, textFieldIndex);
        return text;
    }

    public TextDomainObject getText(I18nLanguage language, int index) {
        if (language == null) {
            throw new IllegalArgumentException("language argument can not be null.");
        }
        Map<Integer, TextDomainObject> map = this.getTextsMap(language);
        return map.get(index);
    }

    private Map<Integer, TextDomainObject> getTextsMap() {
        I18nLanguage language = I18nSupport.getCurrentLanguage();
        return this.getTextsMap(language);
    }

    public Map<Integer, TextDomainObject> getTextsMap(I18nLanguage language) {
        Map<Integer, TextDomainObject> map = this.texts.get(language);
        if (map == null) {
            map = new HashMap<Integer, TextDomainObject>();
            this.texts.put(language, map);
        }
        return map;
    }

    @Override
    public void accept(DocumentVisitor documentVisitor) {
        documentVisitor.visitTextDocument(this);
    }

    public synchronized void removeAllImages() {
        this.images = new HashMap<I18nLanguage, Map<Integer, ImageDomainObject>>();
    }

    public void removeAllIncludes() {
        this.includesMap = new HashMap<Integer, Integer>();
    }

    public void removeAllMenus() {
        this.menusMap = new HashMap<Integer, MenuDomainObject>();
    }

    public void removeAllContentLoops() {
        this.contentLoopsMap = new HashMap<Integer, ContentLoop>();
    }

    public void removeAllTexts() {
        this.texts = new HashMap<I18nLanguage, Map<Integer, TextDomainObject>>();
    }

    public void setInclude(int includeIndex, int includedDocumentId) {
        this.includesMap.put(includeIndex, includedDocumentId);
    }

    public void setMenu(int menuIndex, MenuDomainObject menu) {
        MenuDomainObject newMenu = menu.clone();
        MenuDomainObject oldMenu = this.menusMap.get(menuIndex);
        if (oldMenu != null) {
            newMenu.setId(oldMenu.getId());
        } else {
            newMenu.setId(null);
        }
        newMenu.setIndex(menuIndex);
        this.menusMap.put(menuIndex, menu);
    }

    public void setText(int textIndex, TextDomainObject text) {
        this.setText(I18nSupport.getCurrentLanguage(), textIndex, text);
    }

    public void setText(I18nLanguage language, int index, TextDomainObject text) {
        Map<Integer, TextDomainObject> map = this.getTextsMap(language);
        TextDomainObject oldText = map.get(index);
        TextDomainObject newText = text.clone();
        if (oldText != null) {
            newText.setId(oldText.getId());
            newText.setMetaVersion(oldText.getMetaVersion());
        } else {
            newText.setId(null);
        }
        newText.setMetaId(this.getMeta().getId());
        newText.setIndex(index);
        newText.setLanguage(language);
        newText.setModified(true);
        map.put(index, newText);
    }

    public Map<Integer, Integer> getIncludesMap() {
        return Collections.unmodifiableMap(this.includesMap);
    }

    public Map<Integer, MenuDomainObject> getMenus() {
        return Collections.unmodifiableMap(this.menusMap);
    }

    public String getTemplateName() {
        return this.templateNames.getTemplateName();
    }

    public int getTemplateGroupId() {
        return this.templateNames.getTemplateGroupId();
    }

    public Map<Integer, TextDomainObject> getTexts() {
        return Collections.unmodifiableMap(this.getTextsMap());
    }

    public Map<Integer, TextDomainObject> getTexts(I18nLanguage language) {
        return Collections.unmodifiableMap(this.getTextsMap(language));
    }

    public void setTemplateName(String templateName) {
        this.templateNames.setTemplateName(templateName);
    }

    public void setTemplateGroupId(int v) {
        this.templateNames.setTemplateGroupId(v);
    }

    public String getDefaultTemplateName() {
        return this.templateNames.getDefaultTemplateName();
    }

    public void setDefaultTemplateId(String defaultTemplateId) {
        this.templateNames.setDefaultTemplateName(defaultTemplateId);
    }

    public void removeInclude(int includeIndex) {
        this.includesMap.remove(includeIndex);
    }

    public String getDefaultTemplateNameForRestricted1() {
        return this.templateNames.getDefaultTemplateNameForRestricted1();
    }

    public String getDefaultTemplateNameForRestricted2() {
        return this.templateNames.getDefaultTemplateNameForRestricted2();
    }

    public void setDefaultTemplateIdForRestricted1(String defaultTemplateIdForRestricted1) {
        this.templateNames.setDefaultTemplateNameForRestricted1(defaultTemplateIdForRestricted1);
    }

    public void setDefaultTemplateIdForRestricted2(String defaultTemplateIdForRestricted2) {
        this.templateNames.setDefaultTemplateNameForRestricted2(defaultTemplateIdForRestricted2);
    }

    public Map<Integer, ImageDomainObject> getImages() {
        return Collections.unmodifiableMap(this.getImagesMap());
    }

    public Map<Integer, ImageDomainObject> getImages(I18nLanguage language) {
        return Collections.unmodifiableMap(this.getImagesMap(language));
    }

    public void setImage(int imageIndex, ImageDomainObject image) {
        this.setImage(I18nSupport.getCurrentLanguage(), imageIndex, image);
    }

    public void setImage(I18nLanguage language, int index, ImageDomainObject image) {
        Map<Integer, ImageDomainObject> map = this.getImagesMap(language);
        ImageDomainObject oldImage = map.get(index);
        ImageDomainObject newImage = image.clone();
        if (oldImage != null) {
            newImage.setId(oldImage.getId());
            newImage.setMetaVersion(oldImage.getMetaVersion());
        } else {
            newImage.setId(null);
        }
        newImage.setMetaId(this.getMeta().getId());
        newImage.setLanguage(language);
        newImage.setIndex(index);
        newImage.setModified(true);
        map.put(index, newImage);
    }

    public ImageDomainObject getImage(int imageIndex) {
        I18nLanguage language = I18nSupport.getCurrentLanguage();
        ImageDomainObject image = this.getImage(language, imageIndex);
        return image;
    }

    public ImageDomainObject getImage(I18nLanguage language, int index) {
        if (language == null) {
            throw new IllegalArgumentException("language argument can not be null.");
        }
        Map<Integer, ImageDomainObject> map = this.getImagesMap(language);
        return map.get(index);
    }

    @Override
    public void setDependenciesMetaIdToNull() {
        super.setDependenciesMetaIdToNull();
        for (Map<Integer, TextDomainObject> map : this.texts.values()) {
            for (TextDomainObject textDomainObject : map.values()) {
                textDomainObject.setId(null);
                textDomainObject.setMetaId(null);
                textDomainObject.setModified(true);
            }
        }
        for (Map<Integer, Cloneable> map : this.images.values()) {
            for (ImageDomainObject imageDomainObject : map.values()) {
                imageDomainObject.setId(null);
                imageDomainObject.setMetaId(null);
                imageDomainObject.setModified(true);
            }
        }
        for (MenuDomainObject menuDomainObject : this.menusMap.values()) {
            menuDomainObject.setId(null);
            menuDomainObject.setMetaId(null);
        }
        for (ContentLoop contentLoop : this.contentLoopsMap.values()) {
            contentLoop.setId(null);
            contentLoop.setMetaId(null);
            contentLoop.setModified(true);
            for (Content content : contentLoop.getContents()) {
                content.setId(null);
            }
        }
        this.templateNames.setId(null);
        this.templateNames.setMetaId(null);
    }

    private Map<Integer, MenuDomainObject> cloneMenusMap() {
        HashMap<Integer, MenuDomainObject> menusClone = new HashMap<Integer, MenuDomainObject>();
        for (Map.Entry<Integer, MenuDomainObject> entry : this.menusMap.entrySet()) {
            MenuDomainObject menu = entry.getValue();
            MenuDomainObject menuClone = menu.clone();
            menusClone.put(entry.getKey(), menuClone);
        }
        return menusClone;
    }

    private Map<I18nLanguage, Map<Integer, ImageDomainObject>> cloneImages() {
        HashMap<I18nLanguage, Map<Integer, ImageDomainObject>> imagesClone = new HashMap<I18nLanguage, Map<Integer, ImageDomainObject>>();
        for (Map.Entry<I18nLanguage, Map<Integer, ImageDomainObject>> languageEntry : this.images.entrySet()) {
            Map<Integer, ImageDomainObject> imagesMap = languageEntry.getValue();
            HashMap<Integer, ImageDomainObject> imagesMapClone = new HashMap<Integer, ImageDomainObject>();
            imagesClone.put(languageEntry.getKey(), imagesMapClone);
            for (Map.Entry<Integer, ImageDomainObject> imagesEntry : imagesMap.entrySet()) {
                ImageDomainObject image = imagesEntry.getValue().clone();
                imagesMapClone.put(imagesEntry.getKey(), image);
            }
        }
        return imagesClone;
    }

    private Map<I18nLanguage, Map<Integer, TextDomainObject>> cloneTexts() {
        HashMap<I18nLanguage, Map<Integer, TextDomainObject>> textsClone = new HashMap<I18nLanguage, Map<Integer, TextDomainObject>>();
        for (Map.Entry<I18nLanguage, Map<Integer, TextDomainObject>> languageEntry : this.texts.entrySet()) {
            Map<Integer, TextDomainObject> textsMap = languageEntry.getValue();
            HashMap<Integer, TextDomainObject> textsMapClone = new HashMap<Integer, TextDomainObject>();
            textsClone.put(languageEntry.getKey(), textsMapClone);
            for (Map.Entry<Integer, TextDomainObject> textsEntry : textsMap.entrySet()) {
                TextDomainObject text = textsEntry.getValue().clone();
                textsMapClone.put(textsEntry.getKey(), text);
            }
        }
        return textsClone;
    }

    private TemplateNames cloneTemplateNames() {
        TemplateNames templateNamesClone = this.templateNames.clone();
        return templateNamesClone;
    }

    private Map<Integer, Integer> cloneIncludesMap() {
        HashMap<Integer, Integer> includesMapClone = new HashMap<Integer, Integer>(this.includesMap);
        return includesMapClone;
    }

    private Map<Integer, ContentLoop> cloneContentLoopsMap() {
        HashMap<Integer, ContentLoop> contentLoopsMapClone = new HashMap<Integer, ContentLoop>();
        for (Map.Entry<Integer, ContentLoop> entry : this.contentLoopsMap.entrySet()) {
            contentLoopsMapClone.put(entry.getKey(), entry.getValue().clone());
        }
        return contentLoopsMapClone;
    }

    public TemplateNames getTemplateNames() {
        return this.templateNames;
    }

    public void setTemplateNames(TemplateNames templateNames) {
        this.templateNames = templateNames;
    }

    public void setMenusMap(Map<Integer, MenuDomainObject> menusMap) {
        this.menusMap = menusMap;
    }

    public void setIncludesMap(Map<Integer, Integer> includesMap) {
        this.includesMap = includesMap;
    }

    public Map<I18nLanguage, Map<Integer, TextDomainObject>> getAllTexts() {
        return this.texts;
    }

    public void setAllTexts(Map<I18nLanguage, Map<Integer, TextDomainObject>> texts) {
        this.texts = texts;
    }

    public Map<I18nLanguage, Map<Integer, ImageDomainObject>> getAllImages() {
        return this.images;
    }

    public void setAllImages(Map<I18nLanguage, Map<Integer, ImageDomainObject>> images) {
        this.images = images;
    }

    public Map<Integer, ContentLoop> getContentLoopsMap() {
        return this.contentLoopsMap;
    }

    public void setContentLoopsMap(Map<Integer, ContentLoop> contentLoopsMap) {
        this.contentLoopsMap = contentLoopsMap;
    }

    public ContentLoop getContentLoop(int index) {
        return this.contentLoopsMap.get(index);
    }

    public ContentLoop setContentLoop(int index, ContentLoop contentLoop) {
        Long loopId;
        Integer metaId;
        ContentLoop oldContentLoop = this.getContentLoop(index);
        ContentLoop newContentLoop = contentLoop.clone();
        if (oldContentLoop != null) {
            metaId = this.getMeta().getId();
            loopId = oldContentLoop.getId();
        } else {
            metaId = null;
            loopId = null;
        }
        newContentLoop.setModified(true);
        newContentLoop.setMetaId(metaId);
        newContentLoop.setId(loopId);
        newContentLoop.setIndex(index);
        for (Content content : newContentLoop.getContents()) {
            content.setLoopId(loopId);
            content.setId(null);
        }
        this.contentLoopsMap.put(index, newContentLoop);
        return newContentLoop;
    }
}

