/*
 * Decompiled with CFR 0.152.
 */
package imcode.server;

import imcode.server.document.LifeCyclePhase;
import imcode.server.document.index.DocumentIndex;
import imcode.server.document.index.DocumentIndexWrapper;
import imcode.server.document.index.DocumentQuery;
import imcode.server.document.index.IndexException;
import imcode.server.document.index.SimpleDocumentQuery;
import imcode.server.user.UserDomainObject;
import java.util.Date;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class PhaseQueryFixingDocumentIndex
extends DocumentIndexWrapper {
    public PhaseQueryFixingDocumentIndex(DocumentIndex index) {
        super(index);
    }

    public List search(DocumentQuery query, UserDomainObject searchingUser) throws IndexException {
        return super.search(this.fixQuery(query), searchingUser);
    }

    DocumentQuery fixQuery(DocumentQuery documentQuery) {
        Query query = documentQuery.getQuery();
        return new SimpleDocumentQuery(this.fixQuery(query), documentQuery.getSort(), documentQuery.isLogged());
    }

    Query fixQuery(Query query) {
        block3: {
            TermQuery termQuery;
            Term term;
            block2: {
                BooleanClause[] clauses;
                if (!(query instanceof BooleanQuery)) break block2;
                BooleanQuery booleanQuery = (BooleanQuery)query;
                for (BooleanClause clause : clauses = booleanQuery.getClauses()) {
                    clause.query = this.fixQuery(clause.query);
                }
                break block3;
            }
            if (!(query instanceof TermQuery) || !"phase".equals((term = (termQuery = (TermQuery)query).getTerm()).field())) break block3;
            LifeCyclePhase[] allPhases = LifeCyclePhase.ALL;
            Date now = new Date();
            for (LifeCyclePhase phase : allPhases) {
                if (!phase.toString().equals(term.text())) continue;
                return phase.asQuery(now);
            }
        }
        return query;
    }
}

