/*
 * Decompiled with CFR 0.152.
 */
package imcode.server;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.InsertIntoTableDatabaseCommand;
import imcode.server.document.index.DocumentIndex;
import imcode.server.document.index.DocumentIndexWrapper;
import imcode.server.document.index.DocumentQuery;
import imcode.server.document.index.IndexException;
import imcode.server.user.UserDomainObject;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingDocumentIndex
extends DocumentIndexWrapper {
    private final Database database;
    private static final Set LOGGED_FIELDS = new HashSet<String>(Arrays.asList("meta_headline", "meta_text", "text", "alias", "keyword"));

    public LoggingDocumentIndex(Database database, DocumentIndex documentIndex) {
        super(documentIndex);
        this.database = database;
    }

    @Override
    public List search(DocumentQuery documentQuery, UserDomainObject searchingUser) throws IndexException {
        Query query = documentQuery.getQuery();
        this.logTerms(this.getTerms(query));
        return super.search(documentQuery, searchingUser);
    }

    private Collection<String> getTerms(Query query) {
        HashSet<String> terms = new HashSet<String>();
        this.getTerms(query, terms);
        return terms;
    }

    private void logTerms(Collection<String> terms) {
        Timestamp timestamp = new Timestamp(new Date().getTime());
        for (String term : terms) {
            this.database.execute((DatabaseCommand)new InsertIntoTableDatabaseCommand("document_search_log", (Object[][])new Object[][]{{"datetime", timestamp}, {"term", term}}));
        }
    }

    private void getTerms(Query query, Collection<String> terms) {
        if (query instanceof BooleanQuery) {
            BooleanClause[] clauses;
            BooleanQuery booleanQuery = (BooleanQuery)query;
            for (BooleanClause clause : clauses = booleanQuery.getClauses()) {
                if (clause.prohibited) continue;
                this.getTerms(clause.query, terms);
            }
        } else if (query instanceof TermQuery) {
            TermQuery termQuery = (TermQuery)query;
            this.addTerm(terms, termQuery.getTerm());
        } else if (query instanceof MultiTermQuery) {
            MultiTermQuery multiTermQuery = (MultiTermQuery)query;
            this.addTerm(terms, multiTermQuery.getTerm());
        } else if (query instanceof PrefixQuery) {
            PrefixQuery prefixQuery = (PrefixQuery)query;
            this.addTerm(terms, prefixQuery.getPrefix());
        }
    }

    private void addTerm(Collection<String> terms, Term term) {
        if (LOGGED_FIELDS.contains(term.field())) {
            terms.add(term.text());
        }
    }
}

