/*
 * Decompiled with CFR 0.152.
 */
package imcode.server;

import com.imcode.db.DataSourceDatabase;
import com.imcode.db.Database;
import com.imcode.imcms.db.DefaultProcedureExecutor;
import com.imcode.imcms.util.l10n.CachingLocalizedMessageProvider;
import com.imcode.imcms.util.l10n.ImcmsPrefsLocalizedMessageProvider;
import imcode.server.DefaultImcmsServices;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.CachingFileLoader;
import imcode.util.Prefs;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;
import org.springframework.web.context.WebApplicationContext;

public class Imcms {
    private static final String SERVER_PROPERTIES_FILENAME = "server.properties";
    public static final String ASCII_ENCODING = "US-ASCII";
    public static final String ISO_8859_1_ENCODING = "ISO-8859-1";
    public static final String UTF_8_ENCODING = "UTF-8";
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final Logger LOG = Logger.getLogger((String)Imcms.class.getName());
    private static ImcmsServices services;
    private static BasicDataSource apiDataSource;
    private static BasicDataSource dataSource;
    private static File path;
    public static WebApplicationContext webApplicationContext;
    private static final ThreadLocal<UserDomainObject> users;

    private Imcms() {
    }

    public static synchronized ImcmsServices getServices() {
        if (null == services) {
            Imcms.start();
        }
        return services;
    }

    public static void setPath(File path) {
        Imcms.path = path;
    }

    public static File getPath() {
        return path;
    }

    public static synchronized void start() throws StartupException {
        try {
            services = Imcms.createServices();
        }
        catch (Exception e) {
            throw new StartupException("imCMS could not be started. Please see the log file in WEB-INF/logs/ for details.", e);
        }
    }

    private static synchronized ImcmsServices createServices() throws Exception {
        if (webApplicationContext == null) {
            throw new NullPointerException("Spring WebApplicationContext is not set.");
        }
        Properties serverprops = Imcms.getServerProperties();
        LOG.debug((Object)"Creating main DataSource.");
        Database database = Imcms.createDatabase(serverprops);
        CachingLocalizedMessageProvider localizedMessageProvider = new CachingLocalizedMessageProvider(new ImcmsPrefsLocalizedMessageProvider());
        CachingFileLoader fileLoader = new CachingFileLoader();
        return new DefaultImcmsServices(webApplicationContext, database, serverprops, localizedMessageProvider, fileLoader, new DefaultProcedureExecutor(database, fileLoader));
    }

    private static Database createDatabase(Properties serverprops) {
        dataSource = Imcms.createDataSource(serverprops);
        return new DataSourceDatabase((DataSource)dataSource);
    }

    public static synchronized DataSource getApiDataSource() {
        if (null == apiDataSource) {
            Properties serverprops = Imcms.getServerProperties();
            LOG.debug((Object)"Creating API DataSource.");
            apiDataSource = Imcms.createDataSource(serverprops);
        }
        return apiDataSource;
    }

    public static Properties getServerProperties() {
        try {
            return Prefs.getProperties(SERVER_PROPERTIES_FILENAME);
        }
        catch (IOException e) {
            LOG.fatal((Object)"Failed to initialize imCMS", (Throwable)e);
            throw new UnhandledException((Throwable)e);
        }
    }

    private static BasicDataSource createDataSource(Properties props) {
        String jdbcDriver = props.getProperty("JdbcDriver");
        String jdbcUrl = props.getProperty("JdbcUrl");
        String user = props.getProperty("User");
        String password = props.getProperty("Password");
        int maxConnectionCount = Integer.parseInt(props.getProperty("MaxConnectionCount"));
        LOG.debug((Object)("JdbcDriver = " + jdbcDriver));
        LOG.debug((Object)("JdbcUrl = " + jdbcUrl));
        LOG.debug((Object)("User = " + user));
        LOG.debug((Object)("MaxConnectionCount = " + maxConnectionCount));
        return Imcms.createDataSource(jdbcDriver, jdbcUrl, user, password, maxConnectionCount);
    }

    public static synchronized void restart() {
        Imcms.stop();
        Imcms.start();
    }

    public static void stop() {
        if (null != apiDataSource) {
            try {
                LOG.debug((Object)"Closing API DataSource.");
                apiDataSource.close();
            }
            catch (SQLException e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        if (null != dataSource) {
            try {
                LOG.debug((Object)"Closing main DataSource.");
                dataSource.close();
            }
            catch (SQLException e) {
                LOG.error((Object)e, (Throwable)e);
            }
        }
        Prefs.flush();
    }

    private static void logDatabaseVersion(BasicDataSource basicDataSource) throws SQLException {
        Connection connection = basicDataSource.getConnection();
        DatabaseMetaData metaData = connection.getMetaData();
        LOG.info((Object)("Database product version = " + metaData.getDatabaseProductVersion()));
        connection.close();
    }

    public static BasicDataSource createDataSource(String jdbcDriver, String jdbcUrl, String user, String password, int maxConnectionCount) {
        try {
            BasicDataSource basicDataSource = new BasicDataSource();
            basicDataSource.setDriverClassName(jdbcDriver);
            basicDataSource.setUsername(user);
            basicDataSource.setPassword(password);
            basicDataSource.setUrl(jdbcUrl);
            basicDataSource.setMaxActive(maxConnectionCount);
            basicDataSource.setMaxIdle(maxConnectionCount);
            basicDataSource.setDefaultAutoCommit(true);
            basicDataSource.setPoolPreparedStatements(true);
            basicDataSource.setTestOnBorrow(true);
            basicDataSource.setValidationQuery("select 1");
            Imcms.logDatabaseVersion(basicDataSource);
            return basicDataSource;
        }
        catch (SQLException ex) {
            String message = "Could not connect to database " + jdbcUrl + " with driver " + jdbcDriver + ": " + ex.getMessage() + " Error code: " + ex.getErrorCode() + " SQL GroupData: " + ex.getSQLState();
            LOG.fatal((Object)message, (Throwable)ex);
            throw new RuntimeException(message, ex);
        }
    }

    public static void setUser(UserDomainObject user) {
        users.set(user);
    }

    public static UserDomainObject getUser() {
        return users.get();
    }

    static {
        users = new ThreadLocal();
    }

    public static class StartupException
    extends RuntimeException {
        public StartupException(String message, Exception e) {
            super(message, e);
        }
    }
}

