/*
 * Decompiled with CFR 0.152.
 */
package imcode.server;

import imcode.server.LanguageMapper;
import java.io.File;
import java.nio.charset.Charset;
import java.security.KeyStore;
import org.apache.commons.lang.StringUtils;

public class Config {
    private File templatePath;
    private File includePath;
    private File filePath;
    private File imagePath;
    private String imageUrl;
    private String smtpServer;
    private int smtpPort;
    private String defaultLanguage;
    private String sessionCookieDomain;
    private String fileAdminRootPaths;
    private float indexingSchedulePeriodInMinutes;
    private String documentPathPrefix;
    private int documentCacheMaxSize = 100;
    private String keyStorePath;
    private String keyStoreType;
    private String workaroundUriEncoding;
    private boolean secureLoginRequired;
    private boolean denyMultipleUserLogin;

    public String getWorkaroundUriEncoding() {
        return this.workaroundUriEncoding;
    }

    public void setWorkaroundUriEncoding(String workaroundUriEncoding) {
        Charset charset = StringUtils.isNotBlank((String)workaroundUriEncoding) ? Charset.forName(workaroundUriEncoding) : Charset.defaultCharset();
        this.workaroundUriEncoding = charset.name();
    }

    public void setTemplatePath(File templatePath) {
        this.templatePath = templatePath;
    }

    public void setIncludePath(File includePath) {
        this.includePath = includePath;
    }

    public void setFilePath(File filePath) {
        this.filePath = filePath;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        try {
            if (defaultLanguage.length() < 3) {
                defaultLanguage = LanguageMapper.convert639_1to639_2(defaultLanguage);
            }
        }
        catch (LanguageMapper.LanguageNotSupportedException e1) {
            defaultLanguage = null;
        }
        this.defaultLanguage = defaultLanguage;
    }

    public File getFilePath() {
        return this.filePath;
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public File getTemplatePath() {
        return this.templatePath;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public File getIncludePath() {
        return this.includePath;
    }

    public String getSessionCookieDomain() {
        return this.sessionCookieDomain;
    }

    public void setSessionCookieDomain(String sessionCookieDomain) {
        this.sessionCookieDomain = sessionCookieDomain;
    }

    public File getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(File imagePath) {
        this.imagePath = imagePath;
    }

    public String getFileAdminRootPaths() {
        return this.fileAdminRootPaths;
    }

    public void setFileAdminRootPaths(String fileAdminRootPaths) {
        this.fileAdminRootPaths = fileAdminRootPaths;
    }

    public float getIndexingSchedulePeriodInMinutes() {
        return this.indexingSchedulePeriodInMinutes;
    }

    public void setIndexingSchedulePeriodInMinutes(float indexingSchedulePeriodInMinutes) {
        this.indexingSchedulePeriodInMinutes = indexingSchedulePeriodInMinutes;
    }

    public String getDocumentPathPrefix() {
        return this.documentPathPrefix;
    }

    public void setDocumentPathPrefix(String documentPathPrefix) {
        this.documentPathPrefix = documentPathPrefix;
    }

    public int getDocumentCacheMaxSize() {
        return this.documentCacheMaxSize;
    }

    public void setDocumentCacheMaxSize(int documentCacheMaxSize) {
        this.documentCacheMaxSize = documentCacheMaxSize;
    }

    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        if (StringUtils.isBlank((String)keyStoreType)) {
            keyStoreType = KeyStore.getDefaultType();
        }
        this.keyStoreType = keyStoreType;
    }

    public boolean getSecureLoginRequired() {
        return this.secureLoginRequired;
    }

    public void setSecureLoginRequired(boolean secureLoginRequired) {
        this.secureLoginRequired = secureLoginRequired;
    }

    public boolean isDenyMultipleUserLogin() {
        return this.denyMultipleUserLogin;
    }

    public void setDenyMultipleUserLogin(boolean denyMultipleUserLogin) {
        this.denyMultipleUserLogin = denyMultipleUserLogin;
    }
}

