/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.flow.Page;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.DocumentSaveException;
import com.imcode.imcms.servlet.admin.MenuEditPage;
import com.imcode.imcms.util.l10n.LocalizedMessage;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DirectDocumentReference;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.index.DefaultQueryParser;
import imcode.server.document.index.DocumentIndex;
import imcode.server.document.index.SimpleDocumentQuery;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Html;
import imcode.util.Parser;
import imcode.util.Utility;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;
import org.apache.lucene.document.DateField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetExistingDoc
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger((String)GetExistingDoc.class.getName());
    private static final String ONE_SEARCH_HIT = "existing_doc_hit.html";
    private static final String SEARCH_RESULTS = "existing_doc_res.html";
    private static final String ADMIN_TEMPLATE_EXISTING_DOC = "existing_doc.html";
    private static final String SORT_BY_LANGUAGE_KEY_PREFIX = "templates/sv/existing_doc.html/sort_by/";
    private static final Object[][] SORT_ORDERS_ARRAY = new Object[][]{{"meta_headline", new LocalizedMessage("templates/sv/existing_doc.html/sort_by/headline")}, {"meta_id", new LocalizedMessage("templates/sv/existing_doc.html/sort_by/id")}, {"doc_type", new LocalizedMessage("templates/sv/existing_doc.html/sort_by/type")}, {"date_modified", new LocalizedMessage("templates/sv/existing_doc.html/sort_by/modified_datetime")}, {"date_created", new LocalizedMessage("templates/sv/existing_doc.html/sort_by/created_datetime")}, {"archived_datetime", new LocalizedMessage("templates/sv/existing_doc.html/sort_by/archived_datetime")}, {"publication_start_datetime", new LocalizedMessage("templates/sv/existing_doc.html/sort_by/published_datetime")}};
    static final Map SORT_ORDERS_MAP = Utility.getMapViewOfObjectPairArray(SORT_ORDERS_ARRAY);

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        TextDocumentDomainObject parentDocument = (TextDocumentDomainObject)documentMapper.getPublishedDocument(Integer.parseInt(req.getParameter("meta_id_value")));
        int menuIndex = Integer.parseInt(req.getParameter("doc_menu_no"));
        UserDomainObject user = Utility.getLoggedOnUser(req);
        MenuEditPage menuEditPage = (MenuEditPage)Page.fromRequest(req);
        if (req.getParameter("cancel") != null || req.getParameter("cancel.x") != null) {
            menuEditPage.forward(req, res);
        } else if (req.getParameter("search") != null || req.getParameter("search.x") != null) {
            DocumentIndex index = documentMapper.getDocumentIndex();
            BooleanQuery query = new BooleanQuery();
            String searchString = req.getParameter("searchstring");
            String searchPrep = req.getParameter("search_prep");
            try {
                if ("or".equalsIgnoreCase(searchPrep)) {
                    this.addStringToQuery(searchString, query);
                } else {
                    String[] searchStrings;
                    for (String string : searchStrings = searchString.split("\\s+")) {
                        this.addStringToQuery(string, query);
                    }
                }
            }
            catch (ParseException pe) {
                LOG.debug((Object)("Bad query: " + searchString), (Throwable)pe);
            }
            String[] docTypes = req.getParameterValues("doc_type");
            this.addDocTypesToQuery(docTypes, query);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date startDate = null;
            try {
                String startDateString = req.getParameter("start_date");
                startDate = dateFormat.parse(startDateString);
            }
            catch (java.text.ParseException ignored) {
                // empty catch block
            }
            Date endDate = null;
            try {
                String endDateString = req.getParameter("end_date");
                endDate = dateFormat.parse(endDateString);
            }
            catch (java.text.ParseException ignored) {
                // empty catch block
            }
            this.addDateRangesToQuery(startDate, endDate, req, query);
            String sortBy = req.getParameter("sortBy");
            String langPrefix = user.getLanguageIso639_2();
            Set sortOrderSet = SORT_ORDERS_MAP.keySet();
            if (!sortOrderSet.contains(sortBy)) {
                sortBy = "meta_id";
            }
            ArrayList<Object> sortOrderV = new ArrayList<Object>();
            for (int i = 0; i < SORT_ORDERS_ARRAY.length; ++i) {
                sortOrderV.add(SORT_ORDERS_ARRAY[i][0]);
                sortOrderV.add(((LocalizedMessage)SORT_ORDERS_ARRAY[i][1]).toLocalizedString(user));
            }
            LOG.debug((Object)("Query: " + query));
            List searchResultDocuments = index.search(new SimpleDocumentQuery((Query)query), user);
            if (0 == searchResultDocuments.size()) {
                int documentId;
                DocumentDomainObject document;
                if (StringUtils.isNumeric((String)searchString) && this.canAddToMenu(user, parentDocument, document = documentMapper.getPublishedDocument(documentId = Integer.parseInt(searchString)))) {
                    this.addDocumentToMenu(document, parentDocument, user, menuEditPage);
                    this.redirectBackToMenu(req, res, menuEditPage);
                    return;
                }
            } else if (1 == searchResultDocuments.size()) {
                DocumentDomainObject onlyDocumentFound = (DocumentDomainObject)searchResultDocuments.get(0);
                if (searchString.equals("" + onlyDocumentFound.getId()) && this.canAddToMenu(user, parentDocument, onlyDocumentFound)) {
                    this.addDocumentToMenu(onlyDocumentFound, parentDocument, user, menuEditPage);
                    this.redirectBackToMenu(req, res, menuEditPage);
                    return;
                }
            }
            this.createSearchResultsPage(imcref, user, langPrefix, searchResultDocuments, parentDocument, menuIndex, req, startDate, dateFormat, endDate, docTypes, sortBy, sortOrderV, out, menuEditPage);
        } else {
            this.addDocumentsFromRequestToMenu(user, req, imcref, parentDocument, menuEditPage);
            this.redirectBackToMenu(req, res, menuEditPage);
        }
    }

    private void addDocumentsFromRequestToMenu(UserDomainObject user, HttpServletRequest req, ImcmsServices imcref, TextDocumentDomainObject parentDocument, MenuEditPage menuEditPage) {
        req.getSession().setAttribute("flags", (Object)new Integer(262144));
        String[] values = req.getParameterValues("existing_meta_id");
        if (values == null) {
            values = new String[]{};
        }
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        for (String value : values) {
            int existingDocumentId = Integer.parseInt(value);
            DocumentDomainObject existingDocument = documentMapper.getPublishedDocument(existingDocumentId);
            this.addDocumentToMenu(existingDocument, parentDocument, user, menuEditPage);
        }
        try {
            menuEditPage.save(user);
        }
        catch (DocumentSaveException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private void redirectBackToMenu(HttpServletRequest req, HttpServletResponse res, MenuEditPage page) throws IOException, ServletException {
        page.forward(req, res);
    }

    private void addDocumentToMenu(DocumentDomainObject document, TextDocumentDomainObject parentDocument, UserDomainObject user, MenuEditPage menuEditPage) {
        boolean canAddToMenu = this.canAddToMenu(user, parentDocument, document);
        if (canAddToMenu) {
            menuEditPage.getMenu().addMenuItem(new MenuItemDomainObject(new DirectDocumentReference(document)));
        }
    }

    private boolean canAddToMenu(UserDomainObject user, TextDocumentDomainObject parentDocument, DocumentDomainObject document) {
        Set allowedDocumentTypeIds = ((TextDocumentPermissionSetDomainObject)user.getPermissionSetFor(parentDocument)).getAllowedDocumentTypeIds();
        boolean sharePermission = user.canAddDocumentToAnyMenu(document);
        return sharePermission && (allowedDocumentTypeIds.isEmpty() || allowedDocumentTypeIds.contains(new Integer(document.getDocumentTypeId())));
    }

    /*
     * WARNING - void declaration
     */
    private void createSearchResultsPage(ImcmsServices imcref, UserDomainObject user, String langPrefix, List searchResultDocuments, TextDocumentDomainObject parentDocument, int doc_menu_no, HttpServletRequest req, Date startDate, DateFormat dateFormat, Date endDate, String[] docTypes, String sortBy, List sortOrderV, Writer out, MenuEditPage page) throws IOException {
        String[] allPossibleSearchPreps;
        String[] allPossibleIncludeDocsValues;
        void var28_34;
        String[] includeDocs;
        DocumentDomainObjectComparator searchResultsComparator = new DocumentDomainObjectComparator(sortBy);
        Collections.sort(searchResultDocuments, searchResultsComparator);
        ArrayList<String> outVector = new ArrayList<String>();
        String oneRecHtmlSrc = imcref.getAdminTemplate(ONE_SEARCH_HIT, user, null);
        String[][] allDocTypesArray = imcref.getAllDocumentTypes(langPrefix);
        Map allDocTypesHash = GetExistingDoc.convertToMap(allDocTypesArray);
        StringBuffer searchResults = GetExistingDoc.parseSearchResults(oneRecHtmlSrc, searchResultDocuments, allDocTypesHash, user, req);
        ArrayList<String> tmpV = new ArrayList<String>();
        tmpV.add("#searchResults#");
        tmpV.add(searchResults.toString());
        searchResults.replace(0, searchResults.length(), imcref.getAdminTemplate(SEARCH_RESULTS, user, tmpV));
        outVector.add("#meta_id#");
        outVector.add("" + parentDocument.getId());
        outVector.add("#doc_menu_no#");
        outVector.add("" + doc_menu_no);
        outVector.add("#page#");
        outVector.add(page.getSessionAttributeName());
        outVector.add("#searchstring#");
        String searchStr = req.getParameter("searchstring") == null ? "" : req.getParameter("searchstring");
        outVector.add(searchStr);
        outVector.add("#start_date#");
        if (startDate == null) {
            outVector.add("");
        } else {
            outVector.add(dateFormat.format(startDate));
        }
        outVector.add("#end_date#");
        outVector.add(dateFormat.format(endDate));
        if (docTypes != null) {
            HashMap<String, String> selectedDocTypes = new HashMap<String, String>(docTypes.length);
            for (String string : docTypes) {
                selectedDocTypes.put(string, string);
            }
            for (String string : allDocTypesArray) {
                outVector.add("#checked_" + string[0] + "#");
                if (selectedDocTypes.containsKey(string[0])) {
                    outVector.add("checked");
                    continue;
                }
                outVector.add("");
            }
        }
        if ((includeDocs = req.getParameterValues("include_doc")) == null) {
            includeDocs = new String[]{};
        }
        HashSet<String> selectedIncludeDocs = new HashSet<String>(includeDocs.length);
        String[] arr$ = includeDocs;
        int len$ = arr$.length;
        boolean bl = false;
        while (var28_34 < len$) {
            String includeDoc = arr$[var28_34];
            selectedIncludeDocs.add(includeDoc);
            ++var28_34;
        }
        for (String allPossibleIncludeDocsValue : allPossibleIncludeDocsValues = new String[]{"created", "changed"}) {
            outVector.add("#include_check_" + allPossibleIncludeDocsValue + "#");
            if (selectedIncludeDocs.contains(allPossibleIncludeDocsValue)) {
                outVector.add("checked");
                continue;
            }
            outVector.add("");
        }
        String[] searchPrepArr = req.getParameterValues("search_prep");
        if (searchPrepArr == null) {
            searchPrepArr = new String[]{};
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(searchPrepArr.length);
        for (String aSearchPrepArr : searchPrepArr) {
            hashMap.put(aSearchPrepArr, aSearchPrepArr);
        }
        for (String allPossibleSearchPrep : allPossibleSearchPreps = new String[]{"and", "or"}) {
            outVector.add("#search_prep_check_" + allPossibleSearchPrep + "#");
            if (hashMap.containsKey(allPossibleSearchPrep)) {
                outVector.add("checked");
                continue;
            }
            outVector.add("");
        }
        String sortOrderStr = Html.createOptionList(sortOrderV, sortBy);
        outVector.add("#sortBy#");
        outVector.add(sortOrderStr);
        outVector.add("#searchResults#");
        outVector.add(searchResults.toString());
        String htmlOut = imcref.getAdminTemplate(ADMIN_TEMPLATE_EXISTING_DOC, user, outVector);
        out.write(htmlOut);
    }

    private void addDocTypesToQuery(String[] docTypes, BooleanQuery query) {
        BooleanQuery docTypesQuery = new BooleanQuery();
        for (int i = 0; null != docTypes && i < docTypes.length; ++i) {
            String docType = docTypes[i];
            docTypesQuery.add((Query)new TermQuery(new Term("doc_type_id", docType)), false, false);
        }
        query.add((Query)docTypesQuery, true, false);
    }

    private void addDateRangesToQuery(Date startDate, Date endDate, HttpServletRequest req, BooleanQuery query) {
        if (null != startDate || null != endDate) {
            String[] wantedDateFields = req.getParameterValues("include_doc");
            for (int i = 0; null != wantedDateFields && i < wantedDateFields.length; ++i) {
                String wantedIndexDateField;
                String wantedDateField = wantedDateFields[i];
                if ("created".equalsIgnoreCase(wantedDateField)) {
                    wantedIndexDateField = "created_datetime";
                } else {
                    if (!"changed".equalsIgnoreCase(wantedDateField)) continue;
                    wantedIndexDateField = "modified_datetime";
                }
                Term startDateTerm = null != startDate ? new Term(wantedIndexDateField, DateField.dateToString((Date)startDate)) : null;
                Term endDateTerm = null != endDate ? new Term(wantedIndexDateField, DateField.dateToString((Date)this.addOneDayToDate(endDate))) : null;
                RangeQuery dateRangeQuery = new RangeQuery(startDateTerm, endDateTerm, true);
                query.add((Query)dateRangeQuery, true, false);
            }
        }
    }

    private Date addOneDayToDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        return calendar.getTime();
    }

    private void addStringToQuery(String string, BooleanQuery query) throws ParseException {
        Query textQuery = new DefaultQueryParser().parse(string);
        query.add(textQuery, true, false);
    }

    private static Map convertToMap(String[][] arr) {
        HashMap<String, String> h = new HashMap<String, String>();
        for (String[] anArr : arr) {
            h.put(anArr[0], anArr[1]);
        }
        return h;
    }

    private static StringBuffer parseSearchResults(String oneRecHtmlSrc, List<DocumentDomainObject> searchResultDocuments, Map docTypesHash, UserDomainObject user, HttpServletRequest request) {
        StringBuffer searchResults = new StringBuffer(1024);
        for (DocumentDomainObject document : searchResultDocuments) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String alias = document.getAlias();
            int meta_id = document.getId();
            String[] data = new String[]{"#alias#", alias, "#meta_id#", meta_id + "", "#page_name#", document.getName(), "#status#", Html.getStatusIconTemplate(document, user), "#doc_type#", (String)docTypesHash.get("" + document.getDocumentTypeId()), "#meta_headline#", document.getHeadline(), "#meta_text#", document.getMenuText(), "#date_created#", GetExistingDoc.formatDate(dateFormat, document.getCreatedDatetime()), "#date_modified#", GetExistingDoc.formatDate(dateFormat, document.getModifiedDatetime()), "#date_activated#", GetExistingDoc.formatDate(dateFormat, document.getPublicationStartDatetime()), "#date_archived#", GetExistingDoc.formatDate(dateFormat, document.getArchivedDatetime()), "#archive#", document.isArchived() ? "1" : "0"};
            searchResults.append(Parser.parseDoc(oneRecHtmlSrc, data));
        }
        return searchResults;
    }

    private static String formatDate(DateFormat dateFormat, Date datetime) {
        return null != datetime ? dateFormat.format(datetime) : "&nbsp;";
    }

    private class DocumentDomainObjectComparator
    implements Comparator {
        private String sortBy;

        private DocumentDomainObjectComparator(String sortBy) {
            this.sortBy = sortBy;
        }

        public int compare(Object o1, Object o2) {
            DocumentDomainObject d1 = (DocumentDomainObject)o1;
            DocumentDomainObject d2 = (DocumentDomainObject)o2;
            if ("meta_headline".equalsIgnoreCase(this.sortBy)) {
                return d1.getHeadline().compareToIgnoreCase(d2.getHeadline());
            }
            if ("doc_type".equalsIgnoreCase(this.sortBy)) {
                return d1.getDocumentTypeId() - d2.getDocumentTypeId();
            }
            if ("date_modified".equalsIgnoreCase(this.sortBy)) {
                return Utility.compareDatesWithNullFirst(d1.getModifiedDatetime(), d2.getModifiedDatetime());
            }
            if ("date_created".equalsIgnoreCase(this.sortBy)) {
                return Utility.compareDatesWithNullFirst(d1.getCreatedDatetime(), d2.getCreatedDatetime());
            }
            if ("date_archived".equalsIgnoreCase(this.sortBy)) {
                return Utility.compareDatesWithNullFirst(d1.getArchivedDatetime(), d2.getArchivedDatetime());
            }
            if ("date_activated".equalsIgnoreCase(this.sortBy)) {
                return Utility.compareDatesWithNullFirst(d1.getPublicationStartDatetime(), d2.getPublicationStartDatetime());
            }
            return d1.getId() - d2.getId();
        }
    }
}

