/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.imcms.api.Meta;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentPermissionSetMapper {
    public DocumentPermissionSetMapper(Database database) {
    }

    public void saveRestrictedDocumentPermissionSets(DocumentDomainObject document, UserDomainObject user, DocumentDomainObject oldDocument) {
        if (null == oldDocument || user.canDefineRestrictedOneFor(oldDocument)) {
            this.saveRestrictedDocumentPermissionSet(document, document.getPermissionSets().getRestricted1(), false);
            this.saveRestrictedDocumentPermissionSet(document, document.getPermissionSetsForNewDocuments().getRestricted1(), true);
        }
        if (null == oldDocument || user.canDefineRestrictedTwoFor(oldDocument)) {
            this.saveRestrictedDocumentPermissionSet(document, document.getPermissionSets().getRestricted2(), false);
            this.saveRestrictedDocumentPermissionSet(document, document.getPermissionSetsForNewDocuments().getRestricted2(), true);
        }
    }

    void saveRestrictedDocumentPermissionSet(DocumentDomainObject document, DocumentPermissionSetDomainObject documentPermissionSet, boolean forNewDocuments) {
        ArrayList<PermissionPair> permissionPairs = new ArrayList<PermissionPair>(Arrays.asList(new PermissionPair(1, documentPermissionSet.getEditDocumentInformation()), new PermissionPair(4, documentPermissionSet.getEditPermissions())));
        if (document instanceof TextDocumentDomainObject) {
            TextDocumentPermissionSetDomainObject textDocumentPermissionSet = (TextDocumentPermissionSetDomainObject)documentPermissionSet;
            permissionPairs.add(new PermissionPair(65536, textDocumentPermissionSet.getEditTexts()));
            permissionPairs.add(new PermissionPair(131072, textDocumentPermissionSet.getEditImages()));
            permissionPairs.add(new PermissionPair(262144, textDocumentPermissionSet.getEditMenus()));
            permissionPairs.add(new PermissionPair(524288, textDocumentPermissionSet.getEditTemplates()));
            permissionPairs.add(new PermissionPair(0x100000, textDocumentPermissionSet.getEditIncludes()));
        } else {
            permissionPairs.add(new PermissionPair(65536, documentPermissionSet.getEdit()));
        }
        int permissionBits = 0;
        for (PermissionPair permissionPair : permissionPairs) {
            if (!permissionPair.hasPermission) continue;
            permissionBits |= permissionPair.bit;
        }
        Meta meta = document.getMeta();
        Set<Meta.PermisionSetEx> permisionSetEx = forNewDocuments ? meta.getPermisionSetExForNew() : meta.getPermisionSetEx();
        Map<Integer, Integer> permissionSetBitsMap = forNewDocuments ? meta.getPermissionSetBitsForNewMap() : meta.getPermissionSetBitsMap();
        Integer setId = documentPermissionSet.getType().getId();
        permissionSetBitsMap.put(setId, permissionBits);
        HashSet<Meta.PermisionSetEx> filteredPermissionSetEx = new HashSet<Meta.PermisionSetEx>();
        for (Meta.PermisionSetEx setEx : permisionSetEx) {
            if (setEx.getSetId().equals(setId)) continue;
            filteredPermissionSetEx.add(setEx);
        }
        permisionSetEx = filteredPermissionSetEx;
        if (forNewDocuments) {
            meta.setPermisionSetExForNew(permisionSetEx);
        } else {
            meta.setPermisionSetEx(permisionSetEx);
        }
        if (document instanceof TextDocumentDomainObject) {
            TextDocumentPermissionSetDomainObject textDocumentPermissionSet = (TextDocumentPermissionSetDomainObject)documentPermissionSet;
            this.sqlSaveAllowedTemplateGroups(document, textDocumentPermissionSet, forNewDocuments, permisionSetEx);
            this.sqlSaveAllowedDocumentTypes(document, textDocumentPermissionSet, forNewDocuments, permisionSetEx);
        }
    }

    private void sqlSaveAllowedTemplateGroups(DocumentDomainObject document, TextDocumentPermissionSetDomainObject textDocumentPermissionSet, boolean forNewDocuments, Set<Meta.PermisionSetEx> permisionSetEx) {
        Set allowedTemplateGroupIds = textDocumentPermissionSet.getAllowedTemplateGroupIds();
        Integer setId = textDocumentPermissionSet.getType().getId();
        for (Integer allowedTemplateGroupId : allowedTemplateGroupIds) {
            Meta.PermisionSetEx setEx = new Meta.PermisionSetEx();
            setEx.setSetId(setId);
            setEx.setPermissionId(524288);
            setEx.setPermissionData(allowedTemplateGroupId);
            permisionSetEx.add(setEx);
        }
    }

    private void sqlSaveAllowedDocumentTypes(DocumentDomainObject document, TextDocumentPermissionSetDomainObject textDocumentPermissionSet, boolean forNewDocuments, Set<Meta.PermisionSetEx> permisionSetEx) {
        Set allowedDocumentTypeIds = textDocumentPermissionSet.getAllowedDocumentTypeIds();
        Integer setId = textDocumentPermissionSet.getType().getId();
        for (Integer allowedDocumentTypeId : allowedDocumentTypeIds) {
            Meta.PermisionSetEx setEx = new Meta.PermisionSetEx();
            setEx.setSetId(setId);
            setEx.setPermissionId(8);
            setEx.setPermissionData(allowedDocumentTypeId);
            permisionSetEx.add(setEx);
        }
    }

    private static class PermissionPair {
        int bit;
        boolean hasPermission;

        private PermissionPair(int bit, boolean hasPermission) {
            this.hasPermission = hasPermission;
            this.bit = bit;
        }
    }
}

