/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.imcms.dao.MetaDao;
import com.imcode.imcms.mapping.DocumentStoringVisitor;
import com.imcode.imcms.mapping.TextDocumentInitializer;
import com.imcode.imcms.mapping.orm.FileReference;
import com.imcode.imcms.mapping.orm.HtmlReference;
import com.imcode.imcms.mapping.orm.UrlReference;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.HtmlDocumentDomainObject;
import imcode.server.document.UrlDocumentDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.util.io.FileInputStreamSource;
import java.io.File;
import java.util.Collection;

class DocumentInitializingVisitor
extends DocumentVisitor {
    private TextDocumentInitializer textDocumentInitializer;
    private MetaDao metaDao;

    DocumentInitializingVisitor() {
    }

    public void visitFileDocument(FileDocumentDomainObject document) {
        Collection<FileReference> fileReferences = this.metaDao.getFileReferences(document.getMeta().getId());
        for (FileReference fileRef : fileReferences) {
            File oldlyNamedFileForFileDocument;
            String fileId = fileRef.getFileId();
            FileDocumentDomainObject.FileDocumentFile file = new FileDocumentDomainObject.FileDocumentFile();
            file.setFilename(fileRef.getFilename());
            file.setMimeType(fileRef.getMimeType());
            file.setCreatedAsImage(fileRef.getCreatedAsImage());
            File fileForFileDocument = DocumentStoringVisitor.getFileForFileDocumentFile(document.getId(), fileId);
            if (!fileForFileDocument.exists() && (oldlyNamedFileForFileDocument = new File(fileForFileDocument.getParentFile(), fileForFileDocument.getName() + "_se")).exists()) {
                fileForFileDocument = oldlyNamedFileForFileDocument;
            }
            file.setInputStreamSource(new FileInputStreamSource(fileForFileDocument));
            document.addFile(fileId, file);
            if (!fileRef.isDefaultFileId().booleanValue()) continue;
            document.setDefaultFileId(fileId);
        }
    }

    public void visitHtmlDocument(HtmlDocumentDomainObject document) {
        HtmlReference html = this.metaDao.getHtmlReference(document.getMeta().getId());
        document.setHtml(html.getHtml());
    }

    public void visitUrlDocument(UrlDocumentDomainObject document) {
        UrlReference reference = this.metaDao.getUrlReference(document.getMeta().getId());
        document.setUrl(reference.getUrl());
    }

    public void visitTextDocument(TextDocumentDomainObject document) {
        this.textDocumentInitializer.initialize(document);
    }

    public MetaDao getMetaDao() {
        return this.metaDao;
    }

    public void setMetaDao(MetaDao metaDao) {
        this.metaDao = metaDao;
    }

    public TextDocumentInitializer getTextDocumentInitializer() {
        return this.textDocumentInitializer;
    }

    public void setTextDocumentInitializer(TextDocumentInitializer textDocumentInitializer) {
        this.textDocumentInitializer = textDocumentInitializer;
    }
}

