/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.imcms.mapping.DocumentGetter;
import com.imcode.imcms.mapping.DocumentGetterWrapper;
import imcode.server.document.DocumentDomainObject;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;

public class CachingDocumentGetter
extends DocumentGetterWrapper {
    private Map<Integer, DocumentDomainObject> publishedDocumentsCache;
    private Map<String, Integer> aliases;
    private Map<Integer, DocumentDomainObject> workingDocumentsCache;

    public CachingDocumentGetter(DocumentGetter documentGetter, int cacheSize) {
        super(documentGetter);
        this.publishedDocumentsCache = Collections.synchronizedMap(new LRUMap(cacheSize));
        this.workingDocumentsCache = Collections.synchronizedMap(new LRUMap(cacheSize));
        this.aliases = Collections.synchronizedMap(new LRUMap(cacheSize));
    }

    public DocumentDomainObject getPublishedDocument(Integer documentId) {
        DocumentDomainObject document = this.publishedDocumentsCache.get(documentId);
        if (null == document && (document = super.getPublishedDocument(documentId)) != null) {
            this.publishedDocumentsCache.put(documentId, document);
        }
        return document;
    }

    public DocumentDomainObject getWorkingDocument(Integer documentId) {
        DocumentDomainObject document = this.workingDocumentsCache.get(documentId);
        if (null == document && (document = super.getWorkingDocument(documentId)) != null) {
            this.workingDocumentsCache.put(documentId, document);
        }
        return document;
    }

    public void clearCache() {
        this.publishedDocumentsCache.clear();
        this.workingDocumentsCache.clear();
    }

    public void removeDocumentFromCache(Integer documentId) {
        this.removePublishedDocumentFromCache(documentId);
        this.removeWorkingDocumentFromCache(documentId);
    }

    public DocumentDomainObject removePublishedDocumentFromCache(Integer documentId) {
        return this.publishedDocumentsCache.remove(documentId);
    }

    public DocumentDomainObject removeWorkingDocumentFromCache(Integer documentId) {
        return this.workingDocumentsCache.remove(documentId);
    }

    public void setDocumentAliase(Integer documentId, String alias) {
        this.aliases.put(alias, documentId);
    }

    public Integer getDocumentId(String alias) {
        return this.aliases.get(alias);
    }
}

