/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.flow;

import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.flow.DocumentPageFlow;
import com.imcode.imcms.flow.EditDocumentInformationPageFlow;
import com.imcode.imcms.flow.EditDocumentPageFlow;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.util.l10n.LocalizedMessage;
import com.imcode.util.MultipartHttpServletRequest;
import imcode.server.Imcms;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.CounterStringFactory;
import imcode.util.Utility;
import imcode.util.io.InputStreamSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class EditFileDocumentPageFlow
extends EditDocumentPageFlow {
    public static final String REQUEST_PARAMETER__FILE_DOC__FILE = "file";
    public static final String REQUEST_PARAMETER__FILE_DOC__MIME_TYPE = "mimetype";
    public static final String REQUEST_PARAMETER__SELECT_FILE_BUTTON_PREFIX = "select_file_";
    public static final String REQUEST_PARAMETER__DEFAULT_FILE = "default_file";
    public static final String REQUEST_PARAMETER__DELETE_FILE_BUTTON_PREFIX = "delete_file_";
    public static final String REQUEST_PARAMETER__FILE_DOC__SELECTED_FILE_ID = "selected_file_id";
    public static final String REQUEST_PARAMETER__SAVE_FILE_BUTTON = "save_file_button";
    public static final String REQUEST_PARAMETER__FILE_DOC__NEW_FILE_ID_PREFIX = "new_file_id_";
    private static final String URL_I15D_PAGE__FILEDOC = "/jsp/docadmin/file_document.jsp";
    private static final LocalizedMessage ERROR_MESSAGE__UNABLE_TO_AUTODETECT_MIMETYPE = new LocalizedMessage("server/src/com/imcode/imcms/flow/EditFileDocumentPageFlow/unable_to_autodetect_mimetype");
    private static final LocalizedMessage ERROR_MESSAGE__NO_FILE_UPLOADED = new LocalizedMessage("server/src/com/imcode/imcms/flow/EditFileDocumentPageFlow/no_file_uploaded");
    private MimeTypeRestriction mimeTypeRestriction = new ValidMimeTypeRestriction();
    private ServletContext servletContext;
    private FileDocumentDomainObject.FileDocumentFile unfinishedNewFile;

    public EditFileDocumentPageFlow(FileDocumentDomainObject document, ServletContext servletContext, DispatchCommand returnCommand, DocumentPageFlow.SaveDocumentCommand saveDocumentCommand, MimeTypeRestriction mimeTypeRestriction) {
        super(document, returnCommand, saveDocumentCommand);
        this.servletContext = servletContext;
        if (null != mimeTypeRestriction) {
            this.mimeTypeRestriction = mimeTypeRestriction;
        }
    }

    protected void dispatchOkFromEditPage(HttpServletRequest r, HttpServletResponse response) throws IOException, ServletException {
        MultipartHttpServletRequest request = (MultipartHttpServletRequest)r;
        this.updateFromRequestAndDispatchIfError(request, response);
    }

    private void updateFromRequestAndDispatchIfError(MultipartHttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        boolean isChecked;
        String selectedFileId;
        FileDocumentDomainObject.FileDocumentFile file;
        boolean isNewFile;
        this.document.setTarget(EditDocumentInformationPageFlow.getTargetFromRequest((HttpServletRequest)request, "target"));
        FileDocumentDomainObject fileDocument = (FileDocumentDomainObject)this.document;
        String defaultFileId = request.getParameter(REQUEST_PARAMETER__DEFAULT_FILE);
        if (null != defaultFileId) {
            fileDocument.setDefaultFileId(defaultFileId);
        }
        boolean bl = isNewFile = null == (file = fileDocument.getFile(selectedFileId = this.changeFileIds(request, fileDocument)));
        if (isNewFile) {
            file = this.getUnfinishedNewFile();
        } else {
            this.unfinishedNewFile = null;
        }
        boolean bl2 = isChecked = !isNewFile || null != request.getParameter(REQUEST_PARAMETER__SAVE_FILE_BUTTON);
        if (isChecked) {
            boolean fileUploaded;
            MultipartHttpServletRequest.DataSourceFileItem fileItem = request.getParameterFileItem(REQUEST_PARAMETER__FILE_DOC__FILE);
            boolean bl3 = fileUploaded = 0L != fileItem.getSize();
            if (fileUploaded) {
                String fileItemName = fileItem.getName();
                if (StringUtils.isNotBlank((String)fileItemName)) {
                    file.setFilename(fileItemName);
                }
                file.setInputStreamSource(new FileItemInputStreamSource((FileItem)fileItem));
            }
            String mimeType = this.getMimeTypeFromRequestAndFilename(request, file.getFilename());
            LocalizedMessage errorMessage = null;
            if (null == file.getInputStreamSource()) {
                errorMessage = ERROR_MESSAGE__NO_FILE_UPLOADED;
            } else if (StringUtils.isBlank((String)mimeType)) {
                errorMessage = ERROR_MESSAGE__UNABLE_TO_AUTODETECT_MIMETYPE;
                this.setFileDocumentMimeTypeIfAllowed(file, "application/octet-stream");
            } else if (!this.mimeTypeRestriction.allows(mimeType)) {
                errorMessage = this.mimeTypeRestriction.getErrorMessage();
                String mimeTypeForFilename = this.getMimeTypeForFilename(file.getFilename());
                this.setFileDocumentMimeTypeIfAllowed(file, mimeTypeForFilename);
            } else {
                file.setMimeType(mimeType);
                if (isNewFile) {
                    String newFileId;
                    selectedFileId = newFileId = (String)Utility.findMatch(new CounterStringFactory(fileDocument.getFiles().size() + 1), new UniqueFileIdPredicate(fileDocument));
                    this.unfinishedNewFile = null;
                }
                fileDocument.addFile(selectedFileId, file);
            }
            if (null != errorMessage) {
                FileDocumentEditPage fileDocumentEditPage = this.createFileDocumentEditPage(selectedFileId);
                fileDocumentEditPage.setErrorMessage(errorMessage);
                fileDocumentEditPage.forward((HttpServletRequest)request, response);
            }
        }
    }

    private String changeFileIds(MultipartHttpServletRequest request, FileDocumentDomainObject fileDocument) {
        String selectedFileId = request.getParameter(REQUEST_PARAMETER__FILE_DOC__SELECTED_FILE_ID);
        Map fileDocumentFiles = fileDocument.getFiles();
        Iterator iterator = IteratorUtils.unmodifiableIterator(fileDocumentFiles.keySet().iterator());
        while (iterator.hasNext()) {
            String fileId = (String)iterator.next();
            String newFileId = request.getParameter(REQUEST_PARAMETER__FILE_DOC__NEW_FILE_ID_PREFIX + fileId);
            if (!StringUtils.isNotBlank((String)newFileId) || selectedFileId.equals(newFileId) || null != fileDocument.getFile(newFileId)) continue;
            fileDocument.changeFileId(fileId, newFileId);
            if (!fileId.equals(selectedFileId)) continue;
            selectedFileId = newFileId;
        }
        return selectedFileId;
    }

    private void setFileDocumentMimeTypeIfAllowed(FileDocumentDomainObject.FileDocumentFile file, String mimeTypeForFilename) {
        if (this.mimeTypeRestriction.allows(mimeTypeForFilename)) {
            file.setMimeType(mimeTypeForFilename);
        }
    }

    private FileDocumentEditPage createFileDocumentEditPage(String fileId) {
        FileDocumentDomainObject.FileDocumentFile file = ((FileDocumentDomainObject)this.document).getFile(fileId);
        if (null == file) {
            file = this.getUnfinishedNewFile();
        }
        return new FileDocumentEditPage(this.mimeTypeRestriction, fileId, file);
    }

    private FileDocumentDomainObject.FileDocumentFile getUnfinishedNewFile() {
        if (null == this.unfinishedNewFile) {
            this.unfinishedNewFile = new FileDocumentDomainObject.FileDocumentFile();
        }
        return this.unfinishedNewFile;
    }

    protected void dispatchToFirstPage(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.createFileDocumentEditPage(null).forward(request, response);
    }

    protected void dispatchFromEditPage(HttpServletRequest r, HttpServletResponse response, String page) throws IOException, ServletException {
        MultipartHttpServletRequest request = (MultipartHttpServletRequest)r;
        FileDocumentDomainObject fileDocument = (FileDocumentDomainObject)this.document;
        this.updateFromRequestAndDispatchIfError(request, response);
        String selectedFileId = null;
        if (!response.isCommitted()) {
            Map files = fileDocument.getFiles();
            for (Map.Entry entry : files.entrySet()) {
                String fileId = (String)entry.getKey();
                FileDocumentDomainObject.FileDocumentFile fileDocumentFile = (FileDocumentDomainObject.FileDocumentFile)entry.getValue();
                if (null != request.getParameter(REQUEST_PARAMETER__SELECT_FILE_BUTTON_PREFIX + fileId)) {
                    selectedFileId = fileId;
                }
                if (null == request.getParameter(REQUEST_PARAMETER__DELETE_FILE_BUTTON_PREFIX + fileId) && null != fileDocumentFile.getInputStreamSource()) continue;
                this.unfinishedNewFile = fileDocument.removeFile(fileId);
            }
            this.createFileDocumentEditPage(selectedFileId).forward((HttpServletRequest)request, response);
        }
    }

    private String getMimeTypeFromRequestAndFilename(MultipartHttpServletRequest request, String filename) {
        DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
        HashSet<String> predefinedMimeTypes = new HashSet<String>(Arrays.asList(documentMapper.getAllMimeTypes()));
        String[] mimeTypeParameters = request.getParameterValues(REQUEST_PARAMETER__FILE_DOC__MIME_TYPE);
        String mimeType = null;
        for (int i = 0; i < mimeTypeParameters.length && !predefinedMimeTypes.contains(mimeType = mimeTypeParameters[i].trim().toLowerCase()); ++i) {
            if (StringUtils.isBlank((String)mimeType)) {
                mimeType = this.getMimeTypeForFilename(filename);
                continue;
            }
            if (-1 != mimeType.indexOf(47)) continue;
            mimeType = this.getMimeTypeIfTreatedAsFilenameExtension(mimeType);
        }
        return mimeType;
    }

    private String getMimeTypeForFilename(String filename) {
        if (null == filename) {
            return null;
        }
        return this.servletContext.getMimeType(filename.toLowerCase());
    }

    private String getMimeTypeIfTreatedAsFilenameExtension(String mimeType) {
        String mimeTypeFromFilenameExtension;
        String filenameExtension = mimeType;
        if ('.' != filenameExtension.charAt(0)) {
            filenameExtension = '.' + filenameExtension;
        }
        if (null == (mimeTypeFromFilenameExtension = this.servletContext.getMimeType('_' + filenameExtension))) {
            mimeTypeFromFilenameExtension = mimeType;
        }
        return mimeTypeFromFilenameExtension;
    }

    private static class UniqueFileIdPredicate
    implements Predicate {
        private final FileDocumentDomainObject fileDocument;

        UniqueFileIdPredicate(FileDocumentDomainObject fileDocument) {
            this.fileDocument = fileDocument;
        }

        public boolean evaluate(Object object) {
            return null == this.fileDocument.getFile((String)object);
        }
    }

    public static class ArrayMimeTypeRestriction
    extends ValidMimeTypeRestriction {
        private String[] allowedMimeTypes;

        public ArrayMimeTypeRestriction(String[] allowedMimeTypes, LocalizedMessage errorMessage) {
            this.allowedMimeTypes = (String[])ArrayUtils.clone((Object[])allowedMimeTypes);
            this.errorMessage = errorMessage;
        }

        public boolean allows(String mimeType) {
            return super.allows(mimeType) && ArrayUtils.contains((Object[])this.allowedMimeTypes, (Object)mimeType);
        }
    }

    public static class ValidMimeTypeRestriction
    implements MimeTypeRestriction {
        protected LocalizedMessage errorMessage;
        private static final LocalizedMessage ERROR__INVALID_MIMETYPE = new LocalizedMessage("server/src/com/imcode/imcms/flow/EditFileDocumentPageFlow/invalid_mimetype");

        public boolean allows(String mimeType) {
            if (StringUtils.isBlank((String)mimeType) || !this.isValidMimeType(mimeType)) {
                this.errorMessage = ERROR__INVALID_MIMETYPE;
                return false;
            }
            return true;
        }

        private boolean isValidMimeType(String mimeType) {
            return Pattern.compile("^(x-[a-z-]+|application|audio|image|message|model|multipart|text|video)/", 2).matcher(mimeType).find();
        }

        public LocalizedMessage getErrorMessage() {
            return this.errorMessage;
        }
    }

    public static interface MimeTypeRestriction
    extends Serializable {
        public boolean allows(String var1);

        public LocalizedMessage getErrorMessage();
    }

    public static class FileDocumentEditPage {
        private static final String REQUEST_ATTRIBUTE__FILE_DOCUMENT_EDIT_PAGE = "fileDocumentEditPage";
        private LocalizedMessage errorMessage;
        private MimeTypeRestriction pageMimeTypeRestriction;
        private String selectedFileId;
        private FileDocumentDomainObject.FileDocumentFile selectedFile;

        public FileDocumentEditPage(MimeTypeRestriction allowedMimeTypes, String fileId, FileDocumentDomainObject.FileDocumentFile file) {
            this.pageMimeTypeRestriction = allowedMimeTypes;
            this.selectedFileId = fileId;
            this.selectedFile = file;
        }

        public MimeTypeRestriction getPageMimeTypeRestriction() {
            return this.pageMimeTypeRestriction;
        }

        public static FileDocumentEditPage fromRequest(HttpServletRequest request) {
            return (FileDocumentEditPage)request.getAttribute(REQUEST_ATTRIBUTE__FILE_DOCUMENT_EDIT_PAGE);
        }

        public void forward(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            request.setAttribute(REQUEST_ATTRIBUTE__FILE_DOCUMENT_EDIT_PAGE, (Object)this);
            UserDomainObject user = Utility.getLoggedOnUser(request);
            request.getRequestDispatcher("/imcms/" + user.getLanguageIso639_2() + EditFileDocumentPageFlow.URL_I15D_PAGE__FILEDOC).forward((ServletRequest)request, (ServletResponse)response);
        }

        public void setErrorMessage(LocalizedMessage localizedErrorMessage) {
            this.errorMessage = localizedErrorMessage;
        }

        public LocalizedMessage getErrorMessage() {
            return this.errorMessage;
        }

        public FileDocumentDomainObject.FileDocumentFile getSelectedFile() {
            return this.selectedFile;
        }

        public String getSelectedFileId() {
            return this.selectedFileId;
        }
    }

    public static class FileItemInputStreamSource
    implements InputStreamSource {
        private final FileItem fileItem;

        public FileItemInputStreamSource(FileItem fileItem) {
            this.fileItem = fileItem;
        }

        public InputStream getInputStream() throws IOException {
            return this.fileItem.getInputStream();
        }

        public long getSize() throws IOException {
            return this.fileItem.getSize();
        }
    }
}

