/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.dao;

import com.imcode.imcms.api.I18nLanguage;
import com.imcode.imcms.dao.LanguageDao;
import com.imcode.imcms.mapping.TextDocumentInitializer;
import imcode.server.document.textdocument.ImageDomainObject;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageDao
extends HibernateTemplate {
    private LanguageDao languageDao;

    @Transactional
    public synchronized List<ImageDomainObject> getImagesByIndex(Integer documentId, Integer documentVersion, int imageId, boolean createImageIfNotExists) {
        List<I18nLanguage> languages = this.languageDao.getAllLanguages();
        LinkedList<ImageDomainObject> images = new LinkedList<ImageDomainObject>();
        for (I18nLanguage language : languages) {
            ImageDomainObject image = this.getImage(language.getId(), documentId, documentVersion, imageId);
            if (image == null && createImageIfNotExists) {
                image = new ImageDomainObject();
                image.setMetaId(documentId);
                image.setName("" + imageId);
                image.setLanguage(language);
            }
            if (image == null) continue;
            images.add(TextDocumentInitializer.setImageSource(image));
        }
        return images;
    }

    public synchronized ImageDomainObject getImage(int languageId, Integer documentId, Integer documentVersion, int index) {
        ImageDomainObject image = (ImageDomainObject)this.getSession().createQuery("select i from Image i where i.metaId = :documentId AND i.metaVersion = :documentVersion and i.name = :name and i.language.id = :languageId").setParameter("documentId", (Object)documentId).setParameter("documentVersion", (Object)documentVersion).setParameter("name", (Object)("" + index)).setParameter("languageId", (Object)languageId).uniqueResult();
        return image;
    }

    @Transactional
    public ImageDomainObject saveImage(ImageDomainObject image) {
        image.setImageUrl(image.getSource().toStorageString());
        image.setType(image.getSource().getTypeId());
        this.saveOrUpdate(image);
        return image;
    }

    @Transactional
    public Collection<ImageDomainObject> getImages(Integer documentId, Integer documentVersion) {
        return this.findByNamedQueryAndNamedParam("Image.getByDocumentIdAndDocumentVersion", new String[]{"documentId", "documentVersion"}, new Object[]{documentId, documentVersion});
    }

    public LanguageDao getLanguageDao() {
        return this.languageDao;
    }

    public void setLanguageDao(LanguageDao languageDao) {
        this.languageDao = languageDao;
    }
}

