/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.Template;
import com.imcode.imcms.api.TemplateGroup;
import com.imcode.imcms.api.TextDocument;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.TemplateGroupDomainObject;
import imcode.server.document.TemplateMapper;
import imcode.server.user.UserDomainObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TemplateService {
    private ContentManagementSystem contentManagementSystem;

    TemplateService(ContentManagementSystem contentManagementSystem) {
        this.contentManagementSystem = contentManagementSystem;
    }

    public TemplateGroup[] getTemplatesGroups(TextDocument textDocument) throws NoPermissionException {
        UserDomainObject user = this.contentManagementSystem.getCurrentUser().getInternal();
        TemplateGroupDomainObject[] internalTemplates = this.getTemplateMapper().getAllTemplateGroupsAvailableForUserOnDocument(user, textDocument.getId());
        return this.createTemplateGroupArray(internalTemplates);
    }

    private TemplateMapper getTemplateMapper() {
        return this.contentManagementSystem.getInternal().getTemplateMapper();
    }

    public TemplateGroup[] getAllTemplateGroups() {
        TemplateGroupDomainObject[] templateGroupDomainObject = this.getTemplateMapper().getAllTemplateGroups();
        return this.createTemplateGroupArray(templateGroupDomainObject);
    }

    private TemplateGroup[] createTemplateGroupArray(TemplateGroupDomainObject[] internalTemplates) {
        TemplateGroup[] result = new TemplateGroup[internalTemplates.length];
        for (int i = 0; i < internalTemplates.length; ++i) {
            result[i] = new TemplateGroup(internalTemplates[i]);
        }
        return result;
    }

    public Template[] getTemplates(TemplateGroup templateGroup) throws NoPermissionException {
        List<TemplateDomainObject> templates = this.getTemplateMapper().getTemplatesInGroup(templateGroup.getInternal());
        ArrayList<Template> result = new ArrayList<Template>(templates.size());
        for (TemplateDomainObject template : templates) {
            result.add(new Template(template));
        }
        return result.toArray(new Template[result.size()]);
    }

    public Template[] getPossibleTemplates(TextDocument textDocument) throws NoPermissionException {
        TemplateGroup[] groups = this.getTemplatesGroups(textDocument);
        ArrayList<Template> temp = new ArrayList<Template>();
        for (TemplateGroup group : groups) {
            Template[] templates = this.getTemplates(group);
            temp.addAll(Arrays.asList(templates));
        }
        return temp.toArray(new Template[temp.size()]);
    }

    public Template getTemplate(String templateName) {
        TemplateDomainObject template = this.getTemplateMapper().getTemplateByName(templateName);
        return null != template ? new Template(template) : null;
    }

    public TemplateGroup getTemplateGroupById(int templateGroupId) {
        TemplateGroupDomainObject template = this.getTemplateMapper().getTemplateGroupById(templateGroupId);
        return null != template ? new TemplateGroup(template) : null;
    }
}

