/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.I18nLanguage;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.CollectionOfElements;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="i18n_meta")
@NamedQueries(value={@NamedQuery(name="I18nMeta.getByLanguage", query="select m from I18nMeta m where m.metaId = :metaId and m.language.id = :languageId")})
public class I18nMeta
implements Serializable,
Cloneable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="i18n_meta_id")
    private Long id;
    @Column(name="meta_id")
    private Integer metaId;
    @Column(name="meta_enabled")
    private Boolean enabled;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="language_id", referencedColumnName="language_id")
    private I18nLanguage language;
    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="keywords", joinColumns={@JoinColumn(name="meta_id", referencedColumnName="meta_id"), @JoinColumn(name="language_id", referencedColumnName="language_id")})
    @Column(name="value")
    private Set<String> keywords = new HashSet<String>();
    @Column(name="meta_headline")
    private String headline;
    @Column(name="meta_text")
    private String menuText;
    @Column(name="meta_image")
    private String menuImageURL;

    public I18nMeta clone() {
        try {
            I18nMeta clone = (I18nMeta)super.clone();
            if (this.keywords != null) {
                clone.keywords = new HashSet<String>(this.keywords);
            }
            if (this.language != null) {
                clone.language = this.language.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.intValue();
    }

    public boolean equals(Object o) {
        return o instanceof I18nMeta && ((I18nMeta)o).hashCode() == this.hashCode();
    }

    public String getHeadline() {
        return this.headline;
    }

    public void setHeadline(String headline) {
        this.headline = headline;
    }

    public String getMenuText() {
        return this.menuText;
    }

    public void setMenuText(String text) {
        this.menuText = text;
    }

    public String getMenuImageURL() {
        return this.menuImageURL;
    }

    public void setMenuImageURL(String image) {
        this.menuImageURL = image;
    }

    public I18nLanguage getLanguage() {
        return this.language;
    }

    public void setLanguage(I18nLanguage language) {
        this.language = language;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getMetaId() {
        return this.metaId;
    }

    public void setMetaId(Integer metaId) {
        this.metaId = metaId;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(Set<String> keywords) {
        this.keywords = keywords;
    }
}

