/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.servlet.ImcmsSetupFilter;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.textdocument.FileDocumentImageSource;
import imcode.server.document.textdocument.ImageArchiveImageSource;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.ImageSource;
import imcode.server.document.textdocument.ImagesPathRelativePathImageSource;
import imcode.server.document.textdocument.NullImageSource;
import imcode.util.Utility;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class ImcmsImageUtils {
    private ImcmsImageUtils() {
    }

    public static String getImageHtmlTag(Integer metaId, Integer imageIndex, ImageDomainObject image, HttpServletRequest request, Properties attributes) {
        return ImcmsImageUtils.getImageHtmlTag(metaId, imageIndex, image, request, attributes, false);
    }

    public static String getImageHtmlTag(Integer metaId, Integer imageIndex, ImageDomainObject image, HttpServletRequest request, Properties attributes, boolean absoluteUrl) {
        StringBuffer imageTagBuffer = new StringBuffer(96);
        if (image.getSize() > 0L) {
            String styleAttribute;
            String usemapAttribute;
            String classAttribute;
            if (StringUtils.isNotBlank((String)image.getLinkUrl())) {
                imageTagBuffer.append("<a href=\"").append(StringEscapeUtils.escapeHtml((String)image.getLinkUrl())).append("\"");
                if (!"".equals(image.getTarget())) {
                    imageTagBuffer.append(" target=\"").append(StringEscapeUtils.escapeHtml((String)image.getTarget())).append("\"");
                }
                imageTagBuffer.append('>');
            }
            String urlEscapedImageUrl = ImcmsImageUtils.getImageUrl(metaId, imageIndex, image, request.getContextPath());
            if (absoluteUrl) {
                StringBuffer requestURL = request.getRequestURL();
                urlEscapedImageUrl = requestURL.substring(0, StringUtils.ordinalIndexOf((String)requestURL.toString(), (String)"/", (int)3)) + urlEscapedImageUrl;
            }
            imageTagBuffer.append("<img src=\"").append(StringEscapeUtils.escapeHtml((String)urlEscapedImageUrl)).append("\"");
            imageTagBuffer.append(" alt=\"").append(StringEscapeUtils.escapeHtml((String)image.getAlternateText())).append("\"");
            imageTagBuffer.append(" title=\"").append(StringEscapeUtils.escapeHtml((String)image.getAlternateText())).append("\"");
            String id = image.getName();
            String idAttribute = attributes.getProperty("id");
            if (StringUtils.isNotBlank((String)idAttribute)) {
                id = idAttribute;
            }
            if (StringUtils.isNotBlank((String)id)) {
                imageTagBuffer.append(" id=\"").append(StringEscapeUtils.escapeHtml((String)id)).append("\"");
            }
            if (null != (classAttribute = attributes.getProperty("class"))) {
                imageTagBuffer.append(" class=\"").append(StringEscapeUtils.escapeHtml((String)classAttribute)).append("\"");
            }
            if (null != (usemapAttribute = attributes.getProperty("usemap"))) {
                imageTagBuffer.append(" usemap=\"").append(StringEscapeUtils.escapeHtml((String)usemapAttribute)).append("\"");
            }
            StringBuilder styleBuffer = new StringBuilder();
            styleBuffer.append("border-width: ").append(image.getBorder()).append("px;");
            int width = image.getWidth();
            int height = image.getHeight();
            if (0 != width) {
                imageTagBuffer.append(" width=\"").append(width).append("\"");
                styleBuffer.append(" width: ").append(width).append("px;");
            }
            if (0 != height) {
                imageTagBuffer.append(" height=\"").append(height).append("\"");
                styleBuffer.append(" height: ").append(height).append("px;");
            }
            styleBuffer.append(" margin: ").append(image.getVerticalSpace()).append("px ").append(image.getHorizontalSpace()).append("px;");
            if (StringUtils.isNotBlank((String)image.getAlign()) && "left".equals(image.getAlign())) {
                styleBuffer.append(" align: ").append(StringEscapeUtils.escapeHtml((String)image.getAlign())).append(";");
            }
            if (StringUtils.isNotBlank((String)image.getAlign()) && "right".equals(image.getAlign())) {
                styleBuffer.append(" align: ").append(StringEscapeUtils.escapeHtml((String)image.getAlign())).append(";");
            }
            if (StringUtils.isNotBlank((String)image.getAlign()) && !"none".equals(image.getAlign())) {
                styleBuffer.append(" vertical-align: ").append(StringEscapeUtils.escapeHtml((String)image.getAlign())).append(";");
            }
            if (null != (styleAttribute = attributes.getProperty("style"))) {
                styleBuffer.append(" ").append(styleAttribute);
            }
            imageTagBuffer.append(" style=\"").append(StringEscapeUtils.escapeHtml((String)styleBuffer.toString())).append("\"");
            imageTagBuffer.append(" />");
            if (StringUtils.isNotBlank((String)image.getLinkUrl())) {
                imageTagBuffer.append("</a>");
            }
        }
        return imageTagBuffer.toString();
    }

    public static String getImageUrl(Integer metaId, Integer imageIndex, ImageDomainObject image, String contextPath) {
        ImageDomainObject.CropRegion region;
        StringBuilder builder = new StringBuilder();
        builder.append(contextPath);
        builder.append("/imagehandling?");
        if (image.getSource() instanceof FileDocumentImageSource) {
            FileDocumentImageSource source = (FileDocumentImageSource)image.getSource();
            builder.append("file_id=");
            builder.append(source.getFileDocument().getId());
        } else {
            builder.append("path=");
            builder.append(Utility.encodeUrl(image.getUrlPathRelativeToContextPath()));
        }
        if (metaId != null && imageIndex != null) {
            builder.append("&meta_id=");
            builder.append(metaId);
            builder.append("&image_index=");
            builder.append(imageIndex);
        }
        builder.append("&width=");
        builder.append(image.getWidth());
        builder.append("&height=");
        builder.append(image.getHeight());
        if (image.getFormat() != null) {
            builder.append("&format=");
            builder.append(image.getFormat().getExtension());
        }
        if ((region = image.getCropRegion()).isValid()) {
            builder.append("&crop_x1=");
            builder.append(region.getCropX1());
            builder.append("&crop_y1=");
            builder.append(region.getCropY1());
            builder.append("&crop_x2=");
            builder.append(region.getCropX2());
            builder.append("&crop_y2=");
            builder.append(region.getCropY2());
        }
        return builder.toString();
    }

    public static ImageSource createImageSourceFromString(String imageUrl) {
        ImageSource imageSource = new NullImageSource();
        if (StringUtils.isNotBlank((String)imageUrl)) {
            String documentIdString;
            ImcmsServices services = Imcms.getServices();
            DocumentMapper documentMapper = services.getDocumentMapper();
            DocumentDomainObject document = documentMapper.getDocument(documentIdString = ImcmsSetupFilter.getDocumentIdString(services, imageUrl));
            if (document instanceof FileDocumentDomainObject) {
                imageSource = new FileDocumentImageSource(documentMapper.getDocumentReference(document));
            } else {
                String imageArchiveImageUrl = ImageArchiveImageSource.getImagesUrlPath();
                String imagesPath = ImagesPathRelativePathImageSource.getImagesUrlPath();
                if (imageUrl.startsWith(imageArchiveImageUrl)) {
                    imageUrl = imageUrl.substring(imageArchiveImageUrl.length());
                    imageSource = new ImageArchiveImageSource(imageUrl);
                } else {
                    if (imageUrl.startsWith(imagesPath)) {
                        imageUrl = imageUrl.substring(imagesPath.length());
                    }
                    imageSource = new ImagesPathRelativePathImageSource(imageUrl);
                }
            }
        }
        return imageSource;
    }
}

