/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.user;

import imcode.server.user.Authenticator;
import imcode.server.user.UserAndRoleRegistry;
import imcode.server.user.UserDomainObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class ChainedLdapUserAndRoleRegistry
implements Authenticator,
UserAndRoleRegistry {
    public static final String[] DEFAULT_ROLES = new String[]{"LDAP"};
    private Collection<Authenticator> authenticators = new LinkedList<Authenticator>();
    private Collection<UserAndRoleRegistry> userAndRoleRegistries = new LinkedList<UserAndRoleRegistry>();

    public ChainedLdapUserAndRoleRegistry() {
    }

    public ChainedLdapUserAndRoleRegistry(Authenticator authenticator, UserAndRoleRegistry userAndRoleRegistry) {
        this.addLink(authenticator, userAndRoleRegistry);
    }

    public void addLink(Authenticator authenticator, UserAndRoleRegistry userAndRoleRegistry) {
        this.authenticators.add(authenticator);
        this.userAndRoleRegistries.add(userAndRoleRegistry);
    }

    public boolean authenticate(String loginName, String password) {
        Authenticator authenticator;
        boolean result = false;
        Iterator<Authenticator> i$ = this.authenticators.iterator();
        while (i$.hasNext() && !(result = (authenticator = i$.next()).authenticate(loginName, password))) {
        }
        return result;
    }

    public UserDomainObject getUser(String loginName) {
        UserAndRoleRegistry userAndRoleRegistry;
        UserDomainObject user = null;
        Iterator<UserAndRoleRegistry> i$ = this.userAndRoleRegistries.iterator();
        while (i$.hasNext() && (user = (userAndRoleRegistry = i$.next()).getUser(loginName)) == null) {
        }
        return user;
    }

    public String[] getRoleNames(UserDomainObject user) {
        String[] roleNames = DEFAULT_ROLES;
        for (UserAndRoleRegistry userAndRoleRegistry : this.userAndRoleRegistries) {
            try {
                roleNames = userAndRoleRegistry.getRoleNames(user);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            if (roleNames.length <= 1) continue;
            break;
        }
        return roleNames;
    }

    public String[] getAllRoleNames() {
        return DEFAULT_ROLES;
    }
}

