/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.parser;

import com.imcode.imcms.api.Document;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.parser.MenuParser;
import imcode.server.parser.MockParserParameters;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import java.util.Date;
import junit.framework.TestCase;

public class TestMenuParser
extends TestCase {
    private MenuParser menuParser;
    private MockParserParameters parserParameters;
    private UserDomainObject user;
    private TextDocumentDomainObject textDocument;
    private RoleId editRole;
    private static final int MENU_INDEX = 1;

    protected void setUp() throws Exception {
        super.setUp();
        this.user = new UserDomainObject();
        this.textDocument = new TextDocumentDomainObject();
        this.editRole = new RoleId(3);
        this.textDocument.setDocumentPermissionSetTypeForRoleId(this.editRole, DocumentPermissionSetTypeDomainObject.FULL);
        this.parserParameters = new MockParserParameters(null);
        this.menuParser = new MenuParser(this.parserParameters);
    }

    public void testUserCantSeeUnpublishedDocumentInMenuWithoutPermissions() throws Exception {
        this.assertCanNotSeeDocumentInMenu();
    }

    public void testUserCantSeePublishedDocumentInMenuWithoutPermissions() {
        this.textDocument.setPublicationStartDatetime(new Date(0L));
        this.textDocument.setPublicationStatus(Document.PublicationStatus.APPROVED);
        this.assertCanNotSeeDocumentInMenu();
    }

    public void testUserCantSeeUnpublishedDocumentInMenuWithPermissions() {
        this.textDocument.setDocumentPermissionSetTypeForRoleId(RoleId.USERS, DocumentPermissionSetTypeDomainObject.READ);
        this.assertCanNotSeeDocumentInMenu();
    }

    public void testUserCanSeePublishedDocumentInMenuWithPermissions() {
        this.textDocument.setDocumentPermissionSetTypeForRoleId(RoleId.USERS, DocumentPermissionSetTypeDomainObject.READ);
        this.textDocument.setPublicationStartDatetime(new Date(0L));
        this.assertCanNotSeeDocumentInMenu();
        this.textDocument.setPublicationStatus(Document.PublicationStatus.APPROVED);
        this.assertCanSeeDocumentInMenuWhenEditingMenu();
    }

    public void testAdminCantSeeUnpublishedDocumentWhenInMenuModeButNotEditingMenu() {
        this.user.addRoleId(this.editRole);
        this.parserParameters.setMenuMode(true);
        this.assertCanNotSeeDocumentInMenu();
    }

    public void testAdminCantSeeUnpublishedDocumentWhenNotInMenuModeButEditingMenu() {
        this.user.addRoleId(this.editRole);
        this.parserParameters.setEditingMenuIndex(new Integer(1));
        this.assertCanNotSeeDocumentInMenu();
    }

    public void testAdminCanSeeUnpublishedDocumentWhenEditing() {
        this.user.addRoleId(this.editRole);
        this.parserParameters.setEditingMenuIndex(new Integer(1));
        this.parserParameters.setMenuMode(true);
        this.assertCanSeeDocumentInMenuWhenEditingMenu();
    }

    public void testUserCantSeeUnpublishedDocumentInMenuWhenEditing() throws Exception {
        this.parserParameters.setEditingMenuIndex(new Integer(1));
        this.parserParameters.setMenuMode(true);
        this.assertCanNotSeeDocumentInMenu();
    }

    public void testUserCanSeePublishedDocumentsVisibleForUnauthorizedUsers() {
        this.textDocument.setLinkedForUnauthorizedUsers(true);
        this.assertCanNotSeeDocumentInMenu();
        this.textDocument.setPublicationStartDatetime(new Date(0L));
        this.textDocument.setPublicationStatus(Document.PublicationStatus.APPROVED);
        this.assertCanSeeDocumentInMenuWhenEditingMenu();
    }

    private void assertCanNotSeeDocumentInMenu() {
        TestMenuParser.assertFalse((boolean)this.user.canSeeDocumentInMenus(this.textDocument));
    }

    private void assertCanSeeDocumentInMenuWhenEditingMenu() {
        TestMenuParser.assertTrue((boolean)this.user.canSeeDocumentWhenEditingMenus(this.textDocument));
    }
}

