/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import imcode.server.document.textdocument.ImageDomainObject;
import imcode.util.image.Format;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ImageCacheDomainObject
implements Serializable {
    private static final long serialVersionUID = -2547384841538448930L;
    public static final short TYPE_PATH = 1;
    public static final short TYPE_FILE_DOCUMENT = 2;
    public static final short TYPE_URL = 3;
    private String id;
    private int metaId;
    private int imageIndex;
    private String resource;
    private short type;
    private int fileSize;
    private int frequency;
    private Format format;
    private int width;
    private int height;
    ImageDomainObject.CropRegion cropRegion;
    private Timestamp createdDate = new Timestamp(new Date().getTime());

    public ImageCacheDomainObject() {
    }

    public ImageCacheDomainObject(String id, int metaId, int imageIndex, String resource, short type, int fileSize, int frequency, Format format, int width, int height, ImageDomainObject.CropRegion cropRegion, Timestamp createdDate) {
        this.id = id;
        this.metaId = metaId;
        this.imageIndex = imageIndex;
        this.resource = resource;
        this.type = type;
        this.fileSize = fileSize;
        this.frequency = frequency;
        this.format = format;
        this.width = width;
        this.height = height;
        this.cropRegion = cropRegion;
        this.createdDate = createdDate;
    }

    public void generateId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.resource);
        builder.append(this.type);
        builder.append(this.format != null ? Integer.valueOf(this.format.getOrdinal()) : null);
        builder.append(this.width);
        builder.append(this.height);
        if (this.cropRegion.isValid()) {
            builder.append(this.cropRegion.getCropX1());
            builder.append(this.cropRegion.getCropY1());
            builder.append(this.cropRegion.getCropX2());
            builder.append(this.cropRegion.getCropY2());
        } else {
            builder.append("-1-1-1-1");
        }
        this.id = DigestUtils.shaHex((String)builder.toString());
    }

    public boolean isDocumentImage() {
        return this.metaId > 0;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public short getType() {
        return this.type;
    }

    public void setType(short type) {
        this.type = type;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public ImageDomainObject.CropRegion getCropRegion() {
        return this.cropRegion;
    }

    public void setCropRegion(ImageDomainObject.CropRegion cropRegion) {
        this.cropRegion = cropRegion;
    }

    public Timestamp getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Timestamp createdDate) {
        this.createdDate = createdDate;
    }

    public int getMetaId() {
        return this.metaId;
    }

    public void setMetaId(int metaId) {
        this.metaId = metaId;
    }

    public int getImageIndex() {
        return this.imageIndex;
    }

    public void setImageIndex(int imageIndex) {
        this.imageIndex = imageIndex;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(int fileSize) {
        this.fileSize = fileSize;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).append(this.metaId).append(this.imageIndex).toHashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImageCacheDomainObject)) {
            return false;
        }
        ImageCacheDomainObject o = (ImageCacheDomainObject)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)o.getId()).append(this.metaId, o.getMetaId()).append(this.imageIndex, o.getImageIndex()).isEquals();
    }

    public String toString() {
        return String.format("imcode.server.document.textdocument.ImageCacheDomainObject[id: %s, metaId: %d, imageIndex: %d, resource: %s, type: %d, format: %s]", new Object[]{this.id, this.metaId, this.imageIndex, this.resource, this.type, this.format});
    }
}

