/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.textdocument.ImageSource;
import imcode.util.io.FileInputStreamSource;
import imcode.util.io.InputStreamSource;
import java.io.File;
import java.util.Date;

public class ImageArchiveImageSource
extends ImageSource {
    private static final long serialVersionUID = -1520182526108369695L;
    private String path;

    public ImageArchiveImageSource(String path) {
        this.path = path.replace('\\', '/');
    }

    public InputStreamSource getInputStreamSource() {
        return new FileInputStreamSource(this.getFile());
    }

    private File getFile() {
        ImcmsServices service = Imcms.getServices();
        File basePath = this.isAbsolute() ? Imcms.getPath() : service.getConfig().getImageArchiveImagePath();
        return new File(basePath, this.path);
    }

    public String getUrlPathRelativeToContextPath() {
        if (!this.isAbsolute()) {
            return ImageArchiveImageSource.getImagesUrlPath() + this.path;
        }
        return this.path;
    }

    private boolean isAbsolute() {
        return this.path.startsWith("/");
    }

    public static String getImagesUrlPath() {
        return Imcms.getServices().getConfig().getImageArchiveImageUrl();
    }

    public String toStorageString() {
        return this.path;
    }

    public int getTypeId() {
        return 2;
    }

    public Date getModifiedDatetime() {
        return new Date(this.getFile().lastModified());
    }
}

