/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.index;

import com.imcode.imcms.mapping.DocumentGetter;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.util.HumanReadable;
import imcode.server.Imcms;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.index.AnalyzerImpl;
import imcode.server.document.index.DirectoryIndex;
import imcode.server.document.index.DocumentQuery;
import imcode.server.document.index.IndexDocumentFactory;
import imcode.server.document.index.IndexException;
import imcode.server.user.UserDomainObject;
import imcode.util.IntervalSchedule;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;

class DefaultDirectoryIndex
implements DirectoryIndex {
    private static final Logger log = Logger.getLogger((String)DefaultDirectoryIndex.class.getName());
    private static final int INDEXING_LOG_PERIOD__MILLISECONDS = 60000;
    private final File directory;
    private final IndexDocumentFactory indexDocumentFactory;
    private boolean inconsistent;

    DefaultDirectoryIndex(File directory, IndexDocumentFactory indexDocumentFactory) {
        this.directory = directory;
        this.indexDocumentFactory = indexDocumentFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List search(DocumentQuery query, UserDomainObject searchingUser) throws IndexException {
        List list;
        IndexSearcher indexSearcher = new IndexSearcher(this.directory.toString());
        try {
            StopWatch searchStopWatch = new StopWatch();
            searchStopWatch.start();
            Hits hits = indexSearcher.search(query.getQuery(), query.getSort());
            long searchTime = searchStopWatch.getTime();
            List documentList = this.getDocumentListForHits(hits, searchingUser);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Search for " + query.getQuery().toString() + ": " + searchTime + "ms. Total: " + searchStopWatch.getTime() + "ms."));
            }
            list = documentList;
        }
        catch (Throwable throwable) {
            try {
                indexSearcher.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new IndexException(e);
            }
        }
        indexSearcher.close();
        return list;
    }

    public void rebuild() {
        try {
            this.indexAllDocuments();
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
    }

    private List getDocumentListForHits(Hits hits, final UserDomainObject searchingUser) {
        DocumentGetter documentGetter = Imcms.getServices().getDocumentMapper().getDocumentGetter();
        DocumentIdHitsList documentIds = new DocumentIdHitsList(hits);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        List documentList = documentGetter.getDocuments(documentIds);
        stopWatch.stop();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Got " + documentList.size() + " documents in " + stopWatch.getTime() + "ms."));
        }
        if (documentList.size() != hits.length()) {
            this.inconsistent = true;
        }
        CollectionUtils.filter((Collection)documentList, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                DocumentDomainObject document = (DocumentDomainObject)object;
                return searchingUser.canSearchFor(document);
            }
        });
        return documentList;
    }

    public void indexDocument(DocumentDomainObject document) throws IndexException {
        try {
            this.removeDocument(document);
            this.addDocument(document);
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocument(DocumentDomainObject document) throws IndexException {
        try {
            IndexReader indexReader = IndexReader.open((File)this.directory);
            try {
                indexReader.delete(new Term("meta_id", "" + document.getId()));
            }
            finally {
                indexReader.close();
            }
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDocument(DocumentDomainObject document) throws IOException {
        IndexWriter indexWriter = this.createIndexWriter(false);
        try {
            this.addDocumentToIndex(document, indexWriter);
        }
        finally {
            indexWriter.close();
        }
    }

    private IndexWriter createIndexWriter(boolean createIndex) throws IOException {
        return new IndexWriter(this.directory, (Analyzer)new AnalyzerImpl(), createIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexAllDocuments() throws IOException {
        IndexWriter indexWriter = this.createIndexWriter(true);
        try {
            this.indexAllDocumentsToIndexWriter(indexWriter);
        }
        finally {
            indexWriter.close();
        }
    }

    private void addDocumentToIndex(DocumentDomainObject document, IndexWriter indexWriter) throws IOException {
        Document indexDocument = this.indexDocumentFactory.createIndexDocument(document);
        indexWriter.addDocument(indexDocument);
    }

    private void indexAllDocumentsToIndexWriter(IndexWriter indexWriter) throws IOException {
        DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
        int[] documentIds = documentMapper.getAllDocumentIds();
        this.logIndexingStarting(documentIds.length);
        IntervalSchedule indexingLogSchedule = new IntervalSchedule(60000L);
        for (int i = 0; i < documentIds.length; ++i) {
            try {
                this.addDocumentToIndex(documentMapper.getDocument(documentIds[i]), indexWriter);
            }
            catch (Exception ex) {
                log.error((Object)("Could not index document with meta_id " + documentIds[i] + ", trying next document."), (Throwable)ex);
            }
            if (indexingLogSchedule.isTime()) {
                this.logIndexingProgress(i, documentIds.length, indexingLogSchedule.getStopWatch().getTime());
            }
            Thread.yield();
        }
        this.logIndexingCompleted(documentIds.length, indexingLogSchedule.getStopWatch());
        this.optimizeIndex(indexWriter);
    }

    private void logIndexingStarting(int documentCount) {
        log.debug((Object)("Building index of all " + documentCount + " documents"));
    }

    private void logIndexingProgress(int documentsCompleted, int numberOfDocuments, long elapsedTime) {
        int indexPercentageCompleted = (int)((float)documentsCompleted * (100.0f / (float)numberOfDocuments));
        long estimatedTime = (long)numberOfDocuments * elapsedTime / (long)documentsCompleted;
        long estimatedTimeLeft = estimatedTime - elapsedTime;
        Date eta = new Date(System.currentTimeMillis() + estimatedTimeLeft);
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        log.info((Object)("Indexed " + documentsCompleted + " documents (" + indexPercentageCompleted + "%). ETA " + dateFormat.format(eta)));
    }

    private void logIndexingCompleted(int numberOfDocuments, StopWatch indexingStopWatch) {
        long time = indexingStopWatch.getTime();
        String humanReadableTime = HumanReadable.getHumanReadableTimeSpan((long)time);
        long timePerDocument = time / (long)numberOfDocuments;
        log.debug((Object)("Indexed " + numberOfDocuments + " documents in " + humanReadableTime + ". " + timePerDocument + "ms per document."));
    }

    private void optimizeIndex(IndexWriter indexWriter) throws IOException {
        StopWatch optimizeStopWatch = new StopWatch();
        optimizeStopWatch.start();
        indexWriter.optimize();
        optimizeStopWatch.stop();
        log.debug((Object)("Optimized index in " + optimizeStopWatch.getTime() + "ms"));
    }

    public boolean isInconsistent() {
        return this.inconsistent;
    }

    public void delete() {
        try {
            log.debug((Object)("Deleting index directory " + this.directory));
            FileUtils.forceDelete((File)this.directory);
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDirectoryIndex that = (DefaultDirectoryIndex)o;
        return this.directory.equals(that.directory);
    }

    public int hashCode() {
        return this.directory.hashCode();
    }

    static {
        BooleanQuery.setMaxClauseCount((int)Integer.MAX_VALUE);
    }

    private static class DocumentIdHitsList
    extends AbstractList {
        private final Hits hits;

        DocumentIdHitsList(Hits hits) {
            this.hits = hits;
        }

        public Object get(int index) {
            try {
                return new Integer(Integer.parseInt(this.hits.doc(index).get("meta_id")));
            }
            catch (IOException e) {
                throw new IndexException(e);
            }
        }

        public int size() {
            return this.hits.length();
        }
    }
}

