/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.document.UrlDocumentDomainObject;
import junit.framework.TestCase;

public class TestUrlDocumentDomainObject
extends TestCase {
    UrlDocumentDomainObject urlDocument;
    private static final String HOSTNAME = "example.invalid";

    protected void setUp() throws Exception {
        super.setUp();
        this.urlDocument = new UrlDocumentDomainObject();
    }

    public void testLocalPath() {
        this.urlDocument.setUrl("/foo/bar");
        TestUrlDocumentDomainObject.assertEquals((String)"/foo/bar", (String)this.urlDocument.getUrl());
        this.urlDocument.setUrl("http:/foo/bar");
        TestUrlDocumentDomainObject.assertEquals((String)"http:/foo/bar", (String)this.urlDocument.getUrl());
    }

    public void testRelativeLocalPath() {
        this.urlDocument.setUrl("./foo/bar");
        TestUrlDocumentDomainObject.assertEquals((String)"./foo/bar", (String)this.urlDocument.getUrl());
        this.urlDocument.setUrl("http:foo/bar");
        TestUrlDocumentDomainObject.assertEquals((String)"http:foo/bar", (String)this.urlDocument.getUrl());
    }

    public void testHttpUrl() {
        this.urlDocument.setUrl("http://example.invalid");
        TestUrlDocumentDomainObject.assertEquals((String)"http://example.invalid", (String)this.urlDocument.getUrl());
    }

    public void testFtpUrl() {
        this.urlDocument.setUrl("ftp://example.invalid");
        TestUrlDocumentDomainObject.assertEquals((String)"ftp://example.invalid", (String)this.urlDocument.getUrl());
    }

    public void testUrlWithoutScheme() {
        this.urlDocument.setUrl(HOSTNAME);
        TestUrlDocumentDomainObject.assertEquals((String)"http://example.invalid", (String)this.urlDocument.getUrl());
    }

    public void testFtpUrlWithoutScheme() {
        this.urlDocument.setUrl("ftp.example.invalid");
        TestUrlDocumentDomainObject.assertEquals((String)"ftp://ftp.example.invalid", (String)this.urlDocument.getUrl());
    }
}

